package org.apache.polaris.core.admin.model;

import java.util.Objects;
import java.util.ArrayList;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.polaris.core.admin.model.StorageConfigInfo;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import io.swagger.annotations.*;
import jakarta.validation.Valid;

@ApiModel(description="azure storage configuration info")@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaResteasyServerCodegen", date = "2025-12-29T15:11:10.844412180Z[UTC]", comments = "Generator version: 7.12.0")public class AzureStorageConfigInfo extends StorageConfigInfo  {

  @NotNull
  private final String tenantId;
  private final String multiTenantAppName;
  private final String consentUrl;
    /**
     * the tenant id that the storage accounts belong to
     **/
    @ApiModelProperty(required = true, value = "the tenant id that the storage accounts belong to")
    @JsonProperty(value = "tenantId", required = true)
    public String getTenantId() {
        return tenantId;
    }
    
    /**
     * the name of the azure client application
     **/
    @ApiModelProperty(value = "the name of the azure client application")
    @JsonProperty(value = "multiTenantAppName")
    public String getMultiTenantAppName() {
        return multiTenantAppName;
    }
    
    /**
     * URL to the Azure permissions request page
     **/
    @ApiModelProperty(value = "URL to the Azure permissions request page")
    @JsonProperty(value = "consentUrl")
    public String getConsentUrl() {
        return consentUrl;
    }
    
    @JsonCreator
    public AzureStorageConfigInfo(@JsonProperty(value = "tenantId", required = true) String tenantId, @JsonProperty(value = "multiTenantAppName") String multiTenantAppName, @JsonProperty(value = "consentUrl") String consentUrl, @JsonProperty(value = "storageType", required = true) StorageTypeEnum storageType, @JsonProperty(value = "allowedLocations") List<String> allowedLocations) {
        super(storageType, allowedLocations);
        this.tenantId = tenantId;
        this.multiTenantAppName = multiTenantAppName;
        this.consentUrl = consentUrl;
    }


    public AzureStorageConfigInfo(String tenantId, StorageTypeEnum storageType) {
        super(storageType);
        this.tenantId = tenantId;
        this.multiTenantAppName = null;
        this.consentUrl = null;
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(String tenantId, StorageTypeEnum storageType) {
        return new Builder(tenantId, storageType);
    }


    public static final class Builder {
      private String tenantId;
      private String multiTenantAppName;
      private String consentUrl;
      private StorageTypeEnum storageType;
      private List<String> allowedLocations;
      private Builder() {
      }
      private Builder(String tenantId, StorageTypeEnum storageType) {
        this.tenantId = tenantId;
        this.storageType = storageType;
      }

      public Builder setTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
      }
      public Builder setMultiTenantAppName(String multiTenantAppName) {
        this.multiTenantAppName = multiTenantAppName;
        return this;
      }
      public Builder setConsentUrl(String consentUrl) {
        this.consentUrl = consentUrl;
        return this;
      }
      public Builder setStorageType(StorageTypeEnum storageType) {
        this.storageType = storageType;
        return this;
      }
      public Builder setAllowedLocations(List<String> allowedLocations) {
        this.allowedLocations = allowedLocations;
        return this;
      }


      public AzureStorageConfigInfo build() {
        AzureStorageConfigInfo inst = new AzureStorageConfigInfo(tenantId, multiTenantAppName, consentUrl, storageType, allowedLocations);
        return inst;
      }
    }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AzureStorageConfigInfo azureStorageConfigInfo = (AzureStorageConfigInfo) o;
    return super.equals(o) && Objects.equals(this.tenantId, azureStorageConfigInfo.tenantId) &&
        Objects.equals(this.multiTenantAppName, azureStorageConfigInfo.multiTenantAppName) &&
        Objects.equals(this.consentUrl, azureStorageConfigInfo.consentUrl);
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), tenantId, super.hashCode(), multiTenantAppName, super.hashCode(), consentUrl);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AzureStorageConfigInfo {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    tenantId: ").append(toIndentedString(tenantId)).append("\n");
    sb.append("    multiTenantAppName: ").append(toIndentedString(multiTenantAppName)).append("\n");
    sb.append("    consentUrl: ").append(toIndentedString(consentUrl)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
