package org.apache.polaris.core.admin.model;

import java.util.Objects;
import java.util.ArrayList;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.polaris.core.admin.model.ServiceIdentityInfo;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import io.swagger.annotations.*;
import jakarta.validation.Valid;

@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaResteasyServerCodegen", date = "2025-12-29T15:11:10.844412180Z[UTC]", comments = "Generator version: 7.12.0")public class AwsIamServiceIdentityInfo extends ServiceIdentityInfo  {

  @NotNull
  private final String iamArn;
    /**
     * The ARN of the IAM user or IAM role Polaris uses to assume roles and then access external resources.
     **/
    @ApiModelProperty(example = "arn:aws:iam::111122223333:user/polaris-service-user", required = true, value = "The ARN of the IAM user or IAM role Polaris uses to assume roles and then access external resources.")
    @JsonProperty(value = "iamArn", required = true)
    public String getIamArn() {
        return iamArn;
    }
    
    @JsonCreator
    public AwsIamServiceIdentityInfo(@JsonProperty(value = "iamArn", required = true) String iamArn, @JsonProperty(value = "identityType", required = true) IdentityTypeEnum identityType) {
        super(identityType);
        this.iamArn = iamArn;
    }



    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(String iamArn, IdentityTypeEnum identityType) {
        return new Builder(iamArn, identityType);
    }


    public static final class Builder {
      private String iamArn;
      private IdentityTypeEnum identityType;
      private Builder() {
      }
      private Builder(String iamArn, IdentityTypeEnum identityType) {
        this.iamArn = iamArn;
        this.identityType = identityType;
      }

      public Builder setIamArn(String iamArn) {
        this.iamArn = iamArn;
        return this;
      }
      public Builder setIdentityType(IdentityTypeEnum identityType) {
        this.identityType = identityType;
        return this;
      }


      public AwsIamServiceIdentityInfo build() {
        AwsIamServiceIdentityInfo inst = new AwsIamServiceIdentityInfo(iamArn, identityType);
        return inst;
      }
    }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AwsIamServiceIdentityInfo awsIamServiceIdentityInfo = (AwsIamServiceIdentityInfo) o;
    return super.equals(o) && Objects.equals(this.iamArn, awsIamServiceIdentityInfo.iamArn);
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), iamArn);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AwsIamServiceIdentityInfo {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    iamArn: ").append(toIndentedString(iamArn)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
