package org.apache.polaris.core.admin.model;

import java.util.Objects;
import java.util.ArrayList;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import io.swagger.annotations.*;
import jakarta.validation.Valid;

@ApiModel(description="Authentication-specific information for a connection")@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaResteasyServerCodegen", date = "2025-12-29T15:11:10.844412180Z[UTC]", comments = "Generator version: 7.12.0")@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.EXISTING_PROPERTY,
    property = "authenticationType",
    visible = true
)
@JsonSubTypes({
    @JsonSubTypes.Type(value = BearerAuthenticationParameters.class, name = "BEARER"),
    @JsonSubTypes.Type(value = OAuthClientCredentialsParameters.class, name = "OAUTH"),
    @JsonSubTypes.Type(value = SigV4AuthenticationParameters.class, name = "SIGV4")
})public class AuthenticationParameters   {

      /**
   * The type of authentication to use when connecting to the remote rest service
   */
  public enum AuthenticationTypeEnum {
    OAUTH("OAUTH"),

        BEARER("BEARER"),

        SIGV4("SIGV4");
    private String value;

    AuthenticationTypeEnum(String value) {
      this.value = value;
    }

    @Override
    @JsonValue
    public String toString() {
      return String.valueOf(value);
    }
  }

  @NotNull
  private final AuthenticationTypeEnum authenticationType;
    /**
     * The type of authentication to use when connecting to the remote rest service
     **/
    @ApiModelProperty(required = true, value = "The type of authentication to use when connecting to the remote rest service")
    @JsonProperty(value = "authenticationType", required = true)
    public AuthenticationTypeEnum getAuthenticationType() {
        return authenticationType;
    }
    
    @JsonCreator
    public AuthenticationParameters(@JsonProperty(value = "authenticationType", required = true) AuthenticationTypeEnum authenticationType) {
        this.authenticationType = authenticationType;
    }





    public static final class Builder {
      private AuthenticationTypeEnum authenticationType;
      private Builder() {
      }
      private Builder(AuthenticationTypeEnum authenticationType) {
        this.authenticationType = authenticationType;
      }

      public Builder setAuthenticationType(AuthenticationTypeEnum authenticationType) {
        this.authenticationType = authenticationType;
        return this;
      }


      public AuthenticationParameters build() {
        AuthenticationParameters inst = new AuthenticationParameters(authenticationType);
        return inst;
      }
    }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AuthenticationParameters authenticationParameters = (AuthenticationParameters) o;
    return Objects.equals(this.authenticationType, authenticationParameters.authenticationType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(authenticationType);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AuthenticationParameters {\n");
    
    sb.append("    authenticationType: ").append(toIndentedString(authenticationType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
