/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.admin.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import org.apache.polaris.core.admin.model.AuthenticationParameters;
import org.apache.polaris.core.admin.model.HadoopConnectionConfigInfo;
import org.apache.polaris.core.admin.model.IcebergRestConnectionConfigInfo;
import org.apache.polaris.core.admin.model.ServiceIdentityInfo;

@ApiModel(description="A connection configuration representing a remote catalog service. IMPORTANT - Specifying a ConnectionConfigInfo in an ExternalCatalog is currently an experimental API and is subject to change.")
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="connectionType", visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=HadoopConnectionConfigInfo.class, name="HADOOP"), @JsonSubTypes.Type(value=IcebergRestConnectionConfigInfo.class, name="ICEBERG_REST")})
public class ConnectionConfigInfo {
    @NotNull
    private final ConnectionTypeEnum connectionType;
    private final String uri;
    @Valid
    private final AuthenticationParameters authenticationParameters;
    @Valid
    private final ServiceIdentityInfo serviceIdentity;

    @ApiModelProperty(required=true, value="The type of remote catalog service represented by this connection")
    @JsonProperty(value="connectionType", required=true)
    public ConnectionTypeEnum getConnectionType() {
        return this.connectionType;
    }

    @ApiModelProperty(value="URI to the remote catalog service")
    @JsonProperty(value="uri")
    public String getUri() {
        return this.uri;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="authenticationParameters")
    public AuthenticationParameters getAuthenticationParameters() {
        return this.authenticationParameters;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="serviceIdentity")
    public ServiceIdentityInfo getServiceIdentity() {
        return this.serviceIdentity;
    }

    @JsonCreator
    public ConnectionConfigInfo(@JsonProperty(value="connectionType", required=true) ConnectionTypeEnum connectionType, @JsonProperty(value="uri") String uri, @JsonProperty(value="authenticationParameters") AuthenticationParameters authenticationParameters, @JsonProperty(value="serviceIdentity") ServiceIdentityInfo serviceIdentity) {
        this.connectionType = connectionType;
        this.uri = uri;
        this.authenticationParameters = authenticationParameters;
        this.serviceIdentity = serviceIdentity;
    }

    public ConnectionConfigInfo(ConnectionTypeEnum connectionType) {
        this.connectionType = connectionType;
        this.uri = null;
        this.authenticationParameters = null;
        this.serviceIdentity = null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectionConfigInfo connectionConfigInfo = (ConnectionConfigInfo)o;
        return Objects.equals((Object)this.connectionType, (Object)connectionConfigInfo.connectionType) && Objects.equals(this.uri, connectionConfigInfo.uri) && Objects.equals(this.authenticationParameters, connectionConfigInfo.authenticationParameters) && Objects.equals(this.serviceIdentity, connectionConfigInfo.serviceIdentity);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.connectionType, this.uri, this.authenticationParameters, this.serviceIdentity});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConnectionConfigInfo {\n");
        sb.append("    connectionType: ").append(this.toIndentedString((Object)this.connectionType)).append("\n");
        sb.append("    uri: ").append(this.toIndentedString(this.uri)).append("\n");
        sb.append("    authenticationParameters: ").append(this.toIndentedString(this.authenticationParameters)).append("\n");
        sb.append("    serviceIdentity: ").append(this.toIndentedString(this.serviceIdentity)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum ConnectionTypeEnum {
        ICEBERG_REST("ICEBERG_REST"),
        HADOOP("HADOOP");

        private String value;

        private ConnectionTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }
    }

    public static final class Builder {
        private ConnectionTypeEnum connectionType;
        private String uri;
        private AuthenticationParameters authenticationParameters;
        private ServiceIdentityInfo serviceIdentity;

        private Builder() {
        }

        private Builder(ConnectionTypeEnum connectionType) {
            this.connectionType = connectionType;
        }

        public Builder setConnectionType(ConnectionTypeEnum connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        public Builder setUri(String uri) {
            this.uri = uri;
            return this;
        }

        public Builder setAuthenticationParameters(AuthenticationParameters authenticationParameters) {
            this.authenticationParameters = authenticationParameters;
            return this;
        }

        public Builder setServiceIdentity(ServiceIdentityInfo serviceIdentity) {
            this.serviceIdentity = serviceIdentity;
            return this;
        }

        public ConnectionConfigInfo build() {
            ConnectionConfigInfo inst = new ConnectionConfigInfo(this.connectionType, this.uri, this.authenticationParameters, this.serviceIdentity);
            return inst;
        }
    }
}

