/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.core.admin.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import jakarta.validation.constraints.Size;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class CatalogRole {
    @NotNull
    @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$")
    @Size(min=1, max=256)
    private final @NotNull @Pattern(regexp="^(?!\\s*[s|S][y|Y][s|S][t|T][e|E][m|M]\\$).*$") @Size(min=1, max=256) String name;
    private final Map<String, String> properties;
    private final Long createTimestamp;
    private final Long lastUpdateTimestamp;
    private final Integer entityVersion;

    @ApiModelProperty(required=true, value="The name of the role")
    @JsonProperty(value="name", required=true)
    public String getName() {
        return this.name;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="properties")
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="createTimestamp")
    public Long getCreateTimestamp() {
        return this.createTimestamp;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="lastUpdateTimestamp")
    public Long getLastUpdateTimestamp() {
        return this.lastUpdateTimestamp;
    }

    @ApiModelProperty(value="The version of the catalog role object used to determine if the catalog role metadata has changed")
    @JsonProperty(value="entityVersion")
    public Integer getEntityVersion() {
        return this.entityVersion;
    }

    @JsonCreator
    public CatalogRole(@JsonProperty(value="name", required=true) String name, @JsonProperty(value="properties") Map<String, String> properties, @JsonProperty(value="createTimestamp") Long createTimestamp, @JsonProperty(value="lastUpdateTimestamp") Long lastUpdateTimestamp, @JsonProperty(value="entityVersion") Integer entityVersion) {
        this.name = name;
        this.properties = Objects.requireNonNullElse(properties, new HashMap());
        this.createTimestamp = createTimestamp;
        this.lastUpdateTimestamp = lastUpdateTimestamp;
        this.entityVersion = entityVersion;
    }

    public CatalogRole(String name) {
        this.name = name;
        this.properties = new HashMap<String, String>();
        this.createTimestamp = null;
        this.lastUpdateTimestamp = null;
        this.entityVersion = null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CatalogRole catalogRole = (CatalogRole)o;
        return Objects.equals(this.name, catalogRole.name) && Objects.equals(this.properties, catalogRole.properties) && Objects.equals(this.createTimestamp, catalogRole.createTimestamp) && Objects.equals(this.lastUpdateTimestamp, catalogRole.lastUpdateTimestamp) && Objects.equals(this.entityVersion, catalogRole.entityVersion);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.properties, this.createTimestamp, this.lastUpdateTimestamp, this.entityVersion);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CatalogRole {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("    createTimestamp: ").append(this.toIndentedString(this.createTimestamp)).append("\n");
        sb.append("    lastUpdateTimestamp: ").append(this.toIndentedString(this.lastUpdateTimestamp)).append("\n");
        sb.append("    entityVersion: ").append(this.toIndentedString(this.entityVersion)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static final class Builder {
        private String name;
        private Map<String, String> properties;
        private Long createTimestamp;
        private Long lastUpdateTimestamp;
        private Integer entityVersion;

        private Builder() {
        }

        private Builder(String name) {
            this.name = name;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setProperties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        public Builder setCreateTimestamp(Long createTimestamp) {
            this.createTimestamp = createTimestamp;
            return this;
        }

        public Builder setLastUpdateTimestamp(Long lastUpdateTimestamp) {
            this.lastUpdateTimestamp = lastUpdateTimestamp;
            return this;
        }

        public Builder setEntityVersion(Integer entityVersion) {
            this.entityVersion = entityVersion;
            return this;
        }

        public CatalogRole build() {
            CatalogRole inst = new CatalogRole(this.name, this.properties, this.createTimestamp, this.lastUpdateTimestamp, this.entityVersion);
            return inst;
        }
    }
}

