package org.apache.polaris.core.admin.model;

import java.util.Objects;
import java.util.ArrayList;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.polaris.core.admin.model.GrantResource;
import org.apache.polaris.core.admin.model.ViewPrivilege;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import io.swagger.annotations.*;
import jakarta.validation.Valid;

@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaResteasyServerCodegen", date = "2025-10-06T09:01:49.457542507Z[UTC]", comments = "Generator version: 7.12.0")public class ViewGrant extends GrantResource  {

  @NotNull
  private final List<String> namespace;
  @NotNull
 @Size(min=1,max=256)  private final String viewName;
  @NotNull
  @Valid
  private final ViewPrivilege privilege;
    /**
     **/
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(value = "namespace", required = true)
    public List<String> getNamespace() {
        return namespace;
    }
    
    /**
     **/
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(value = "viewName", required = true)
    public String getViewName() {
        return viewName;
    }
    
    /**
     **/
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(value = "privilege", required = true)
    public ViewPrivilege getPrivilege() {
        return privilege;
    }
    
    @JsonCreator
    public ViewGrant(@JsonProperty(value = "namespace", required = true) List<String> namespace, @JsonProperty(value = "viewName", required = true) String viewName, @JsonProperty(value = "privilege", required = true) ViewPrivilege privilege, @JsonProperty(value = "type", required = true) TypeEnum type) {
        super(type);
        this.namespace = Objects.requireNonNullElse(namespace, new ArrayList<>());
        this.viewName = viewName;
        this.privilege = privilege;
    }



    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(List<String> namespace, String viewName, ViewPrivilege privilege, TypeEnum type) {
        return new Builder(namespace, viewName, privilege, type);
    }


    public static final class Builder {
      private List<String> namespace;
      private String viewName;
      private ViewPrivilege privilege;
      private TypeEnum type;
      private Builder() {
      }
      private Builder(List<String> namespace, String viewName, ViewPrivilege privilege, TypeEnum type) {
        this.namespace = Objects.requireNonNullElse(namespace, new ArrayList<>());
        this.viewName = viewName;
        this.privilege = privilege;
        this.type = type;
      }

      public Builder setNamespace(List<String> namespace) {
        this.namespace = namespace;
        return this;
      }
      public Builder setViewName(String viewName) {
        this.viewName = viewName;
        return this;
      }
      public Builder setPrivilege(ViewPrivilege privilege) {
        this.privilege = privilege;
        return this;
      }
      public Builder setType(TypeEnum type) {
        this.type = type;
        return this;
      }


      public ViewGrant build() {
        ViewGrant inst = new ViewGrant(namespace, viewName, privilege, type);
        return inst;
      }
    }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ViewGrant viewGrant = (ViewGrant) o;
    return super.equals(o) && Objects.equals(this.namespace, viewGrant.namespace) &&
        Objects.equals(this.viewName, viewGrant.viewName) &&
        Objects.equals(this.privilege, viewGrant.privilege);
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), namespace, super.hashCode(), viewName, super.hashCode(), privilege);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ViewGrant {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    namespace: ").append(toIndentedString(namespace)).append("\n");
    sb.append("    viewName: ").append(toIndentedString(viewName)).append("\n");
    sb.append("    privilege: ").append(toIndentedString(privilege)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
