package org.apache.polaris.core.admin.model;

import java.util.Objects;
import java.util.ArrayList;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import org.apache.polaris.core.admin.model.StorageConfigInfo;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import io.swagger.annotations.*;
import jakarta.validation.Valid;

@ApiModel(description="Updates to apply to a Catalog. Any fields which are required in the Catalog will remain unaltered if omitted from the contents of this Update request.")@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaResteasyServerCodegen", date = "2025-10-06T09:01:49.457542507Z[UTC]", comments = "Generator version: 7.12.0")public class UpdateCatalogRequest   {

  private final Integer currentEntityVersion;
  private final Map<String, String> properties;
  @Valid
  private final StorageConfigInfo storageConfigInfo;
    /**
     * The version of the object onto which this update is applied; if the object changed, the update will fail and the caller should retry after fetching the latest version.
     **/
    @ApiModelProperty(value = "The version of the object onto which this update is applied; if the object changed, the update will fail and the caller should retry after fetching the latest version.")
    @JsonProperty(value = "currentEntityVersion")
    public Integer getCurrentEntityVersion() {
        return currentEntityVersion;
    }
    
    /**
     **/
    @ApiModelProperty(value = "")
    @JsonProperty(value = "properties")
    public Map<String, String> getProperties() {
        return properties;
    }
    
    /**
     **/
    @ApiModelProperty(value = "")
    @JsonProperty(value = "storageConfigInfo")
    public StorageConfigInfo getStorageConfigInfo() {
        return storageConfigInfo;
    }
    
    @JsonCreator
    public UpdateCatalogRequest(@JsonProperty(value = "currentEntityVersion") Integer currentEntityVersion, @JsonProperty(value = "properties") Map<String, String> properties, @JsonProperty(value = "storageConfigInfo") StorageConfigInfo storageConfigInfo) {
        this.currentEntityVersion = currentEntityVersion;
        this.properties = Objects.requireNonNullElse(properties, new HashMap<>());
        this.storageConfigInfo = storageConfigInfo;
    }



    public static Builder builder() {
        return new Builder();
    }


    public static final class Builder {
      private Integer currentEntityVersion;
      private Map<String, String> properties;
      private StorageConfigInfo storageConfigInfo;
      private Builder() {
      }

      public Builder setCurrentEntityVersion(Integer currentEntityVersion) {
        this.currentEntityVersion = currentEntityVersion;
        return this;
      }
      public Builder setProperties(Map<String, String> properties) {
        this.properties = properties;
        return this;
      }
      public Builder setStorageConfigInfo(StorageConfigInfo storageConfigInfo) {
        this.storageConfigInfo = storageConfigInfo;
        return this;
      }


      public UpdateCatalogRequest build() {
        UpdateCatalogRequest inst = new UpdateCatalogRequest(currentEntityVersion, properties, storageConfigInfo);
        return inst;
      }
    }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    UpdateCatalogRequest updateCatalogRequest = (UpdateCatalogRequest) o;
    return Objects.equals(this.currentEntityVersion, updateCatalogRequest.currentEntityVersion) &&
        Objects.equals(this.properties, updateCatalogRequest.properties) &&
        Objects.equals(this.storageConfigInfo, updateCatalogRequest.storageConfigInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(currentEntityVersion, properties, storageConfigInfo);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class UpdateCatalogRequest {\n");
    
    sb.append("    currentEntityVersion: ").append(toIndentedString(currentEntityVersion)).append("\n");
    sb.append("    properties: ").append(toIndentedString(properties)).append("\n");
    sb.append("    storageConfigInfo: ").append(toIndentedString(storageConfigInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
