package org.apache.polaris.core.admin.model;

import java.util.Objects;
import java.util.ArrayList;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.polaris.core.admin.model.GrantResource;
import org.apache.polaris.core.admin.model.TablePrivilege;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import io.swagger.annotations.*;
import jakarta.validation.Valid;

@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaResteasyServerCodegen", date = "2025-10-06T09:01:49.457542507Z[UTC]", comments = "Generator version: 7.12.0")public class TableGrant extends GrantResource  {

  @NotNull
  private final List<String> namespace;
  @NotNull
 @Size(min=1,max=256)  private final String tableName;
  @NotNull
  @Valid
  private final TablePrivilege privilege;
    /**
     **/
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(value = "namespace", required = true)
    public List<String> getNamespace() {
        return namespace;
    }
    
    /**
     **/
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(value = "tableName", required = true)
    public String getTableName() {
        return tableName;
    }
    
    /**
     **/
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(value = "privilege", required = true)
    public TablePrivilege getPrivilege() {
        return privilege;
    }
    
    @JsonCreator
    public TableGrant(@JsonProperty(value = "namespace", required = true) List<String> namespace, @JsonProperty(value = "tableName", required = true) String tableName, @JsonProperty(value = "privilege", required = true) TablePrivilege privilege, @JsonProperty(value = "type", required = true) TypeEnum type) {
        super(type);
        this.namespace = Objects.requireNonNullElse(namespace, new ArrayList<>());
        this.tableName = tableName;
        this.privilege = privilege;
    }



    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(List<String> namespace, String tableName, TablePrivilege privilege, TypeEnum type) {
        return new Builder(namespace, tableName, privilege, type);
    }


    public static final class Builder {
      private List<String> namespace;
      private String tableName;
      private TablePrivilege privilege;
      private TypeEnum type;
      private Builder() {
      }
      private Builder(List<String> namespace, String tableName, TablePrivilege privilege, TypeEnum type) {
        this.namespace = Objects.requireNonNullElse(namespace, new ArrayList<>());
        this.tableName = tableName;
        this.privilege = privilege;
        this.type = type;
      }

      public Builder setNamespace(List<String> namespace) {
        this.namespace = namespace;
        return this;
      }
      public Builder setTableName(String tableName) {
        this.tableName = tableName;
        return this;
      }
      public Builder setPrivilege(TablePrivilege privilege) {
        this.privilege = privilege;
        return this;
      }
      public Builder setType(TypeEnum type) {
        this.type = type;
        return this;
      }


      public TableGrant build() {
        TableGrant inst = new TableGrant(namespace, tableName, privilege, type);
        return inst;
      }
    }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TableGrant tableGrant = (TableGrant) o;
    return super.equals(o) && Objects.equals(this.namespace, tableGrant.namespace) &&
        Objects.equals(this.tableName, tableGrant.tableName) &&
        Objects.equals(this.privilege, tableGrant.privilege);
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), namespace, super.hashCode(), tableName, super.hashCode(), privilege);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TableGrant {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    namespace: ").append(toIndentedString(namespace)).append("\n");
    sb.append("    tableName: ").append(toIndentedString(tableName)).append("\n");
    sb.append("    privilege: ").append(toIndentedString(privilege)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
