package org.apache.polaris.core.admin.model;

import java.util.Objects;
import java.util.ArrayList;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.polaris.core.admin.model.StorageConfigInfo;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import io.swagger.annotations.*;
import jakarta.validation.Valid;

@ApiModel(description="file storage configuration info")@com.fasterxml.jackson.annotation.JsonInclude(com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL)
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaResteasyServerCodegen", date = "2025-10-06T09:01:49.457542507Z[UTC]", comments = "Generator version: 7.12.0")public class FileStorageConfigInfo extends StorageConfigInfo  {

    @JsonCreator
    public FileStorageConfigInfo(@JsonProperty("storageType") StorageTypeEnum storageType, @JsonProperty("allowedLocations") List<String> allowedLocations) {
        super(storageType, allowedLocations);
    }


    public FileStorageConfigInfo(StorageTypeEnum storageType) {
        super(storageType);
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(StorageTypeEnum storageType) {
        return new Builder(storageType);
    }


    public static final class Builder {
      private StorageTypeEnum storageType;
      private List<String> allowedLocations;
      private Builder() {
      }
      private Builder(StorageTypeEnum storageType) {
        this.storageType = storageType;
      }

      public Builder setStorageType(StorageTypeEnum storageType) {
        this.storageType = storageType;
        return this;
      }
      public Builder setAllowedLocations(List<String> allowedLocations) {
        this.allowedLocations = allowedLocations;
        return this;
      }


      public FileStorageConfigInfo build() {
        FileStorageConfigInfo inst = new FileStorageConfigInfo(storageType, allowedLocations);
        return inst;
      }
    }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FileStorageConfigInfo fileStorageConfigInfo = (FileStorageConfigInfo) o;return super.equals(o);
  }

  @Override
  public int hashCode() {
    return super.hashCode();
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FileStorageConfigInfo {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
