package org.apache.polaris.service.catalog.api;



import org.apache.polaris.service.types.CommitTableRequest;
import org.apache.iceberg.rest.requests.CommitTransactionRequest;
import org.apache.polaris.service.types.CommitViewRequest;
import org.apache.iceberg.rest.requests.CreateNamespaceRequest;
import org.apache.iceberg.rest.responses.CreateNamespaceResponse;
import org.apache.iceberg.rest.requests.CreateTableRequest;
import org.apache.iceberg.rest.requests.CreateViewRequest;
import org.apache.iceberg.rest.responses.GetNamespaceResponse;
import org.apache.iceberg.rest.responses.ErrorResponse;
import org.apache.iceberg.rest.responses.ListNamespacesResponse;
import org.apache.iceberg.rest.responses.ListTablesResponse;
import org.apache.iceberg.rest.responses.LoadCredentialsResponse;
import org.apache.iceberg.rest.responses.LoadTableResponse;
import org.apache.polaris.service.types.NotificationRequest;
import org.apache.iceberg.rest.requests.RegisterTableRequest;
import org.apache.iceberg.rest.requests.RenameTableRequest;
import org.apache.iceberg.rest.requests.ReportMetricsRequest;
import org.apache.iceberg.rest.requests.UpdateNamespacePropertiesRequest;
import org.apache.iceberg.rest.responses.UpdateNamespacePropertiesResponse;

import java.util.List;

import java.io.InputStream;

import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;

import org.apache.polaris.core.context.RealmContext;

/**
 * Service interface for implementations of the IcebergRestCatalogApiService. Provides default
 * implemntations for all service methods that return 501 error codes (not implemented).
 *
 * This file is automatically generated by the OpenAPI Code Generator based on configuration in the
 * pom.xml file in the module.
 *
 */
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaResteasyServerCodegen", date = "2025-12-29T15:11:16.406523497Z[UTC]", comments = "Generator version: 7.12.0")
public interface IcebergRestCatalogApiService {
  default Response commitTransaction(String prefix,CommitTransactionRequest commitTransactionRequest,RealmContext realmContext,SecurityContext securityContext) {
    return Response.status(501).build(); // not implemented
  }
  default Response createNamespace(String prefix,CreateNamespaceRequest createNamespaceRequest,RealmContext realmContext,SecurityContext securityContext) {
    return Response.status(501).build(); // not implemented
  }
  default Response createTable(String prefix,String namespace,CreateTableRequest createTableRequest,String xIcebergAccessDelegation,RealmContext realmContext,SecurityContext securityContext) {
    return Response.status(501).build(); // not implemented
  }
  default Response createView(String prefix,String namespace,CreateViewRequest createViewRequest,RealmContext realmContext,SecurityContext securityContext) {
    return Response.status(501).build(); // not implemented
  }
  default Response dropNamespace(String prefix,String namespace,RealmContext realmContext,SecurityContext securityContext) {
    return Response.status(501).build(); // not implemented
  }
  default Response dropTable(String prefix,String namespace,String table,Boolean purgeRequested,RealmContext realmContext,SecurityContext securityContext) {
    return Response.status(501).build(); // not implemented
  }
  default Response dropView(String prefix,String namespace,String view,RealmContext realmContext,SecurityContext securityContext) {
    return Response.status(501).build(); // not implemented
  }
  default Response listNamespaces(String prefix,String pageToken,Integer pageSize,String parent,RealmContext realmContext,SecurityContext securityContext) {
    return Response.status(501).build(); // not implemented
  }
  default Response listTables(String prefix,String namespace,String pageToken,Integer pageSize,RealmContext realmContext,SecurityContext securityContext) {
    return Response.status(501).build(); // not implemented
  }
  default Response listViews(String prefix,String namespace,String pageToken,Integer pageSize,RealmContext realmContext,SecurityContext securityContext) {
    return Response.status(501).build(); // not implemented
  }
  default Response loadCredentials(String prefix,String namespace,String table,RealmContext realmContext,SecurityContext securityContext) {
    return Response.status(501).build(); // not implemented
  }
  default Response loadNamespaceMetadata(String prefix,String namespace,RealmContext realmContext,SecurityContext securityContext) {
    return Response.status(501).build(); // not implemented
  }
  default Response loadTable(String prefix,String namespace,String table,String xIcebergAccessDelegation,String ifNoneMatch,String snapshots,RealmContext realmContext,SecurityContext securityContext) {
    return Response.status(501).build(); // not implemented
  }
  default Response loadView(String prefix,String namespace,String view,RealmContext realmContext,SecurityContext securityContext) {
    return Response.status(501).build(); // not implemented
  }
  default Response namespaceExists(String prefix,String namespace,RealmContext realmContext,SecurityContext securityContext) {
    return Response.status(501).build(); // not implemented
  }
  default Response registerTable(String prefix,String namespace,RegisterTableRequest registerTableRequest,RealmContext realmContext,SecurityContext securityContext) {
    return Response.status(501).build(); // not implemented
  }
  default Response renameTable(String prefix,RenameTableRequest renameTableRequest,RealmContext realmContext,SecurityContext securityContext) {
    return Response.status(501).build(); // not implemented
  }
  default Response renameView(String prefix,RenameTableRequest renameTableRequest,RealmContext realmContext,SecurityContext securityContext) {
    return Response.status(501).build(); // not implemented
  }
  default Response replaceView(String prefix,String namespace,String view,CommitViewRequest commitViewRequest,RealmContext realmContext,SecurityContext securityContext) {
    return Response.status(501).build(); // not implemented
  }
  default Response reportMetrics(String prefix,String namespace,String table,ReportMetricsRequest reportMetricsRequest,RealmContext realmContext,SecurityContext securityContext) {
    return Response.status(501).build(); // not implemented
  }
  default Response sendNotification(String prefix,String namespace,String table,NotificationRequest notificationRequest,RealmContext realmContext,SecurityContext securityContext) {
    return Response.status(501).build(); // not implemented
  }
  default Response tableExists(String prefix,String namespace,String table,RealmContext realmContext,SecurityContext securityContext) {
    return Response.status(501).build(); // not implemented
  }
  default Response updateProperties(String prefix,String namespace,UpdateNamespacePropertiesRequest updateNamespacePropertiesRequest,RealmContext realmContext,SecurityContext securityContext) {
    return Response.status(501).build(); // not implemented
  }
  default Response updateTable(String prefix,String namespace,String table,CommitTableRequest commitTableRequest,RealmContext realmContext,SecurityContext securityContext) {
    return Response.status(501).build(); // not implemented
  }
  default Response viewExists(String prefix,String namespace,String view,RealmContext realmContext,SecurityContext securityContext) {
    return Response.status(501).build(); // not implemented
  }
}
