package org.apache.polaris.service.catalog.api;

import org.apache.polaris.service.types.AttachPolicyRequest;
import org.apache.polaris.service.types.CreatePolicyRequest;
import org.apache.polaris.service.types.DetachPolicyRequest;
import org.apache.polaris.service.types.GetApplicablePoliciesResponse;
import org.apache.iceberg.rest.responses.ErrorResponse;
import org.apache.polaris.service.types.ListPoliciesResponse;
import org.apache.polaris.service.types.LoadPolicyResponse;
import org.apache.polaris.service.types.UpdatePolicyRequest;

import io.micrometer.core.annotation.Timed;
import io.micrometer.core.aop.MeterTag;

import java.util.Map;
import java.util.List;

import java.io.InputStream;

import jakarta.annotation.Nonnull;
import jakarta.annotation.security.RolesAllowed;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.PATCH;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.core.Response;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.SecurityContext;

import jakarta.inject.Inject;

import org.apache.polaris.core.context.RealmContext;

import org.eclipse.microprofile.faulttolerance.Timeout;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import jakarta.validation.constraints.*;
import jakarta.validation.Valid;

/**
 * The PolicyApi API interface
 *
 * This file is automatically generated by the OpenAPI Code Generator based on configuration in the
 * build.gradle file.
 *
 */
@Path("/api/catalog/polaris/v1/{prefix}")
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaResteasyServerCodegen", date = "2025-12-29T15:11:16.398743462Z[UTC]", comments = "Generator version: 7.12.0")
public class PolarisCatalogPolicyApi  {
  private static final Logger LOGGER = LoggerFactory.getLogger(PolarisCatalogPolicyApi.class);

  private final PolarisCatalogPolicyApiService service;

  @Inject
  public PolarisCatalogPolicyApi(PolarisCatalogPolicyApiService service) {
    this.service = service;
  }

  /**
   * Create a mapping between a policy and a resource entity  Policy can be attached to different levels: 1. **Table-like level:** Policies specific to individual tables or views. 2. **Namespace level:** Policies applies to a namespace. 3. **Catalog level:** Policies that applies to a catalog  The ability to attach a policy to a specific entity type is governed by the PolicyValidator. A policy can only be attached if the resource entity is a valid target for the specified policy type.  In addition to the validation rules enforced by the PolicyValidator, there are additional constraints on policy attachment: 1. For inheritable policies, only one policy of the same type can be attached to a given resource entity. 2. For non-inheritable policies, multiple policies of the same type can be attached to the same resource entity without restriction.  For inheritable policies, the inheritance override rule is: 1. Table-like level policies override namespace and catalog policies. 2. Namespace-level policies override upper level namespace or catalog policies.  Additional parameters can be provided in &#x60;parameters&#x60; when creating a mapping to define specific behavior or constraints.  If the policy is already attached to the target entity, the existing mapping record will be updated with the new set of parameters, replacing the previous ones. 
   *
   * Response type: {@code Void}.
   * @param prefix Required - An optional prefix in the path
   * @param namespace Required - A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (&#x60;0x1F&#x60;) byte.
   * @param policyName Required - 
   * @param attachPolicyRequest Required - 
   *
   * @return 204 - Success, no content
   * @return 400 - Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.
   * @return 401 - Unauthorized. Authentication is required and has failed or has not yet been provided.
   * @return 403 - Forbidden. Authenticated user does not have the necessary permissions.
   * @return 404 - Not Found - NoSuchPolicyException, NoSuchTargetException
   * @return 409 - Conflict - The policy type is inheritable and there is already a policy of the same type attached to the target entity
   * @return 503 - The service is not ready to handle the request. The client should wait and retry.  The service may additionally send a Retry-After header to indicate when to retry.
   * @return 5XX - A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.
   */
  @PUT
  @Path("/namespaces/{namespace}/policies/{policy-name}/mappings")
  @Consumes({ "application/json" })
  @Produces({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.PolicyApi.attachPolicy")
  @Timeout
  public Response attachPolicy( @PathParam("prefix") String prefix, @PathParam("namespace") String namespace, @Pattern(regexp="^[A-Za-z0-9\\-_]+$") @PathParam("policy-name") String policyName, @Nonnull @Valid AttachPolicyRequest attachPolicyRequest,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking PolicyApi with params")
      .addKeyValue("operation", "attachPolicy")
      .addKeyValue("prefix", prefix)
      .addKeyValue("namespace", namespace)
      .addKeyValue("policyName", policyName)
      .addKeyValue("attachPolicyRequest", String.valueOf(attachPolicyRequest))
      .log();

    Response ret =
      service.attachPolicy(prefix,namespace,policyName,attachPolicyRequest,realmContext,securityContext);
    LOGGER.debug("Completed execution of attachPolicy API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * Creates a policy within the specified namespace.  A policy defines a set of rules governing actions on specified resources under predefined conditions. In Apache Polaris, policies are created, stored, and later referenced by external engines to enforce access controls on associated resources.  User provides the following inputs when creating a policy - &#x60;name&#x60; (REQUIRED): The name of the policy. - &#x60;type&#x60; (REQUIRED): The type of the policy.   - **Predefined Policies:** policies have a &#x60;system.*&#x60; prefix in their type, such as &#x60;system.data_compaction&#x60; - &#x60;description&#x60; (OPTIONAL): Provides details about the policy&#39;s purpose and functionality - &#x60;content&#x60; (OPTIONAL): Defines the rules that control actions and access conditions on resources. The format can be JSON, SQL, or any other format.  The content field in the request body is validated using the policy&#39;s corresponding validator. The policy is created only if the content passes validation.  Upon successful creation, the new policy&#39;s version will be 0. 
   *
   * Response type: {@code LoadPolicyResponse}.
   * @param prefix Required - An optional prefix in the path
   * @param namespace Required - A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (&#x60;0x1F&#x60;) byte.
   * @param createPolicyRequest Required - 
   *
   * @return 200 - Policy object result after creating a policy
   * @return 400 - Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.
   * @return 401 - Unauthorized. Authentication is required and has failed or has not yet been provided.
   * @return 403 - Forbidden. Authenticated user does not have the necessary permissions.
   * @return 404 - Not Found - The namespace specified does not exist
   * @return 409 - Conflict - The policy already exists under the given namespace
   * @return 503 - The service is not ready to handle the request. The client should wait and retry.  The service may additionally send a Retry-After header to indicate when to retry.
   * @return 5XX - A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.
   */
  @POST
  @Path("/namespaces/{namespace}/policies")
  @Consumes({ "application/json" })
  @Produces({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.PolicyApi.createPolicy")
  @Timeout
  public Response createPolicy( @PathParam("prefix") String prefix, @PathParam("namespace") String namespace, @Nonnull @Valid CreatePolicyRequest createPolicyRequest,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking PolicyApi with params")
      .addKeyValue("operation", "createPolicy")
      .addKeyValue("prefix", prefix)
      .addKeyValue("namespace", namespace)
      .addKeyValue("createPolicyRequest", String.valueOf(createPolicyRequest))
      .log();

    Response ret =
      service.createPolicy(prefix,namespace,createPolicyRequest,realmContext,securityContext);
    LOGGER.debug("Completed execution of createPolicy API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * Remove a mapping between a policy and a target entity  A target entity can be a catalog, namespace, table or view. 
   *
   * Response type: {@code Void}.
   * @param prefix Required - An optional prefix in the path
   * @param namespace Required - A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (&#x60;0x1F&#x60;) byte.
   * @param policyName Required - 
   * @param detachPolicyRequest Required - 
   *
   * @return 204 - Success, no content
   * @return 400 - Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.
   * @return 401 - Unauthorized. Authentication is required and has failed or has not yet been provided.
   * @return 403 - Forbidden. Authenticated user does not have the necessary permissions.
   * @return 404 - Not Found - NoSuchPolicyException, NoSuchTargetException, NoSuchMappingException
   * @return 503 - The service is not ready to handle the request. The client should wait and retry.  The service may additionally send a Retry-After header to indicate when to retry.
   * @return 5XX - A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.
   */
  @POST
  @Path("/namespaces/{namespace}/policies/{policy-name}/mappings")
  @Consumes({ "application/json" })
  @Produces({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.PolicyApi.detachPolicy")
  @Timeout
  public Response detachPolicy( @PathParam("prefix") String prefix, @PathParam("namespace") String namespace, @Pattern(regexp="^[A-Za-z0-9\\-_]+$") @PathParam("policy-name") String policyName, @Nonnull @Valid DetachPolicyRequest detachPolicyRequest,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking PolicyApi with params")
      .addKeyValue("operation", "detachPolicy")
      .addKeyValue("prefix", prefix)
      .addKeyValue("namespace", namespace)
      .addKeyValue("policyName", policyName)
      .addKeyValue("detachPolicyRequest", String.valueOf(detachPolicyRequest))
      .log();

    Response ret =
      service.detachPolicy(prefix,namespace,policyName,detachPolicyRequest,realmContext,securityContext);
    LOGGER.debug("Completed execution of detachPolicy API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * Remove a policy from the catalog.   A policy can only be dropped if it is not attached to any resource entity. To remove the policy along with all its attachments, set detach-all to true. 
   *
   * Response type: {@code Void}.
   * @param prefix Required - An optional prefix in the path
   * @param namespace Required - A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (&#x60;0x1F&#x60;) byte.
   * @param policyName Required - 
   * @param detachAll  When set to true, the dropPolicy operation will also delete all mappings between the policy and its attached target entities. 
   *
   * @return 204 - Success, no content
   * @return 400 - Bad Request - the policy to be dropped is attached to one or more targets and detach-all is not set to true
   * @return 401 - Unauthorized. Authentication is required and has failed or has not yet been provided.
   * @return 403 - Forbidden. Authenticated user does not have the necessary permissions.
   * @return 404 - Not Found - NoSuchPolicyException, policy to get does not exist
   * @return 503 - The service is not ready to handle the request. The client should wait and retry.  The service may additionally send a Retry-After header to indicate when to retry.
   * @return 5XX - A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.
   */
  @DELETE
  @Path("/namespaces/{namespace}/policies/{policy-name}")
  @Produces({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.PolicyApi.dropPolicy")
  @Timeout
  public Response dropPolicy( @PathParam("prefix") String prefix, @PathParam("namespace") String namespace, @Pattern(regexp="^[A-Za-z0-9\\-_]+$") @PathParam("policy-name") String policyName, @QueryParam("detach-all")  Boolean detachAll,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking PolicyApi with params")
      .addKeyValue("operation", "dropPolicy")
      .addKeyValue("prefix", prefix)
      .addKeyValue("namespace", namespace)
      .addKeyValue("policyName", policyName)
      .addKeyValue("detachAll", detachAll)
      .log();

    Response ret =
      service.dropPolicy(prefix,namespace,policyName,detachAll,realmContext,securityContext);
    LOGGER.debug("Completed execution of dropPolicy API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * Retrieves all applicable policies for a specified entity, including inherited policies from parent entities. An entity can be a table/view, namespace, or catalog. The required parameters depend on the entity type:  - Table/View:   - The &#x60;namespace&#x60; parameter is required to specify the entity&#39;s namespace.   - The &#x60;target-name&#x60; parameter is required to specify the entity name. - Namespace:   - The &#x60;namespace&#x60; parameter is required to specify the identifier.   - The &#x60;target-name&#x60; parameter should not be set. - Catalog:   - Neither &#x60;namespace&#x60; nor &#x60;target-name&#x60; should be set.  An optional policyType parameter filters results to return only policies of the specified type.  This API evaluates the entity&#39;s hierarchy and applies inheritable policies from parent entities. The inheritance follows the following override rule:  1. Table-like level policies override namespace and catalog policies. 2. Namespace-level policies override upper level namespace or catalog policies. 
   *
   * Response type: {@code GetApplicablePoliciesResponse}.
   * @param prefix Required - An optional prefix in the path
   * @param pageToken  
   * @param pageSize  For servers that support pagination, this signals an upper bound of the number of results that a client will receive. For servers that do not support pagination, clients may receive results larger than the indicated &#x60;pageSize&#x60;.
   * @param namespace  A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (&#x60;0x1F&#x60;) byte.
   * @param targetName  Name of the target table/view
   * @param policyType  
   *
   * @return 200 - A list of policies applicable to the table
   * @return 400 - Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.
   * @return 401 - Unauthorized. Authentication is required and has failed or has not yet been provided.
   * @return 403 - Forbidden. Authenticated user does not have the necessary permissions.
   * @return 404 - Not Found - NoSuchTableException, target table does not exist - NoSuchViewException, target view does not exist - NoSuchNamespaceException, target namespace does not exist
   * @return 503 - The service is not ready to handle the request. The client should wait and retry.  The service may additionally send a Retry-After header to indicate when to retry.
   * @return 5XX - A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.
   */
  @GET
  @Path("/applicable-policies")
  @Produces({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.PolicyApi.getApplicablePolicies")
  @Timeout
  public Response getApplicablePolicies( @PathParam("prefix") String prefix, @QueryParam("pageToken")  String pageToken, @QueryParam("pageSize")  @Min(1) Integer pageSize, @QueryParam("namespace")  String namespace, @QueryParam("target-name")  String targetName, @QueryParam("policyType")  String policyType,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking PolicyApi with params")
      .addKeyValue("operation", "getApplicablePolicies")
      .addKeyValue("prefix", prefix)
      .addKeyValue("pageToken", pageToken)
      .addKeyValue("pageSize", pageSize)
      .addKeyValue("namespace", namespace)
      .addKeyValue("targetName", targetName)
      .addKeyValue("policyType", policyType)
      .log();

    Response ret =
      service.getApplicablePolicies(prefix,pageToken,pageSize,namespace,targetName,policyType,realmContext,securityContext);
    LOGGER.debug("Completed execution of getApplicablePolicies API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * Return all policy identifiers under this namespace. Users can optionally filter the result by policy type
   *
   * Response type: {@code ListPoliciesResponse}.
   * @param prefix Required - An optional prefix in the path
   * @param namespace Required - A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (&#x60;0x1F&#x60;) byte.
   * @param pageToken  
   * @param pageSize  For servers that support pagination, this signals an upper bound of the number of results that a client will receive. For servers that do not support pagination, clients may receive results larger than the indicated &#x60;pageSize&#x60;.
   * @param policyType  
   *
   * @return 200 - a list of policy identifiers
   * @return 400 - Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.
   * @return 401 - Unauthorized. Authentication is required and has failed or has not yet been provided.
   * @return 403 - Forbidden. Authenticated user does not have the necessary permissions.
   * @return 404 - Not Found - The namespace specified does not exist
   * @return 503 - The service is not ready to handle the request. The client should wait and retry.  The service may additionally send a Retry-After header to indicate when to retry.
   * @return 5XX - A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.
   */
  @GET
  @Path("/namespaces/{namespace}/policies")
  @Produces({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.PolicyApi.listPolicies")
  @Timeout
  public Response listPolicies( @PathParam("prefix") String prefix, @PathParam("namespace") String namespace, @QueryParam("pageToken")  String pageToken, @QueryParam("pageSize")  @Min(1) Integer pageSize, @QueryParam("policyType")  String policyType,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking PolicyApi with params")
      .addKeyValue("operation", "listPolicies")
      .addKeyValue("prefix", prefix)
      .addKeyValue("namespace", namespace)
      .addKeyValue("pageToken", pageToken)
      .addKeyValue("pageSize", pageSize)
      .addKeyValue("policyType", policyType)
      .log();

    Response ret =
      service.listPolicies(prefix,namespace,pageToken,pageSize,policyType,realmContext,securityContext);
    LOGGER.debug("Completed execution of listPolicies API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * Load a policy from the catalog  The response contains the policy&#39;s metadata and content. For more details, refer to the definition of the &#x60;Policy&#x60; model. 
   *
   * Response type: {@code LoadPolicyResponse}.
   * @param prefix Required - An optional prefix in the path
   * @param namespace Required - A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (&#x60;0x1F&#x60;) byte.
   * @param policyName Required - 
   *
   * @return 200 - Policy object result when getting a policy
   * @return 400 - Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.
   * @return 401 - Unauthorized. Authentication is required and has failed or has not yet been provided.
   * @return 403 - Forbidden. Authenticated user does not have the necessary permissions.
   * @return 404 - Not Found - NoSuchPolicyException, policy to get does not exist
   * @return 503 - The service is not ready to handle the request. The client should wait and retry.  The service may additionally send a Retry-After header to indicate when to retry.
   * @return 5XX - A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.
   */
  @GET
  @Path("/namespaces/{namespace}/policies/{policy-name}")
  @Produces({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.PolicyApi.loadPolicy")
  @Timeout
  public Response loadPolicy( @PathParam("prefix") String prefix, @PathParam("namespace") String namespace, @Pattern(regexp="^[A-Za-z0-9\\-_]+$") @PathParam("policy-name") String policyName,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking PolicyApi with params")
      .addKeyValue("operation", "loadPolicy")
      .addKeyValue("prefix", prefix)
      .addKeyValue("namespace", namespace)
      .addKeyValue("policyName", policyName)
      .log();

    Response ret =
      service.loadPolicy(prefix,namespace,policyName,realmContext,securityContext);
    LOGGER.debug("Completed execution of loadPolicy API with status code {}", ret.getStatus());
    return ret;
  }
  /**
   * Update a policy  A policy&#39;s description and content can be updated. The new content is validated against the policy&#39;s corresponding validator. Upon a successful update, the policy&#39;s version is incremented by 1.  The update will only succeed if the current version matches the one in the catalog. 
   *
   * Response type: {@code LoadPolicyResponse}.
   * @param prefix Required - An optional prefix in the path
   * @param namespace Required - A namespace identifier as a single string. Multipart namespace parts should be separated by the unit separator (&#x60;0x1F&#x60;) byte.
   * @param policyName Required - 
   * @param updatePolicyRequest Required - 
   *
   * @return 200 - Response used when a policy is successfully updated The updated policy JSON is returned in the policy field
   * @return 400 - Indicates a bad request error. It could be caused by an unexpected request body format or other forms of request validation failure, such as invalid json. Usually serves application/json content, although in some cases simple text/plain content might be returned by the server's middleware.
   * @return 401 - Unauthorized. Authentication is required and has failed or has not yet been provided.
   * @return 403 - Forbidden. Authenticated user does not have the necessary permissions.
   * @return 404 - Not Found - NoSuchPolicyException, policy to get does not exist
   * @return 409 - The policy version doesn't match the current-policy-version; retry after fetching latest version
   * @return 503 - The service is not ready to handle the request. The client should wait and retry.  The service may additionally send a Retry-After header to indicate when to retry.
   * @return 5XX - A server-side problem that might not be addressable from the client side. Used for server 5xx errors without more specific documentation in individual routes.
   */
  @PUT
  @Path("/namespaces/{namespace}/policies/{policy-name}")
  @Consumes({ "application/json" })
  @Produces({ "application/json" })
  @RolesAllowed("**")
  @Timed("polaris.PolicyApi.updatePolicy")
  @Timeout
  public Response updatePolicy( @PathParam("prefix") String prefix, @PathParam("namespace") String namespace, @Pattern(regexp="^[A-Za-z0-9\\-_]+$") @PathParam("policy-name") String policyName, @Nonnull @Valid UpdatePolicyRequest updatePolicyRequest,@Context @MeterTag(key="realm_id",expression="realmIdentifier") RealmContext realmContext,@Context SecurityContext securityContext) {
    LOGGER.atDebug().setMessage("Invoking PolicyApi with params")
      .addKeyValue("operation", "updatePolicy")
      .addKeyValue("prefix", prefix)
      .addKeyValue("namespace", namespace)
      .addKeyValue("policyName", policyName)
      .addKeyValue("updatePolicyRequest", String.valueOf(updatePolicyRequest))
      .log();

    Response ret =
      service.updatePolicy(prefix,namespace,policyName,updatePolicyRequest,realmContext,securityContext);
    LOGGER.debug("Completed execution of updatePolicy API with status code {}", ret.getStatus());
    return ret;
  }
}
