package org.apache.polaris.service.types;

import java.util.Objects;
import java.util.ArrayList;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import org.apache.polaris.service.types.GenericTable;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import io.swagger.annotations.*;
import jakarta.validation.Valid;

@ApiModel(description="Result used when a table is successfully loaded.")@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaResteasyServerCodegen", date = "2025-10-06T09:01:55.320737337Z[UTC]", comments = "Generator version: 7.12.0")public class LoadGenericTableResponse   {

  @NotNull
  @Valid
  private final GenericTable table;
    /**
     **/
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(value = "table", required = true)
    public GenericTable getTable() {
        return table;
    }
    
    @JsonCreator
    public LoadGenericTableResponse(@JsonProperty(value = "table", required = true) GenericTable table) {
        this.table = table;
    }



    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(GenericTable table) {
        return new Builder(table);
    }


    public static final class Builder {
      private GenericTable table;
      private Builder() {
      }
      private Builder(GenericTable table) {
        this.table = table;
      }

      public Builder setTable(GenericTable table) {
        this.table = table;
        return this;
      }


      public LoadGenericTableResponse build() {
        LoadGenericTableResponse inst = new LoadGenericTableResponse(table);
        return inst;
      }
    }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    LoadGenericTableResponse loadGenericTableResponse = (LoadGenericTableResponse) o;
    return Objects.equals(this.table, loadGenericTableResponse.table);
  }

  @Override
  public int hashCode() {
    return Objects.hash(table);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class LoadGenericTableResponse {\n");
    
    sb.append("    table: ").append(toIndentedString(table)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
