package org.apache.polaris.service.types;

import java.util.Objects;
import java.util.ArrayList;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.HashMap;
import java.util.Map;
import jakarta.validation.constraints.*;
import jakarta.validation.Valid;
import io.swagger.annotations.*;
import jakarta.validation.Valid;

@ApiModel(description="Generic Table information. - `name` (REQUIRED): name for the generic table - `format` (REQUIRED): format for the generic table, i.e. \"delta\", \"csv\" - `base-location` (OPTIONAL): table base location in URI format. For example: s3://<my-bucket>/path/to/table.   - The table base location is a location that includes all files for the table.   - A table with multiple disjoint locations (i.e. containing files that are outside the configured base location) is not compliant with the current generic table support in Polaris.   - If no location is provided, clients or users are responsible for managing the location.  - `properties` (OPTIONAL): properties for the generic table passed on creation - `doc` (OPTIONAL): comment or description for the generic table ")@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaResteasyServerCodegen", date = "2025-10-06T09:01:55.320737337Z[UTC]", comments = "Generator version: 7.12.0")public class GenericTable   {

  @NotNull
  private final String name;
  @NotNull
  private final String format;
  private final String baseLocation;
  private final String doc;
  private final Map<String, String> properties;
    /**
     **/
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(value = "name", required = true)
    public String getName() {
        return name;
    }
    
    /**
     **/
    @ApiModelProperty(required = true, value = "")
    @JsonProperty(value = "format", required = true)
    public String getFormat() {
        return format;
    }
    
    /**
     **/
    @ApiModelProperty(value = "")
    @JsonProperty(value = "base-location")
    public String getBaseLocation() {
        return baseLocation;
    }
    
    /**
     **/
    @ApiModelProperty(value = "")
    @JsonProperty(value = "doc")
    public String getDoc() {
        return doc;
    }
    
    /**
     **/
    @ApiModelProperty(value = "")
    @JsonProperty(value = "properties")
    public Map<String, String> getProperties() {
        return properties;
    }
    
    @JsonCreator
    public GenericTable(@JsonProperty(value = "name", required = true) String name, @JsonProperty(value = "format", required = true) String format, @JsonProperty(value = "base-location") String baseLocation, @JsonProperty(value = "doc") String doc, @JsonProperty(value = "properties") Map<String, String> properties) {
        this.name = name;
        this.format = format;
        this.baseLocation = baseLocation;
        this.doc = doc;
        this.properties = Objects.requireNonNullElse(properties, new HashMap<>());
    }


    public GenericTable(String name, String format) {
        this.name = name;
        this.format = format;
        this.baseLocation = null;
        this.doc = null;
        this.properties = new HashMap<>();
    }

    public static Builder builder() {
        return new Builder();
    }
    public static Builder builder(String name, String format) {
        return new Builder(name, format);
    }


    public static final class Builder {
      private String name;
      private String format;
      private String baseLocation;
      private String doc;
      private Map<String, String> properties;
      private Builder() {
      }
      private Builder(String name, String format) {
        this.name = name;
        this.format = format;
      }

      public Builder setName(String name) {
        this.name = name;
        return this;
      }
      public Builder setFormat(String format) {
        this.format = format;
        return this;
      }
      public Builder setBaseLocation(String baseLocation) {
        this.baseLocation = baseLocation;
        return this;
      }
      public Builder setDoc(String doc) {
        this.doc = doc;
        return this;
      }
      public Builder setProperties(Map<String, String> properties) {
        this.properties = properties;
        return this;
      }


      public GenericTable build() {
        GenericTable inst = new GenericTable(name, format, baseLocation, doc, properties);
        return inst;
      }
    }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GenericTable genericTable = (GenericTable) o;
    return Objects.equals(this.name, genericTable.name) &&
        Objects.equals(this.format, genericTable.format) &&
        Objects.equals(this.baseLocation, genericTable.baseLocation) &&
        Objects.equals(this.doc, genericTable.doc) &&
        Objects.equals(this.properties, genericTable.properties);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, format, baseLocation, doc, properties);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GenericTable {\n");
    
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    format: ").append(toIndentedString(format)).append("\n");
    sb.append("    baseLocation: ").append(toIndentedString(baseLocation)).append("\n");
    sb.append("    doc: ").append(toIndentedString(doc)).append("\n");
    sb.append("    properties: ").append(toIndentedString(properties)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}
