/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.extension.bundle;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.apache.nifi.registry.extension.bundle.BuildInfo;
import org.apache.nifi.registry.link.LinkableEntity;

@ApiModel
@XmlRootElement
public class BundleVersionMetadata
extends LinkableEntity
implements Comparable<BundleVersionMetadata> {
    @NotBlank
    private String id;
    @NotBlank
    private String bundleId;
    @NotBlank
    private String bucketId;
    private String groupId;
    private String artifactId;
    @NotBlank
    private String version;
    @Min(value=1L)
    private @Min(value=1L) long timestamp;
    @NotBlank
    private String author;
    private String description;
    @NotBlank
    private String sha256;
    @NotNull
    private Boolean sha256Supplied;
    @NotNull
    @Min(value=0L)
    private @NotNull @Min(value=0L) long contentSize;
    @NotBlank
    private String systemApiVersion;
    @Valid
    @NotNull
    private BuildInfo buildInfo;

    @ApiModelProperty(value="The id of this version of the extension bundle")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @ApiModelProperty(value="The id of the extension bundle this version is for")
    public String getBundleId() {
        return this.bundleId;
    }

    public void setBundleId(String bundleId) {
        this.bundleId = bundleId;
    }

    @ApiModelProperty(value="The id of the bucket the extension bundle belongs to", required=true)
    public String getBucketId() {
        return this.bucketId;
    }

    public void setBucketId(String bucketId) {
        this.bucketId = bucketId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    @ApiModelProperty(value="The version of the extension bundle")
    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @ApiModelProperty(value="The timestamp of the create date of this version")
    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @ApiModelProperty(value="The identity that created this version")
    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    @ApiModelProperty(value="The description for this version")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @ApiModelProperty(value="The hex representation of the SHA-256 digest of the binary content for this version")
    public String getSha256() {
        return this.sha256;
    }

    public void setSha256(String sha256) {
        this.sha256 = sha256;
    }

    @ApiModelProperty(value="Whether or not the client supplied a SHA-256 when uploading the bundle")
    public Boolean getSha256Supplied() {
        return this.sha256Supplied;
    }

    public void setSha256Supplied(Boolean sha256Supplied) {
        this.sha256Supplied = sha256Supplied;
    }

    @ApiModelProperty(value="The size of the binary content for this version in bytes")
    public long getContentSize() {
        return this.contentSize;
    }

    public void setContentSize(long contentSize) {
        this.contentSize = contentSize;
    }

    @ApiModelProperty(value="The version of the system API that this bundle version was built against")
    public String getSystemApiVersion() {
        return this.systemApiVersion;
    }

    public void setSystemApiVersion(String systemApiVersion) {
        this.systemApiVersion = systemApiVersion;
    }

    @ApiModelProperty(value="The build information about this version")
    public BuildInfo getBuildInfo() {
        return this.buildInfo;
    }

    public void setBuildInfo(BuildInfo buildInfo) {
        this.buildInfo = buildInfo;
    }

    @Override
    public int compareTo(BundleVersionMetadata o) {
        return o == null ? -1 : this.version.compareTo(o.version);
    }

    public int hashCode() {
        return Objects.hashCode(this.id);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BundleVersionMetadata other = (BundleVersionMetadata)obj;
        return Objects.equals(this.id, other.id);
    }
}

