/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.client.impl;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.registry.client.FlowSnapshotClient;
import org.apache.nifi.registry.client.NiFiRegistryException;
import org.apache.nifi.registry.client.RequestConfig;
import org.apache.nifi.registry.client.impl.AbstractJerseyClient;
import org.apache.nifi.registry.flow.VersionedFlowSnapshot;
import org.apache.nifi.registry.flow.VersionedFlowSnapshotMetadata;

public class JerseyFlowSnapshotClient
extends AbstractJerseyClient
implements FlowSnapshotClient {
    final WebTarget bucketFlowSnapshotTarget;
    final WebTarget flowsFlowSnapshotTarget;

    public JerseyFlowSnapshotClient(WebTarget baseTarget) {
        this(baseTarget, null);
    }

    public JerseyFlowSnapshotClient(WebTarget baseTarget, RequestConfig requestConfig) {
        super(requestConfig);
        this.bucketFlowSnapshotTarget = baseTarget.path("/buckets/{bucketId}/flows/{flowId}/versions");
        this.flowsFlowSnapshotTarget = baseTarget.path("/flows/{flowId}/versions");
    }

    @Override
    public VersionedFlowSnapshot create(VersionedFlowSnapshot snapshot) throws NiFiRegistryException, IOException {
        if (snapshot.getSnapshotMetadata() == null) {
            throw new IllegalArgumentException("Snapshot Metadata cannot be null");
        }
        String bucketId = snapshot.getSnapshotMetadata().getBucketIdentifier();
        if (StringUtils.isBlank((CharSequence)bucketId)) {
            throw new IllegalArgumentException("Bucket Identifier cannot be blank");
        }
        String flowId = snapshot.getSnapshotMetadata().getFlowIdentifier();
        if (StringUtils.isBlank((CharSequence)flowId)) {
            throw new IllegalArgumentException("Flow Identifier cannot be blank");
        }
        return this.executeAction("Error creating snapshot", () -> {
            WebTarget target = this.bucketFlowSnapshotTarget.resolveTemplate("bucketId", (Object)bucketId).resolveTemplate("flowId", (Object)flowId);
            return (VersionedFlowSnapshot)this.getRequestBuilder(target).post(Entity.entity((Object)snapshot, (String)"application/json"), VersionedFlowSnapshot.class);
        });
    }

    @Override
    public VersionedFlowSnapshot get(String bucketId, String flowId, int version) throws NiFiRegistryException, IOException {
        if (StringUtils.isBlank((CharSequence)bucketId)) {
            throw new IllegalArgumentException("Bucket Identifier cannot be blank");
        }
        if (StringUtils.isBlank((CharSequence)flowId)) {
            throw new IllegalArgumentException("Flow Identifier cannot be blank");
        }
        if (version < 1) {
            throw new IllegalArgumentException("Version must be greater than 1");
        }
        return this.executeAction("Error retrieving flow snapshot", () -> {
            WebTarget target = this.bucketFlowSnapshotTarget.path("/{version}").resolveTemplate("bucketId", (Object)bucketId).resolveTemplate("flowId", (Object)flowId).resolveTemplate("version", (Object)version);
            return (VersionedFlowSnapshot)this.getRequestBuilder(target).get(VersionedFlowSnapshot.class);
        });
    }

    @Override
    public VersionedFlowSnapshot get(String flowId, int version) throws NiFiRegistryException, IOException {
        if (StringUtils.isBlank((CharSequence)flowId)) {
            throw new IllegalArgumentException("Flow Identifier cannot be blank");
        }
        if (version < 1) {
            throw new IllegalArgumentException("Version must be greater than 1");
        }
        return this.executeAction("Error retrieving flow snapshot", () -> {
            WebTarget target = this.flowsFlowSnapshotTarget.path("/{version}").resolveTemplate("flowId", (Object)flowId).resolveTemplate("version", (Object)version);
            return (VersionedFlowSnapshot)this.getRequestBuilder(target).get(VersionedFlowSnapshot.class);
        });
    }

    @Override
    public VersionedFlowSnapshot getLatest(String bucketId, String flowId) throws NiFiRegistryException, IOException {
        if (StringUtils.isBlank((CharSequence)bucketId)) {
            throw new IllegalArgumentException("Bucket Identifier cannot be blank");
        }
        if (StringUtils.isBlank((CharSequence)flowId)) {
            throw new IllegalArgumentException("Flow Identifier cannot be blank");
        }
        return this.executeAction("Error retrieving latest snapshot", () -> {
            WebTarget target = this.bucketFlowSnapshotTarget.path("/latest").resolveTemplate("bucketId", (Object)bucketId).resolveTemplate("flowId", (Object)flowId);
            return (VersionedFlowSnapshot)this.getRequestBuilder(target).get(VersionedFlowSnapshot.class);
        });
    }

    @Override
    public VersionedFlowSnapshot getLatest(String flowId) throws NiFiRegistryException, IOException {
        if (StringUtils.isBlank((CharSequence)flowId)) {
            throw new IllegalArgumentException("Flow Identifier cannot be blank");
        }
        return this.executeAction("Error retrieving latest snapshot", () -> {
            WebTarget target = this.flowsFlowSnapshotTarget.path("/latest").resolveTemplate("flowId", (Object)flowId);
            return (VersionedFlowSnapshot)this.getRequestBuilder(target).get(VersionedFlowSnapshot.class);
        });
    }

    @Override
    public VersionedFlowSnapshotMetadata getLatestMetadata(String bucketId, String flowId) throws NiFiRegistryException, IOException {
        if (StringUtils.isBlank((CharSequence)bucketId)) {
            throw new IllegalArgumentException("Bucket Identifier cannot be blank");
        }
        if (StringUtils.isBlank((CharSequence)flowId)) {
            throw new IllegalArgumentException("Flow Identifier cannot be blank");
        }
        return this.executeAction("Error retrieving latest snapshot metadata", () -> {
            WebTarget target = this.bucketFlowSnapshotTarget.path("/latest/metadata").resolveTemplate("bucketId", (Object)bucketId).resolveTemplate("flowId", (Object)flowId);
            return (VersionedFlowSnapshotMetadata)this.getRequestBuilder(target).get(VersionedFlowSnapshotMetadata.class);
        });
    }

    @Override
    public VersionedFlowSnapshotMetadata getLatestMetadata(String flowId) throws NiFiRegistryException, IOException {
        if (StringUtils.isBlank((CharSequence)flowId)) {
            throw new IllegalArgumentException("Flow Identifier cannot be blank");
        }
        return this.executeAction("Error retrieving latest snapshot metadata", () -> {
            WebTarget target = this.flowsFlowSnapshotTarget.path("/latest/metadata").resolveTemplate("flowId", (Object)flowId);
            return (VersionedFlowSnapshotMetadata)this.getRequestBuilder(target).get(VersionedFlowSnapshotMetadata.class);
        });
    }

    @Override
    public List<VersionedFlowSnapshotMetadata> getSnapshotMetadata(String bucketId, String flowId) throws NiFiRegistryException, IOException {
        if (StringUtils.isBlank((CharSequence)bucketId)) {
            throw new IllegalArgumentException("Bucket Identifier cannot be blank");
        }
        if (StringUtils.isBlank((CharSequence)flowId)) {
            throw new IllegalArgumentException("Flow Identifier cannot be blank");
        }
        return this.executeAction("Error retrieving snapshot metadata", () -> {
            WebTarget target = this.bucketFlowSnapshotTarget.resolveTemplate("bucketId", (Object)bucketId).resolveTemplate("flowId", (Object)flowId);
            VersionedFlowSnapshotMetadata[] snapshots = (VersionedFlowSnapshotMetadata[])this.getRequestBuilder(target).get(VersionedFlowSnapshotMetadata[].class);
            return snapshots == null ? Collections.emptyList() : Arrays.asList(snapshots);
        });
    }

    @Override
    public List<VersionedFlowSnapshotMetadata> getSnapshotMetadata(String flowId) throws NiFiRegistryException, IOException {
        if (StringUtils.isBlank((CharSequence)flowId)) {
            throw new IllegalArgumentException("Flow Identifier cannot be blank");
        }
        return this.executeAction("Error retrieving snapshot metadata", () -> {
            WebTarget target = this.flowsFlowSnapshotTarget.resolveTemplate("flowId", (Object)flowId);
            VersionedFlowSnapshotMetadata[] snapshots = (VersionedFlowSnapshotMetadata[])this.getRequestBuilder(target).get(VersionedFlowSnapshotMetadata[].class);
            return snapshots == null ? Collections.emptyList() : Arrays.asList(snapshots);
        });
    }
}

