/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.zendesk;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.annotation.behavior.DynamicProperty;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.common.zendesk.ZendeskProperties;
import org.apache.nifi.common.zendesk.util.ZendeskRecordPathUtils;
import org.apache.nifi.common.zendesk.util.ZendeskUtils;
import org.apache.nifi.common.zendesk.validation.JsonPointerPropertyNameValidator;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.Validator;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processors.zendesk.AbstractZendesk;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.RecordReaderFactory;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.web.client.api.HttpResponseEntity;
import org.apache.nifi.web.client.api.HttpResponseStatus;
import org.apache.nifi.web.client.api.HttpUriBuilder;

@Tags(value={"zendesk, ticket"})
@CapabilityDescription(value="Create Zendesk tickets using the Zendesk API.")
@DynamicProperty(name="The path in the request object to add. The value needs be a valid JsonPointer.", value="The path in the incoming record to get the value from.", expressionLanguageScope=ExpressionLanguageScope.FLOWFILE_ATTRIBUTES, description="Additional property to be added to the Zendesk request object.")
@WritesAttributes(value={@WritesAttribute(attribute="record.count", description="The number of records processed."), @WritesAttribute(attribute="error.code", description="The error code of from the response."), @WritesAttribute(attribute="error.message", description="The error message of from the response.")})
public class PutZendeskTicket
extends AbstractZendesk {
    static final String ZENDESK_RECORD_READER_NAME = "zendesk-record-reader";
    static final String ERROR_CODE_ATTRIBUTE_NAME = "error.code";
    static final String ERROR_MESSAGE_ATTRIBUTE_NAME = "error.message";
    private static final ObjectMapper mapper = new ObjectMapper();
    static final PropertyDescriptor RECORD_READER = new PropertyDescriptor.Builder().name("zendesk-record-reader").displayName("Record Reader").description("Specifies the Controller Service to use for parsing incoming data and determining the data's schema.").identifiesControllerService(RecordReaderFactory.class).build();
    static final PropertyDescriptor TICKET_COMMENT_BODY = new PropertyDescriptor.Builder().fromPropertyDescriptor(ZendeskProperties.ZENDESK_TICKET_COMMENT_BODY).dependsOn(RECORD_READER, new AllowableValue[0]).build();
    static final PropertyDescriptor TICKET_SUBJECT = new PropertyDescriptor.Builder().fromPropertyDescriptor(ZendeskProperties.ZENDESK_TICKET_SUBJECT).dependsOn(RECORD_READER, new AllowableValue[0]).build();
    static final PropertyDescriptor TICKET_PRIORITY = new PropertyDescriptor.Builder().fromPropertyDescriptor(ZendeskProperties.ZENDESK_TICKET_PRIORITY).dependsOn(RECORD_READER, new AllowableValue[0]).build();
    static final PropertyDescriptor TICKET_TYPE = new PropertyDescriptor.Builder().fromPropertyDescriptor(ZendeskProperties.ZENDESK_TICKET_TYPE).dependsOn(RECORD_READER, new AllowableValue[0]).build();
    private static final List<PropertyDescriptor> PROPERTIES = Collections.unmodifiableList(Arrays.asList(ZendeskProperties.WEB_CLIENT_SERVICE_PROVIDER, ZendeskProperties.ZENDESK_SUBDOMAIN, ZendeskProperties.ZENDESK_USER, ZendeskProperties.ZENDESK_AUTHENTICATION_TYPE, ZendeskProperties.ZENDESK_AUTHENTICATION_CREDENTIAL, RECORD_READER, TICKET_COMMENT_BODY, TICKET_SUBJECT, TICKET_PRIORITY, TICKET_TYPE));
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("A FlowFile is routed to this relationship if the operation failed and retrying the operation will also fail, such as an invalid data or schema.").build();
    public static final Set<Relationship> RELATIONSHIPS = Collections.unmodifiableSet(new HashSet<Relationship>(Arrays.asList(REL_SUCCESS, REL_FAILURE)));

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).required(false).addValidator((Validator)new JsonPointerPropertyNameValidator()).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).dynamic(true).build();
    }

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    public List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTIES;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) {
        HttpResponseEntity response;
        URI uri;
        long startNanos;
        FlowFile flowFile;
        block31: {
            flowFile = session.get();
            if (flowFile == null) {
                return;
            }
            startNanos = System.nanoTime();
            RecordReaderFactory readerFactory = (RecordReaderFactory)context.getProperty(RECORD_READER).asControllerService(RecordReaderFactory.class);
            if (readerFactory == null) {
                try (InputStream inputStream = session.read(flowFile);){
                    if (inputStream.available() == 0) {
                        inputStream.close();
                        this.getLogger().error("The incoming FlowFile's content is empty");
                        session.transfer(session.penalize(flowFile), REL_FAILURE);
                        return;
                    }
                    HttpUriBuilder uriBuilder = this.uriBuilder("/api/v2/tickets");
                    uri = uriBuilder.build();
                    response = this.zendeskClient.performPostRequest(uri, inputStream);
                    break block31;
                }
                catch (IOException e) {
                    this.getLogger().error("Could not read the incoming FlowFile", (Throwable)e);
                    session.transfer(session.penalize(flowFile), REL_FAILURE);
                    return;
                }
            }
            String commentBody = context.getProperty(TICKET_COMMENT_BODY).evaluateAttributeExpressions().getValue();
            String subject = context.getProperty(TICKET_SUBJECT).evaluateAttributeExpressions().getValue();
            String priority = context.getProperty(TICKET_PRIORITY).evaluateAttributeExpressions().getValue();
            String type = context.getProperty(TICKET_TYPE).evaluateAttributeExpressions().getValue();
            Map dynamicProperties = ZendeskUtils.getDynamicProperties((PropertyContext)context, (Map)context.getProperties(), (Map)flowFile.getAttributes());
            ArrayList<ObjectNode> zendeskTickets = new ArrayList<ObjectNode>();
            try (InputStream in = session.read(flowFile);
                 RecordReader reader = readerFactory.createRecordReader(flowFile, in, this.getLogger());){
                Record record;
                while ((record = reader.nextRecord()) != null) {
                    ObjectNode baseTicketNode = mapper.createObjectNode();
                    ZendeskRecordPathUtils.addField((String)"/comment/body", (String)commentBody, (ObjectNode)baseTicketNode, (Record)record);
                    ZendeskRecordPathUtils.addField((String)"/subject", (String)subject, (ObjectNode)baseTicketNode, (Record)record);
                    ZendeskRecordPathUtils.addField((String)"/priority", (String)priority, (ObjectNode)baseTicketNode, (Record)record);
                    ZendeskRecordPathUtils.addField((String)"/type", (String)type, (ObjectNode)baseTicketNode, (Record)record);
                    for (Map.Entry dynamicProperty : dynamicProperties.entrySet()) {
                        ZendeskRecordPathUtils.addDynamicField((String)((String)dynamicProperty.getKey()), (String)((String)dynamicProperty.getValue()), (ObjectNode)baseTicketNode, (Record)record);
                    }
                    zendeskTickets.add(baseTicketNode);
                }
            }
            catch (IOException | SchemaNotFoundException | MalformedRecordException e) {
                this.getLogger().error("Error occurred while creating Zendesk tickets", e);
                session.transfer(session.penalize(flowFile), REL_FAILURE);
                return;
            }
            if (zendeskTickets.isEmpty()) {
                this.getLogger().info("No records found in the incoming FlowFile");
                flowFile = session.putAttribute(flowFile, "record.count", "0");
                session.transfer(flowFile, REL_SUCCESS);
                return;
            }
            try {
                InputStream inputStream = ZendeskUtils.createRequestObject(zendeskTickets);
                uri = this.createUri(zendeskTickets.size());
                response = this.zendeskClient.performPostRequest(uri, inputStream);
                flowFile = session.putAttribute(flowFile, "record.count", String.valueOf(zendeskTickets.size()));
            }
            catch (IOException e) {
                this.getLogger().error("Failed to post request to Zendesk", (Throwable)e);
                session.transfer(session.penalize(flowFile), REL_FAILURE);
                return;
            }
        }
        this.handleResponse(session, flowFile, response, uri, startNanos);
    }

    private void handleResponse(ProcessSession session, FlowFile flowFile, HttpResponseEntity response, URI uri, long startNanos) {
        if (response.statusCode() == HttpResponseStatus.CREATED.getCode() || response.statusCode() == HttpResponseStatus.OK.getCode()) {
            flowFile = session.putAttribute(flowFile, CoreAttributes.MIME_TYPE.key(), "application/json");
            session.transfer(flowFile, REL_SUCCESS);
            long transferMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
            session.getProvenanceReporter().send(flowFile, uri.toString(), transferMillis);
        } else {
            String errorMessage = ZendeskUtils.getResponseBody((HttpResponseEntity)response);
            this.getLogger().error("Zendesk ticket creation returned with error, HTTP status={}, response={}", new Object[]{response.statusCode(), errorMessage});
            flowFile = session.putAttribute(flowFile, ERROR_CODE_ATTRIBUTE_NAME, String.valueOf(response.statusCode()));
            flowFile = session.putAttribute(flowFile, ERROR_MESSAGE_ATTRIBUTE_NAME, errorMessage);
            session.transfer(session.penalize(flowFile), REL_FAILURE);
        }
    }

    private URI createUri(int numberOfTickets) {
        String resource = numberOfTickets > 1 ? "/api/v2/tickets/create_many" : "/api/v2/tickets";
        return this.uriBuilder(resource).build();
    }
}

