/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.common.zendesk.util;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.record.path.property.RecordPathPropertyUtil;
import org.apache.nifi.serialization.record.Record;

public final class ZendeskRecordPathUtils {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private ZendeskRecordPathUtils() {
    }

    public static void addField(String path, String value, ObjectNode baseTicketNode, Record record) {
        String resolvedValue = RecordPathPropertyUtil.resolvePropertyValue((String)value, (Record)record);
        if (resolvedValue != null) {
            ZendeskRecordPathUtils.addNewNodeAtPath(baseTicketNode, JsonPointer.compile((String)path), (JsonNode)new TextNode(resolvedValue));
        }
    }

    public static void addDynamicField(String path, String value, ObjectNode baseTicketNode, Record record) {
        if (path.startsWith("/ticket")) {
            path = path.substring(7);
        } else if (path.startsWith("/tickets")) {
            path = path.substring(8);
        }
        ZendeskRecordPathUtils.addField(path, value, baseTicketNode, record);
    }

    public static void addNewNodeAtPath(ObjectNode baseNode, JsonPointer path, JsonNode value) {
        JsonPointer parentPointer = path.head();
        String fieldName = path.last().toString().substring(1);
        JsonNode parentNode = ZendeskRecordPathUtils.getOrCreateParentNode(baseNode, parentPointer, fieldName);
        ZendeskRecordPathUtils.setNodeValue(value, fieldName, parentNode);
    }

    private static void setNodeValue(JsonNode value, String fieldName, JsonNode parentNode) {
        if (parentNode.isArray()) {
            ArrayNode arrayNode = (ArrayNode)parentNode;
            int index = Integer.parseInt(fieldName);
            for (int i = arrayNode.size(); i <= index; ++i) {
                arrayNode.addNull();
            }
            arrayNode.set(index, value);
        } else if (parentNode.isObject()) {
            ((ObjectNode)parentNode).set(fieldName, value);
        } else {
            throw new IllegalArgumentException("Unsupported node type" + parentNode.getNodeType().name());
        }
    }

    private static JsonNode getOrCreateParentNode(ObjectNode rootNode, JsonPointer parentPointer, String fieldName) {
        JsonNode parentNode = rootNode.at(parentPointer);
        if (parentNode.isMissingNode() || parentNode.isNull()) {
            parentNode = StringUtils.isNumeric((CharSequence)fieldName) ? OBJECT_MAPPER.createArrayNode() : OBJECT_MAPPER.createObjectNode();
            ZendeskRecordPathUtils.addNewNodeAtPath(rootNode, parentPointer, parentNode);
        }
        return parentNode;
    }
}

