/*
 * Decompiled with CFR 0.152.
 */
package org.wali;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wali.SerDe;
import org.wali.SerDeFactory;
import org.wali.SingletonSerDeFactory;
import org.wali.SyncListener;
import org.wali.UpdateType;
import org.wali.WriteAheadRepository;

@Deprecated
public final class MinimalLockingWriteAheadLog<T>
implements WriteAheadRepository<T> {
    private final Path basePath;
    private final Path partialPath;
    private final Path snapshotPath;
    private final SerDeFactory<T> serdeFactory;
    private final SyncListener syncListener;
    private final FileChannel lockChannel;
    private final AtomicLong transactionIdGenerator = new AtomicLong(0L);
    private final Partition<T>[] partitions;
    private final AtomicLong partitionIndex = new AtomicLong(0L);
    private final ConcurrentMap<Object, T> recordMap = new ConcurrentHashMap<Object, T>();
    private final Map<Object, T> unmodifiableRecordMap = Collections.unmodifiableMap(this.recordMap);
    private final Set<String> externalLocations = new CopyOnWriteArraySet<String>();
    private final Set<String> recoveredExternalLocations = new CopyOnWriteArraySet<String>();
    private final AtomicInteger numberBlackListedPartitions = new AtomicInteger(0);
    private static final Logger logger = LoggerFactory.getLogger(MinimalLockingWriteAheadLog.class);
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwLock.readLock();
    private final Lock writeLock = this.rwLock.writeLock();
    private volatile boolean updated = false;
    private volatile boolean recovered = false;

    public MinimalLockingWriteAheadLog(Path path, int partitionCount, SerDe<T> serde, SyncListener syncListener) throws IOException {
        this(new TreeSet<Path>(Collections.singleton(path)), partitionCount, new SingletonSerDeFactory<T>(serde), syncListener);
    }

    public MinimalLockingWriteAheadLog(Path path, int partitionCount, SerDeFactory<T> serdeFactory, SyncListener syncListener) throws IOException {
        this(new TreeSet<Path>(Collections.singleton(path)), partitionCount, serdeFactory, syncListener);
    }

    public MinimalLockingWriteAheadLog(SortedSet<Path> paths, int partitionCount, SerDe<T> serde, SyncListener syncListener) throws IOException {
        this(paths, partitionCount, new SingletonSerDeFactory<T>(serde), syncListener);
    }

    public MinimalLockingWriteAheadLog(SortedSet<Path> paths, int partitionCount, SerDeFactory<T> serdeFactory, SyncListener syncListener) throws IOException {
        this.syncListener = syncListener;
        Objects.requireNonNull(paths);
        Objects.requireNonNull(serdeFactory);
        if (paths.isEmpty()) {
            throw new IllegalArgumentException("Paths must be non-empty");
        }
        int resolvedPartitionCount = partitionCount;
        int existingPartitions = 0;
        for (Path path : paths) {
            File file;
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            if (!(file = path.toFile()).isDirectory()) {
                throw new IOException("Path given [" + path + "] is not a directory");
            }
            if (!file.canWrite()) {
                throw new IOException("Path given [" + path + "] is not writable");
            }
            if (!file.canRead()) {
                throw new IOException("Path given [" + path + "] is not readable");
            }
            if (!file.canExecute()) {
                throw new IOException("Path given [" + path + "] is not executable");
            }
            File[] children = file.listFiles();
            if (children == null) continue;
            for (File child : children) {
                if (!child.isDirectory() || !child.getName().startsWith("partition-")) continue;
                ++existingPartitions;
            }
            if (existingPartitions == 0 || existingPartitions == partitionCount) continue;
            logger.warn("Constructing MinimalLockingWriteAheadLog with partitionCount={}, but the repository currently has {} partitions; ignoring argument and proceeding with {} partitions", new Object[]{partitionCount, existingPartitions, existingPartitions});
            resolvedPartitionCount = existingPartitions;
        }
        this.basePath = (Path)paths.iterator().next();
        this.partialPath = this.basePath.resolve("snapshot.partial");
        this.snapshotPath = this.basePath.resolve("snapshot");
        this.serdeFactory = serdeFactory;
        Path lockPath = this.basePath.resolve("wali.lock");
        this.lockChannel = new FileOutputStream(lockPath.toFile()).getChannel();
        this.lockChannel.lock();
        this.partitions = new Partition[resolvedPartitionCount];
        Iterator pathIterator = paths.iterator();
        for (int i = 0; i < resolvedPartitionCount; ++i) {
            if (!pathIterator.hasNext()) {
                pathIterator = paths.iterator();
            }
            Path partitionBasePath = (Path)pathIterator.next();
            this.partitions[i] = new Partition<T>(partitionBasePath.resolve("partition-" + i), serdeFactory, i, this.getVersion());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update(Collection<T> records, boolean forceSync) throws IOException {
        if (!this.recovered) {
            throw new IllegalStateException("Cannot update repository until record recovery has been performed");
        }
        if (records.isEmpty()) {
            return -1;
        }
        this.updated = true;
        this.readLock.lock();
        try {
            while (true) {
                int numBlackListed;
                if ((numBlackListed = this.numberBlackListedPartitions.get()) >= this.partitions.length) {
                    throw new IOException("All Partitions have been blacklisted due to failures when attempting to update. If the Write-Ahead Log is able to perform a checkpoint, this issue may resolve itself. Otherwise, manual intervention will be required.");
                }
                long partitionIdx = this.partitionIndex.getAndIncrement();
                int resolvedIdx = (int)(partitionIdx % (long)this.partitions.length);
                Partition<T> partition = this.partitions[resolvedIdx];
                if (!partition.tryClaim()) continue;
                try {
                    long transactionId = this.transactionIdGenerator.getAndIncrement();
                    if (logger.isTraceEnabled()) {
                        for (T record : records) {
                            logger.trace("Partition {} performing Transaction {}: {}", new Object[]{partition, transactionId, record});
                        }
                    }
                    try {
                        partition.update(records, transactionId, this.unmodifiableRecordMap, forceSync);
                    }
                    catch (Throwable t) {
                        partition.blackList();
                        this.numberBlackListedPartitions.incrementAndGet();
                        throw t;
                    }
                    if (forceSync && this.syncListener != null) {
                        this.syncListener.onSync(resolvedIdx);
                    }
                }
                finally {
                    partition.releaseClaim();
                }
                for (T record : records) {
                    String newLocation;
                    UpdateType updateType = this.serdeFactory.getUpdateType(record);
                    Object recordIdentifier = this.serdeFactory.getRecordIdentifier(record);
                    if (updateType == UpdateType.DELETE) {
                        this.recordMap.remove(recordIdentifier);
                        continue;
                    }
                    if (updateType == UpdateType.SWAP_OUT) {
                        newLocation = this.serdeFactory.getLocation(record);
                        if (newLocation == null) {
                            logger.error("Received Record (ID=" + recordIdentifier + ") with UpdateType of SWAP_OUT but no indicator of where the Record is to be Swapped Out to; these records may be lost when the repository is restored!");
                            continue;
                        }
                        this.recordMap.remove(recordIdentifier);
                        this.externalLocations.add(newLocation);
                        continue;
                    }
                    if (updateType == UpdateType.SWAP_IN) {
                        newLocation = this.serdeFactory.getLocation(record);
                        if (newLocation == null) {
                            logger.error("Received Record (ID=" + recordIdentifier + ") with UpdateType of SWAP_IN but no indicator of where the Record is to be Swapped In from; these records may be duplicated when the repository is restored!");
                        } else {
                            this.externalLocations.remove(newLocation);
                        }
                        this.recordMap.put(recordIdentifier, record);
                        continue;
                    }
                    this.recordMap.put(recordIdentifier, record);
                }
                int n = resolvedIdx;
                return n;
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<T> recoverRecords() throws IOException {
        if (this.updated) {
            throw new IllegalStateException("Cannot recover records after updating the repository; must call recoverRecords first");
        }
        long recoverStart = System.nanoTime();
        this.writeLock.lock();
        try {
            Long maxTransactionId = this.recoverFromSnapshot(this.recordMap);
            this.recoverFromEdits(this.recordMap, maxTransactionId);
            for (Partition<T> partition : this.partitions) {
                long transId = partition.getMaxRecoveredTransactionId();
                if (maxTransactionId != null && transId <= maxTransactionId) continue;
                maxTransactionId = transId;
            }
            this.transactionIdGenerator.set(maxTransactionId + 1L);
            this.externalLocations.addAll(this.recoveredExternalLocations);
            logger.info("{} finished recovering records. Performing Checkpoint to ensure proper state of Partitions before updates", (Object)this);
        }
        finally {
            this.writeLock.unlock();
        }
        long recoverNanos = System.nanoTime() - recoverStart;
        long recoveryMillis = TimeUnit.MILLISECONDS.convert(recoverNanos, TimeUnit.NANOSECONDS);
        logger.info("Successfully recovered {} records in {} milliseconds", (Object)this.recordMap.size(), (Object)recoveryMillis);
        this.checkpoint();
        this.recovered = true;
        return this.recordMap.values();
    }

    @Override
    public Set<String> getRecoveredSwapLocations() throws IOException {
        return this.recoveredExternalLocations;
    }

    private Long recoverFromSnapshot(Map<Object, T> recordMap) throws IOException {
        boolean partialExists = Files.exists(this.partialPath, new LinkOption[0]);
        boolean snapshotExists = Files.exists(this.snapshotPath, new LinkOption[0]);
        if (!partialExists && !snapshotExists) {
            return null;
        }
        if (partialExists && snapshotExists) {
            Files.delete(this.partialPath);
        } else if (partialExists) {
            Files.move(this.partialPath, this.snapshotPath, new CopyOption[0]);
        }
        if (Files.size(this.snapshotPath) == 0L) {
            logger.warn("{} Found 0-byte Snapshot file; skipping Snapshot file in recovery", (Object)this);
            return null;
        }
        try (DataInputStream dataIn = new DataInputStream(new BufferedInputStream(Files.newInputStream(this.snapshotPath, StandardOpenOption.READ)));){
            String waliImplementationClass = dataIn.readUTF();
            int waliImplementationVersion = dataIn.readInt();
            if (!waliImplementationClass.equals(MinimalLockingWriteAheadLog.class.getName())) {
                throw new IOException("Write-Ahead Log located at " + this.snapshotPath + " was written using the " + waliImplementationClass + " class; cannot restore using " + this.getClass().getName());
            }
            if (waliImplementationVersion > this.getVersion()) {
                throw new IOException("Write-Ahead Log located at " + this.snapshotPath + " was written using version " + waliImplementationVersion + " of the " + waliImplementationClass + " class; cannot restore using Version " + this.getVersion());
            }
            String serdeEncoding = dataIn.readUTF();
            int serdeVersion = dataIn.readInt();
            long maxTransactionId = dataIn.readLong();
            int numRecords = dataIn.readInt();
            SerDe<T> serde = this.serdeFactory.createSerDe(serdeEncoding);
            serde.readHeader(dataIn);
            for (int i = 0; i < numRecords; ++i) {
                T record = serde.deserializeRecord(dataIn, serdeVersion);
                if (record == null) {
                    throw new EOFException();
                }
                UpdateType updateType = serde.getUpdateType(record);
                if (updateType == UpdateType.DELETE) {
                    logger.warn("While recovering from snapshot, found record with type 'DELETE'; this record will not be restored");
                    continue;
                }
                logger.trace("Recovered from snapshot: {}", record);
                recordMap.put(serde.getRecordIdentifier(record), record);
            }
            int numSwapRecords = dataIn.readInt();
            HashSet<String> swapLocations = new HashSet<String>();
            for (int i = 0; i < numSwapRecords; ++i) {
                swapLocations.add(dataIn.readUTF());
            }
            this.recoveredExternalLocations.addAll(swapLocations);
            logger.debug("{} restored {} Records and {} Swap Files from Snapshot, ending with Transaction ID {}", new Object[]{this, numRecords, this.recoveredExternalLocations.size(), maxTransactionId});
            Long l = maxTransactionId;
            return l;
        }
    }

    private void recoverFromEdits(Map<Object, T> modifiableRecordMap, Long maxTransactionIdRestored) throws IOException {
        HashMap updateMap = new HashMap();
        Map<Object, T> unmodifiableRecordMap = Collections.unmodifiableMap(modifiableRecordMap);
        HashMap ignorableMap = new HashMap();
        HashSet<String> ignorableSwapLocations = new HashSet<String>();
        TreeMap<Long, Partition> transactionMap = new TreeMap<Long, Partition>();
        for (Partition<T> partition : this.partitions) {
            boolean bl;
            do {
                Object transactionId;
                boolean bl2 = bl = (transactionId = partition.getNextRecoverableTransactionId()) == null || maxTransactionIdRestored == null || (Long)transactionId > maxTransactionIdRestored;
                if (bl && transactionId != null) {
                    transactionMap.put((Long)transactionId, partition);
                    continue;
                }
                if (transactionId == null) continue;
                try {
                    partition.recoverNextTransaction(ignorableMap, updateMap, ignorableSwapLocations);
                }
                catch (EOFException e) {
                    logger.error("{} unexpectedly reached End of File while reading from {} for Transaction {}; assuming crash and ignoring this transaction.", new Object[]{this, partition, transactionId});
                }
            } while (!bl);
        }
        while (!transactionMap.isEmpty()) {
            Map.Entry firstEntry = transactionMap.entrySet().iterator().next();
            Long firstTransactionId = (Long)firstEntry.getKey();
            Partition nextPartition = (Partition)firstEntry.getValue();
            try {
                updateMap.clear();
                Set<Object> idsRemoved = nextPartition.recoverNextTransaction(unmodifiableRecordMap, updateMap, this.recoveredExternalLocations);
                modifiableRecordMap.putAll(updateMap);
                for (Object e : idsRemoved) {
                    modifiableRecordMap.remove(e);
                }
            }
            catch (EOFException e) {
                logger.error("{} unexpectedly reached End-of-File when reading from {} for Transaction ID {}; assuming crash and ignoring this transaction", new Object[]{this, nextPartition, firstTransactionId});
            }
            transactionMap.remove(firstTransactionId);
            Long subsequentTransactionId = null;
            try {
                subsequentTransactionId = nextPartition.getNextRecoverableTransactionId();
            }
            catch (IOException e) {
                logger.error("{} unexpectedly found End-of-File when reading from {} for Transaction ID {}; assuming crash and ignoring this transaction", new Object[]{this, nextPartition, firstTransactionId});
            }
            if (subsequentTransactionId == null) continue;
            transactionMap.put(subsequentTransactionId, nextPartition);
        }
        for (Partition<T> partition : this.partitions) {
            partition.endRecovery();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int checkpoint() throws IOException {
        HashSet<String> swapLocations;
        long maxTransactionId;
        HashSet records;
        long startNanos = System.nanoTime();
        FileOutputStream fileOut = null;
        DataOutputStream dataOut = null;
        long stopTheWorldNanos = -1L;
        long stopTheWorldStart = -1L;
        try {
            ArrayList<OutputStream> partitionStreams = new ArrayList<OutputStream>();
            this.writeLock.lock();
            try {
                stopTheWorldStart = System.nanoTime();
                records = new HashSet(this.recordMap.values());
                maxTransactionId = this.transactionIdGenerator.get() - 1L;
                swapLocations = new HashSet<String>(this.externalLocations);
                for (Partition<T> partition : this.partitions) {
                    try {
                        partitionStreams.add(partition.rollover());
                    }
                    catch (Throwable t) {
                        partition.blackList();
                        this.numberBlackListedPartitions.getAndIncrement();
                        throw t;
                    }
                }
            }
            finally {
                this.writeLock.unlock();
            }
            stopTheWorldNanos = System.nanoTime() - stopTheWorldStart;
            IOException failure = null;
            for (OutputStream partitionStream : partitionStreams) {
                try {
                    partitionStream.close();
                }
                catch (IOException e) {
                    failure = e;
                }
            }
            if (failure != null) {
                throw failure;
            }
            if (this.syncListener != null) {
                this.syncListener.onGlobalSync();
            }
            Partition<T>[] serde = this.serdeFactory.createSerDe(null);
            fileOut = new FileOutputStream(this.partialPath.toFile());
            dataOut = new DataOutputStream(new BufferedOutputStream(fileOut));
            dataOut.writeUTF(MinimalLockingWriteAheadLog.class.getName());
            dataOut.writeInt(this.getVersion());
            dataOut.writeUTF(serde.getClass().getName());
            dataOut.writeInt(serde.getVersion());
            dataOut.writeLong(maxTransactionId);
            dataOut.writeInt(records.size());
            serde.writeHeader(dataOut);
            for (Object record : records) {
                logger.trace("Checkpointing {}", record);
                serde.serializeRecord(record, dataOut);
            }
            dataOut.writeInt(swapLocations.size());
            for (String swapLocation : swapLocations) {
                dataOut.writeUTF(swapLocation);
            }
        }
        finally {
            if (dataOut != null) {
                try {
                    try {
                        dataOut.flush();
                        fileOut.getFD().sync();
                    }
                    finally {
                        dataOut.close();
                    }
                }
                catch (IOException e) {
                    logger.warn("Failed to close Data Stream", (Throwable)e);
                }
            }
        }
        Files.deleteIfExists(this.snapshotPath);
        Files.move(this.partialPath, this.snapshotPath, new CopyOption[0]);
        long partitionStart = System.nanoTime();
        for (Partition<T> partition : this.partitions) {
            partition.clearOld();
        }
        long partitionEnd = System.nanoTime();
        this.numberBlackListedPartitions.set(0);
        long endNanos = System.nanoTime();
        long millis = TimeUnit.MILLISECONDS.convert(endNanos - startNanos, TimeUnit.NANOSECONDS);
        long partitionMillis = TimeUnit.MILLISECONDS.convert(partitionEnd - partitionStart, TimeUnit.NANOSECONDS);
        long stopTheWorldMillis = TimeUnit.NANOSECONDS.toMillis(stopTheWorldNanos);
        logger.info("{} checkpointed with {} Records and {} Swap Files in {} milliseconds (Stop-the-world time = {} milliseconds, Clear Edit Logs time = {} millis), max Transaction ID {}", new Object[]{this, records.size(), swapLocations.size(), millis, stopTheWorldMillis, partitionMillis, maxTransactionId});
        return records.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() throws IOException {
        this.writeLock.lock();
        try {
            for (Partition<T> partition : this.partitions) {
                partition.close();
            }
        }
        finally {
            this.writeLock.unlock();
            this.lockChannel.close();
            File lockFile = new File(this.basePath.toFile(), "wali.lock");
            lockFile.delete();
        }
    }

    public int getVersion() {
        return 1;
    }

    private static class Partition<S> {
        public static final String JOURNAL_EXTENSION = ".journal";
        private static final int NUL_BYTE = 0;
        private static final Pattern JOURNAL_FILENAME_PATTERN = Pattern.compile("\\d+\\.journal");
        private final SerDeFactory<S> serdeFactory;
        private SerDe<S> serde;
        private final Path editDirectory;
        private final int writeAheadLogVersion;
        private DataOutputStream dataOut = null;
        private FileOutputStream fileOut = null;
        private volatile boolean blackListed = false;
        private volatile boolean closed = false;
        private DataInputStream recoveryIn;
        private int recoveryVersion;
        private String currentJournalFilename = "";
        private static final byte TRANSACTION_CONTINUE = 1;
        private static final byte TRANSACTION_COMMIT = 2;
        private final String description;
        private final AtomicLong maxTransactionId = new AtomicLong(-1L);
        private final Logger logger = LoggerFactory.getLogger(MinimalLockingWriteAheadLog.class);
        private final Queue<Path> recoveryFiles;

        public Partition(Path path, SerDeFactory<S> serdeFactory, int partitionIndex, int writeAheadLogVersion) throws IOException {
            this.editDirectory = path;
            this.serdeFactory = serdeFactory;
            File file = path.toFile();
            if (!file.exists() && !file.mkdirs()) {
                throw new IOException("Could not create directory " + file.getAbsolutePath());
            }
            this.recoveryFiles = new LinkedBlockingQueue<Path>();
            for (Path recoveryPath : this.getRecoveryPaths()) {
                this.recoveryFiles.add(recoveryPath);
            }
            this.description = "Partition-" + partitionIndex;
            this.writeAheadLogVersion = writeAheadLogVersion;
        }

        public boolean tryClaim() {
            return !this.blackListed;
        }

        public void releaseClaim() {
        }

        public void close() {
            this.closed = true;
            FileOutputStream out = this.fileOut;
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.dataOut = null;
            this.fileOut = null;
        }

        public void blackList() {
            this.blackListed = true;
            this.logger.debug("Blacklisted {}", (Object)this);
        }

        public OutputStream rollover() throws IOException {
            FileOutputStream oldOutputStream = this.fileOut;
            this.dataOut = null;
            this.fileOut = null;
            this.serde = this.serdeFactory.createSerDe(null);
            Path editPath = this.getNewEditPath();
            FileOutputStream fos = new FileOutputStream(editPath.toFile());
            try {
                DataOutputStream outStream = new DataOutputStream(new BufferedOutputStream(fos));
                outStream.writeUTF(MinimalLockingWriteAheadLog.class.getName());
                outStream.writeInt(this.writeAheadLogVersion);
                outStream.writeUTF(this.serde.getClass().getName());
                outStream.writeInt(this.serde.getVersion());
                this.serde.writeHeader(outStream);
                outStream.flush();
                this.dataOut = outStream;
                this.fileOut = fos;
            }
            catch (IOException ioe) {
                try {
                    ((OutputStream)oldOutputStream).close();
                }
                catch (IOException ioe2) {
                    ioe.addSuppressed(ioe2);
                }
                this.logger.error("Failed to create new journal for {}", (Object)this, (Object)ioe);
                try {
                    fos.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.dataOut = null;
                this.fileOut = null;
                this.blackList();
                throw ioe;
            }
            this.currentJournalFilename = editPath.toFile().getName();
            this.blackListed = false;
            return oldOutputStream;
        }

        private long getJournalIndex(File file) {
            String filename = file.getName();
            int dotIndex = filename.indexOf(".");
            String number = filename.substring(0, dotIndex);
            return Long.parseLong(number);
        }

        private Path getNewEditPath() {
            long newIndex;
            List<Path> recoveryPaths = this.getRecoveryPaths();
            if (recoveryPaths == null || recoveryPaths.isEmpty()) {
                newIndex = 1L;
            } else {
                long lastFileIndex = this.getJournalIndex(recoveryPaths.get(recoveryPaths.size() - 1).toFile());
                newIndex = lastFileIndex + 1L;
            }
            return this.editDirectory.resolve(newIndex + JOURNAL_EXTENSION);
        }

        private List<Path> getRecoveryPaths() {
            ArrayList<Path> paths = new ArrayList<Path>();
            File directory = this.editDirectory.toFile();
            File[] partitionFiles = directory.listFiles();
            if (partitionFiles == null) {
                return paths;
            }
            for (File file : partitionFiles) {
                if (file.isDirectory() || file.length() == 0L || !JOURNAL_FILENAME_PATTERN.matcher(file.getName()).matches()) continue;
                if (this.isJournalFile(file)) {
                    paths.add(file.toPath());
                    continue;
                }
                this.logger.warn("Found file {}, but could not access it, or it was not in the expected format; will ignore this file", (Object)file.getAbsolutePath());
            }
            Collections.sort(paths, new Comparator<Path>(){

                @Override
                public int compare(Path o1, Path o2) {
                    if (o1 == null && o2 == null) {
                        return 0;
                    }
                    if (o1 == null) {
                        return 1;
                    }
                    if (o2 == null) {
                        return -1;
                    }
                    long index1 = this.getJournalIndex(o1.toFile());
                    long index2 = this.getJournalIndex(o2.toFile());
                    return Long.compare(index1, index2);
                }
            });
            return paths;
        }

        void clearOld() {
            List<Path> oldRecoveryFiles = this.getRecoveryPaths();
            for (Path path : oldRecoveryFiles) {
                File file = path.toFile();
                if (file.getName().equals(this.currentJournalFilename) || !file.exists()) continue;
                file.delete();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean isJournalFile(File file) {
            String expectedStartsWith = MinimalLockingWriteAheadLog.class.getName();
            try (FileInputStream fis = new FileInputStream(file);
                 BufferedInputStream bufferedIn = new BufferedInputStream(fis);
                 DataInputStream in = new DataInputStream(bufferedIn);){
                String waliImplClassName = in.readUTF();
                if (expectedStartsWith.equals(waliImplClassName)) return true;
                boolean bl = false;
                return bl;
            }
            catch (IOException e) {
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void update(Collection<S> records, long transactionId, Map<Object, S> recordMap, boolean forceSync) throws IOException {
            block16: {
                try (ByteArrayOutputStream baos = new ByteArrayOutputStream(256);
                     DataOutputStream out = new DataOutputStream(baos);){
                    out.writeLong(transactionId);
                    int numEditsToSerialize = records.size();
                    int editsSerialized = 0;
                    for (S record : records) {
                        Object recordId = this.serde.getRecordIdentifier(record);
                        S previousVersion = recordMap.get(recordId);
                        this.serde.serializeEdit(previousVersion, record, out);
                        if (++editsSerialized < numEditsToSerialize) {
                            out.write(1);
                            continue;
                        }
                        out.write(2);
                    }
                    out.flush();
                    if (this.closed) {
                        throw new IllegalStateException("Partition is closed");
                    }
                    baos.writeTo(this.dataOut);
                    this.dataOut.flush();
                    if (!forceSync) break block16;
                    FileOutputStream fileOutputStream = this.fileOut;
                    synchronized (fileOutputStream) {
                        this.fileOut.getFD().sync();
                    }
                }
            }
        }

        private DataInputStream createDataInputStream(Path path) throws IOException {
            return new DataInputStream(new BufferedInputStream(Files.newInputStream(path, new OpenOption[0])));
        }

        private DataInputStream getRecoveryStream() throws IOException {
            if (this.recoveryIn != null && this.hasMoreData(this.recoveryIn)) {
                return this.recoveryIn;
            }
            while (true) {
                Path nextRecoveryPath;
                if ((nextRecoveryPath = this.recoveryFiles.poll()) == null) {
                    return null;
                }
                this.logger.debug("{} recovering from {}", (Object)this, (Object)nextRecoveryPath);
                this.recoveryIn = this.createDataInputStream(nextRecoveryPath);
                if (!this.hasMoreData(this.recoveryIn)) continue;
                try {
                    String waliImplementationClass = this.recoveryIn.readUTF();
                    if (!MinimalLockingWriteAheadLog.class.getName().equals(waliImplementationClass)) continue;
                    long waliVersion = this.recoveryIn.readInt();
                    if (waliVersion > (long)this.writeAheadLogVersion) {
                        throw new IOException("Cannot recovery from file " + nextRecoveryPath + " because it was written using WALI version " + waliVersion + ", but the version used to restore it is only " + this.writeAheadLogVersion);
                    }
                    String serdeEncoding = this.recoveryIn.readUTF();
                    this.recoveryVersion = this.recoveryIn.readInt();
                    this.serde = this.serdeFactory.createSerDe(serdeEncoding);
                    this.serde.readHeader(this.recoveryIn);
                }
                catch (Exception e) {
                    this.logger.warn("Failed to recover data from Write-Ahead Log for {} because the header information could not be read properly. This often is the result of the file not being fully written out before the application is restarted. This file will be ignored.", (Object)nextRecoveryPath);
                    continue;
                }
                break;
            }
            return this.recoveryIn;
        }

        public Long getNextRecoverableTransactionId() throws IOException {
            long transactionId;
            while (true) {
                DataInputStream recoveryStream;
                if ((recoveryStream = this.getRecoveryStream()) == null) {
                    return null;
                }
                try {
                    transactionId = this.recoveryIn.readLong();
                }
                catch (EOFException e) {
                    continue;
                }
                catch (Exception e) {
                    if (this.remainingBytesAllNul(this.recoveryIn)) {
                        this.logger.warn("Failed to recover data from Write-Ahead Log Partition because encountered trailing NUL bytes. This will sometimes happen after a sudden power loss. The rest of this journal file will be skipped for recovery purposes.");
                        continue;
                    }
                    throw e;
                }
                break;
            }
            this.maxTransactionId.set(transactionId);
            return transactionId;
        }

        private boolean remainingBytesAllNul(InputStream in) throws IOException {
            int nextByte;
            while ((nextByte = in.read()) != -1) {
                if (nextByte == 0) continue;
                return false;
            }
            return true;
        }

        private boolean hasMoreData(InputStream in) throws IOException {
            in.mark(1);
            int nextByte = in.read();
            in.reset();
            return nextByte >= 0;
        }

        public void endRecovery() throws IOException {
            Path nextRecoveryPath;
            if (this.recoveryIn != null) {
                this.recoveryIn.close();
            }
            if ((nextRecoveryPath = this.recoveryFiles.poll()) != null) {
                throw new IllegalStateException("Signaled to end recovery, but there are more recovery files for Partition in directory " + this.editDirectory);
            }
            Path newEditPath = this.getNewEditPath();
            this.serde = this.serdeFactory.createSerDe(null);
            FileOutputStream fos = new FileOutputStream(newEditPath.toFile());
            DataOutputStream outStream = new DataOutputStream(new BufferedOutputStream(fos));
            outStream.writeUTF(MinimalLockingWriteAheadLog.class.getName());
            outStream.writeInt(this.writeAheadLogVersion);
            outStream.writeUTF(this.serde.getClass().getName());
            outStream.writeInt(this.serde.getVersion());
            this.serde.writeHeader(outStream);
            outStream.flush();
            this.dataOut = outStream;
            this.fileOut = fos;
        }

        public Set<Object> recoverNextTransaction(Map<Object, S> currentRecordMap, Map<Object, S> updatedRecordMap, Set<String> swapLocations) throws IOException {
            int transactionFlag;
            HashSet<Object> idsRemoved = new HashSet<Object>();
            do {
                String location;
                S record;
                try {
                    record = this.serde.deserializeEdit(this.recoveryIn, currentRecordMap, this.recoveryVersion);
                    if (record == null) {
                        throw new EOFException();
                    }
                }
                catch (EOFException eof) {
                    throw eof;
                }
                catch (Exception e) {
                    if (this.remainingBytesAllNul(this.recoveryIn)) {
                        EOFException eof = new EOFException("Failed to recover data from Write-Ahead Log Partition because encountered trailing NUL bytes. This will sometimes happen after a sudden power loss. The rest of this journal file will be skipped for recovery purposes.");
                        eof.addSuppressed(e);
                        throw eof;
                    }
                    throw e;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("{} Recovering Transaction {}: {}", new Object[]{this, this.maxTransactionId.get(), record});
                }
                Object recordId = this.serde.getRecordIdentifier(record);
                UpdateType updateType = this.serde.getUpdateType(record);
                if (updateType == UpdateType.DELETE) {
                    updatedRecordMap.remove(recordId);
                    idsRemoved.add(recordId);
                    continue;
                }
                if (updateType == UpdateType.SWAP_IN) {
                    location = this.serde.getLocation(record);
                    if (location == null) {
                        this.logger.error("Recovered SWAP_IN record from edit log, but it did not contain a Location; skipping record");
                        continue;
                    }
                    swapLocations.remove(location);
                    updatedRecordMap.put(recordId, record);
                    idsRemoved.remove(recordId);
                    continue;
                }
                if (updateType == UpdateType.SWAP_OUT) {
                    location = this.serde.getLocation(record);
                    if (location == null) {
                        this.logger.error("Recovered SWAP_OUT record from edit log, but it did not contain a Location; skipping record");
                        continue;
                    }
                    swapLocations.add(location);
                    updatedRecordMap.remove(recordId);
                    idsRemoved.add(recordId);
                    continue;
                }
                updatedRecordMap.put(recordId, record);
                idsRemoved.remove(recordId);
            } while ((transactionFlag = this.recoveryIn.read()) != 2);
            return idsRemoved;
        }

        public long getMaxRecoveredTransactionId() {
            return this.maxTransactionId.get();
        }

        public String toString() {
            return this.description;
        }
    }
}

