/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.windows.event.log.jna;

import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinError;
import java.lang.reflect.Modifier;
import java.util.Arrays;

public class ErrorLookup {
    private final Kernel32 kernel32;

    public ErrorLookup(Kernel32 kernel32) {
        this.kernel32 = kernel32;
    }

    public String getLastError() {
        int lastError = this.kernel32.GetLastError();
        return Arrays.stream(WinError.class.getDeclaredFields()).filter(field -> {
            try {
                return Modifier.isStatic(field.getModifiers()) && field.getType() == Integer.TYPE && field.getName().startsWith("ERROR") && (Integer)field.get(null) == lastError;
            }
            catch (IllegalAccessException e) {
                return false;
            }
        }).map(field -> field.getName() + "(" + lastError + ")").findFirst().orElse(Integer.toString(lastError));
    }
}

