/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.knox;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.security.NiFiAuthenticationFilter;
import org.apache.nifi.web.security.knox.KnoxAuthenticationRequestToken;
import org.springframework.security.core.Authentication;

public class KnoxAuthenticationFilter
extends NiFiAuthenticationFilter {
    @Override
    public Authentication attemptAuthentication(HttpServletRequest request) {
        if (!request.isSecure()) {
            return null;
        }
        NiFiProperties properties = this.getProperties();
        if (!properties.isKnoxSsoEnabled()) {
            return null;
        }
        String knoxJwt = this.getJwtFromCookie(request, properties.getKnoxCookieName());
        if (knoxJwt == null) {
            return null;
        }
        return new KnoxAuthenticationRequestToken(knoxJwt, request.getRemoteAddr());
    }

    public String getJwtFromCookie(HttpServletRequest request, String cookieName) {
        String jwt = null;
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookieName.equals(cookie.getName())) continue;
                jwt = cookie.getValue();
                break;
            }
        }
        return jwt;
    }
}

