/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.saml2.web.authentication;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.time.Duration;
import java.util.Collections;
import java.util.regex.Pattern;
import org.apache.nifi.authorization.util.IdentityMapping;
import org.apache.nifi.web.security.cookie.ApplicationCookieName;
import org.apache.nifi.web.security.jwt.provider.BearerTokenProvider;
import org.apache.nifi.web.security.saml2.web.authentication.Saml2AuthenticationSuccessHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.authentication.TestingAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;

@ExtendWith(value={MockitoExtension.class})
class Saml2AuthenticationSuccessHandlerTest {
    private static final Duration EXPIRATION = Duration.ofMinutes(1L);
    private static final String IDENTITY = Authentication.class.getSimpleName();
    private static final String AUTHORITY = GrantedAuthority.class.getSimpleName();
    private static final String REQUEST_URI = "/nifi-api";
    private static final String UI_PATH = "/nifi/";
    private static final int SERVER_PORT = 8080;
    private static final String LOCALHOST_URL = "http://localhost:8080";
    private static final String TARGET_URL = String.format("%s%s", "http://localhost:8080", "/nifi/");
    static final String FORWARDED_PATH = "/forwarded";
    static final String FORWARDED_COOKIE_PATH = String.format("%s/", "/forwarded");
    private static final String FORWARDED_TARGET_URL = String.format("%s%s%s", "http://localhost:8080", "/forwarded", "/nifi/");
    private static final String FIRST_GROUP = "$1";
    private static final Pattern MATCH_PATTERN = Pattern.compile("(.*)");
    static final String ROOT_PATH = "/";
    private static final String ALLOWED_CONTEXT_PATHS_PARAMETER = "allowedContextPaths";
    private static final IdentityMapping UPPER_IDENTITY_MAPPING = new IdentityMapping(IdentityMapping.Transform.UPPER.toString(), MATCH_PATTERN, "$1", IdentityMapping.Transform.UPPER);
    private static final IdentityMapping LOWER_IDENTITY_MAPPING = new IdentityMapping(IdentityMapping.Transform.LOWER.toString(), MATCH_PATTERN, "$1", IdentityMapping.Transform.LOWER);
    @Mock
    BearerTokenProvider bearerTokenProvider;
    MockHttpServletRequest httpServletRequest;
    MockHttpServletResponse httpServletResponse;
    Saml2AuthenticationSuccessHandler handler;

    Saml2AuthenticationSuccessHandlerTest() {
    }

    @BeforeEach
    void setHandler() {
        this.handler = new Saml2AuthenticationSuccessHandler(this.bearerTokenProvider, Collections.singletonList(UPPER_IDENTITY_MAPPING), Collections.singletonList(LOWER_IDENTITY_MAPPING), EXPIRATION);
        this.httpServletRequest = new MockHttpServletRequest();
        this.httpServletRequest.setServerPort(8080);
        this.httpServletResponse = new MockHttpServletResponse();
    }

    @Test
    void testDetermineTargetUrl() {
        this.httpServletRequest.setRequestURI(REQUEST_URI);
        this.assertTargetUrlEquals(TARGET_URL);
        this.assertBearerCookieAdded(ROOT_PATH);
    }

    @Test
    void testDetermineTargetUrlForwardedPath() {
        ServletContext servletContext = this.httpServletRequest.getServletContext();
        servletContext.setInitParameter(ALLOWED_CONTEXT_PATHS_PARAMETER, FORWARDED_PATH);
        this.httpServletRequest.addHeader("X-Forwarded-Prefix", (Object)FORWARDED_PATH);
        this.httpServletRequest.setRequestURI(REQUEST_URI);
        this.assertTargetUrlEquals(FORWARDED_TARGET_URL);
        this.assertBearerCookieAdded(FORWARDED_COOKIE_PATH);
    }

    void assertTargetUrlEquals(String expectedTargetUrl) {
        TestingAuthenticationToken authentication = new TestingAuthenticationToken((Object)IDENTITY, (Object)IDENTITY, new String[]{AUTHORITY});
        String targetUrl = this.handler.determineTargetUrl((HttpServletRequest)this.httpServletRequest, (HttpServletResponse)this.httpServletResponse, (Authentication)authentication);
        Assertions.assertEquals((Object)expectedTargetUrl, (Object)targetUrl);
    }

    void assertBearerCookieAdded(String expectedCookiePath) {
        Cookie responseCookie = this.httpServletResponse.getCookie(ApplicationCookieName.AUTHORIZATION_BEARER.getCookieName());
        Assertions.assertNotNull((Object)responseCookie);
        Assertions.assertEquals((Object)expectedCookiePath, (Object)responseCookie.getPath());
    }
}

