/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.saml2.service.web;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Collections;
import org.apache.nifi.web.security.saml2.registration.Saml2RegistrationProperty;
import org.apache.nifi.web.security.saml2.service.web.StandardRelyingPartyRegistrationResolver;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistrationRepository;

@ExtendWith(value={MockitoExtension.class})
class StandardRelyingPartyRegistrationResolverTest {
    private static final String SERVICE_LOCATION = "{baseUrl}/login/saml2/sso/{registrationId}";
    private static final String SINGLE_LOGOUT_LOCATION = "{baseUrl}/saml2/slo/{registrationId}";
    private static final String CONTEXT_PATH = "/nifi-api";
    private static final String REQUEST_URI = "/nifi-api/access";
    private static final String FORWARDED_PATH = "/forwarded";
    private static final int SERVER_PORT = 8080;
    private static final String EXPECTED_CONSUMER_SERVICE_LOCATION = "http://localhost:8080/nifi-api/login/saml2/sso/consumer";
    private static final String EXPECTED_FORWARDED_CONSUMER_SERVICE_LOCATION = "http://localhost:8080/forwarded/nifi-api/login/saml2/sso/consumer";
    private static final String EXPECTED_SINGLE_LOGOUT_SERVICE_LOCATION = "http://localhost:8080/forwarded/nifi-api/saml2/slo/consumer";
    private static final String REGISTRATION_ID = Saml2RegistrationProperty.REGISTRATION_ID.getProperty();
    @Mock
    RelyingPartyRegistrationRepository repository;
    MockHttpServletRequest request;

    StandardRelyingPartyRegistrationResolverTest() {
    }

    @BeforeEach
    void setResolver() {
        this.request = new MockHttpServletRequest();
        this.request.setServerPort(8080);
        this.request.setRequestURI(REQUEST_URI);
        this.request.setPathInfo(REQUEST_URI);
        this.request.setContextPath(CONTEXT_PATH);
    }

    @Test
    void testResolveNotFound() {
        StandardRelyingPartyRegistrationResolver resolver = new StandardRelyingPartyRegistrationResolver(this.repository, Collections.emptyList());
        RelyingPartyRegistration registration = resolver.resolve((HttpServletRequest)this.request, REGISTRATION_ID);
        Assertions.assertNull((Object)registration);
    }

    @Test
    void testResolveFound() {
        StandardRelyingPartyRegistrationResolver resolver = new StandardRelyingPartyRegistrationResolver(this.repository, Collections.emptyList());
        RelyingPartyRegistration registration = this.getRegistrationBuilder().build();
        Mockito.when((Object)this.repository.findByRegistrationId((String)ArgumentMatchers.eq((Object)REGISTRATION_ID))).thenReturn((Object)registration);
        RelyingPartyRegistration resolved = resolver.resolve((HttpServletRequest)this.request, REGISTRATION_ID);
        Assertions.assertNotNull((Object)resolved);
        Assertions.assertEquals((Object)EXPECTED_CONSUMER_SERVICE_LOCATION, (Object)resolved.getAssertionConsumerServiceLocation());
    }

    @Test
    void testResolveSingleLogoutForwardedPathFound() {
        StandardRelyingPartyRegistrationResolver resolver = new StandardRelyingPartyRegistrationResolver(this.repository, Collections.singletonList(FORWARDED_PATH));
        RelyingPartyRegistration registration = this.getSingleLogoutRegistration();
        Mockito.when((Object)this.repository.findByRegistrationId((String)ArgumentMatchers.eq((Object)REGISTRATION_ID))).thenReturn((Object)registration);
        this.request.addHeader("X-ProxyContextPath", (Object)FORWARDED_PATH);
        RelyingPartyRegistration resolved = resolver.resolve((HttpServletRequest)this.request, REGISTRATION_ID);
        Assertions.assertNotNull((Object)resolved);
        Assertions.assertEquals((Object)EXPECTED_FORWARDED_CONSUMER_SERVICE_LOCATION, (Object)resolved.getAssertionConsumerServiceLocation());
        Assertions.assertEquals((Object)EXPECTED_SINGLE_LOGOUT_SERVICE_LOCATION, (Object)resolved.getSingleLogoutServiceLocation());
        Assertions.assertEquals((Object)EXPECTED_SINGLE_LOGOUT_SERVICE_LOCATION, (Object)resolved.getSingleLogoutServiceResponseLocation());
    }

    private RelyingPartyRegistration.Builder getRegistrationBuilder() {
        return RelyingPartyRegistration.withRegistrationId((String)REGISTRATION_ID).entityId(REGISTRATION_ID).assertionConsumerServiceLocation(SERVICE_LOCATION).assertingPartyDetails(assertingPartyDetails -> {
            assertingPartyDetails.entityId(REGISTRATION_ID);
            assertingPartyDetails.singleSignOnServiceLocation(SERVICE_LOCATION);
        });
    }

    private RelyingPartyRegistration getSingleLogoutRegistration() {
        return this.getRegistrationBuilder().singleLogoutServiceLocation(SINGLE_LOGOUT_LOCATION).singleLogoutServiceResponseLocation(SINGLE_LOGOUT_LOCATION).build();
    }
}

