/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.oidc.client.web.converter;

import java.time.Instant;
import java.util.LinkedHashMap;
import org.apache.nifi.encrypt.PropertyEncryptor;
import org.apache.nifi.web.security.jwt.provider.SupportedClaim;
import org.apache.nifi.web.security.logout.LogoutRequest;
import org.apache.nifi.web.security.oidc.client.web.OidcAuthorizedClient;
import org.apache.nifi.web.security.oidc.client.web.OidcRegistrationProperty;
import org.apache.nifi.web.security.oidc.client.web.converter.StandardAuthorizedClientConverter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.OAuth2RefreshToken;
import org.springframework.security.oauth2.core.oidc.OidcIdToken;

@ExtendWith(value={MockitoExtension.class})
class StandardAuthorizedClientConverterTest {
    private static final String CLIENT_ID = "client-id";
    private static final String REDIRECT_URI = "http://localhost:8080";
    private static final String AUTHORIZATION_URI = "http://localhost/authorize";
    private static final String TOKEN_URI = "http://localhost/token";
    private static final String USER_IDENTITY = LogoutRequest.class.getSimpleName();
    private static final String ACCESS_TOKEN = "access";
    private static final String REFRESH_TOKEN = "refresh";
    private static final String ID_TOKEN = "id";
    @Mock
    ClientRegistrationRepository clientRegistrationRepository;
    StandardAuthorizedClientConverter converter;

    StandardAuthorizedClientConverterTest() {
    }

    @BeforeEach
    void setConverter() {
        this.converter = new StandardAuthorizedClientConverter((PropertyEncryptor)new StringPropertyEncryptor(), this.clientRegistrationRepository);
    }

    @Test
    void testGetEncoded() {
        OidcAuthorizedClient oidcAuthorizedClient = this.getOidcAuthorizedClient(new OAuth2RefreshToken(REFRESH_TOKEN, Instant.now()));
        String encoded = this.converter.getEncoded(oidcAuthorizedClient);
        Assertions.assertNotNull((Object)encoded);
    }

    @Test
    void testGetDecodedInvalid() {
        OidcAuthorizedClient oidcAuthorizedClient = this.converter.getDecoded(String.class.getName());
        Assertions.assertNull((Object)oidcAuthorizedClient);
    }

    @Test
    void testGetEncodedDecoded() {
        OidcAuthorizedClient oidcAuthorizedClient = this.getOidcAuthorizedClient(new OAuth2RefreshToken(REFRESH_TOKEN, Instant.now()));
        String encoded = this.converter.getEncoded(oidcAuthorizedClient);
        Assertions.assertNotNull((Object)encoded);
        ClientRegistration clientRegistration = this.getClientRegistration();
        Mockito.when((Object)this.clientRegistrationRepository.findByRegistrationId((String)ArgumentMatchers.eq((Object)OidcRegistrationProperty.REGISTRATION_ID.getProperty()))).thenReturn((Object)clientRegistration);
        OidcAuthorizedClient decoded = this.converter.getDecoded(encoded);
        Assertions.assertEquals((Object)decoded.getClientRegistration().getRedirectUri(), (Object)clientRegistration.getRedirectUri());
        this.assertAuthorizedClientEquals(oidcAuthorizedClient, decoded);
    }

    @Test
    void testGetEncodedDecodedNullRefreshToken() {
        OidcAuthorizedClient oidcAuthorizedClient = this.getOidcAuthorizedClient(null);
        String encoded = this.converter.getEncoded(oidcAuthorizedClient);
        Assertions.assertNotNull((Object)encoded);
        ClientRegistration clientRegistration = this.getClientRegistration();
        Mockito.when((Object)this.clientRegistrationRepository.findByRegistrationId((String)ArgumentMatchers.eq((Object)OidcRegistrationProperty.REGISTRATION_ID.getProperty()))).thenReturn((Object)clientRegistration);
        OidcAuthorizedClient decoded = this.converter.getDecoded(encoded);
        Assertions.assertEquals((Object)decoded.getClientRegistration().getRedirectUri(), (Object)clientRegistration.getRedirectUri());
        this.assertAuthorizedClientEquals(oidcAuthorizedClient, decoded);
    }

    void assertAuthorizedClientEquals(OidcAuthorizedClient expected, OidcAuthorizedClient actual) {
        Assertions.assertNotNull((Object)actual);
        Assertions.assertEquals((Object)expected.getPrincipalName(), (Object)actual.getPrincipalName());
        Assertions.assertEquals((Object)expected.getAccessToken().getTokenValue(), (Object)actual.getAccessToken().getTokenValue());
        Assertions.assertEquals((Object)expected.getAccessToken().getExpiresAt(), (Object)actual.getAccessToken().getExpiresAt());
        OidcIdToken idToken = actual.getIdToken();
        Assertions.assertEquals((Object)expected.getIdToken().getTokenValue(), (Object)idToken.getTokenValue());
        Assertions.assertEquals((Object)expected.getIdToken().getExpiresAt(), (Object)idToken.getExpiresAt());
        Assertions.assertEquals((Object)USER_IDENTITY, (Object)idToken.getSubject());
        OAuth2RefreshToken expectedRefreshToken = expected.getRefreshToken();
        if (expectedRefreshToken == null) {
            Assertions.assertNull((Object)actual.getRefreshToken());
        } else {
            OAuth2RefreshToken actualRefreshToken = actual.getRefreshToken();
            Assertions.assertNotNull((Object)actualRefreshToken);
            Assertions.assertEquals((Object)expectedRefreshToken.getTokenValue(), (Object)actualRefreshToken.getTokenValue());
            Assertions.assertEquals((Object)expectedRefreshToken.getExpiresAt(), (Object)actualRefreshToken.getExpiresAt());
        }
    }

    OidcAuthorizedClient getOidcAuthorizedClient(OAuth2RefreshToken refreshToken) {
        Instant issuedAt = Instant.now();
        Instant expiresAt = Instant.MAX;
        ClientRegistration clientRegistration = this.getClientRegistration();
        OAuth2AccessToken accessToken = new OAuth2AccessToken(OAuth2AccessToken.TokenType.BEARER, ACCESS_TOKEN, issuedAt, expiresAt);
        LinkedHashMap<String, Instant> claims = new LinkedHashMap<String, Instant>();
        claims.put(SupportedClaim.ISSUED_AT.getClaim(), issuedAt);
        claims.put(SupportedClaim.EXPIRATION.getClaim(), expiresAt);
        OidcIdToken idToken = new OidcIdToken(ID_TOKEN, issuedAt, expiresAt, claims);
        return new OidcAuthorizedClient(clientRegistration, USER_IDENTITY, accessToken, refreshToken, idToken);
    }

    ClientRegistration getClientRegistration() {
        return ClientRegistration.withRegistrationId((String)OidcRegistrationProperty.REGISTRATION_ID.getProperty()).authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE).clientId(CLIENT_ID).redirectUri(REDIRECT_URI).authorizationUri(AUTHORIZATION_URI).tokenUri(TOKEN_URI).build();
    }

    private static class StringPropertyEncryptor
    implements PropertyEncryptor {
        private StringPropertyEncryptor() {
        }

        public String encrypt(String property) {
            return property;
        }

        public String decrypt(String encryptedProperty) {
            return encryptedProperty;
        }
    }
}

