/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.saml2.web.authentication.logout;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.UUID;
import org.apache.nifi.web.security.cookie.ApplicationCookieName;
import org.apache.nifi.web.security.saml2.registration.Saml2RegistrationProperty;
import org.apache.nifi.web.security.saml2.web.authentication.logout.StandardSaml2LogoutRequestRepository;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.cache.Cache;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.saml2.provider.service.authentication.logout.Saml2LogoutRequest;
import org.springframework.security.saml2.provider.service.registration.RelyingPartyRegistration;

@ExtendWith(value={MockitoExtension.class})
class StandardSaml2LogoutRequestRepositoryTest {
    private static final String REQUEST_IDENTIFIER = UUID.randomUUID().toString();
    private static final String RELAY_STATE = Saml2LogoutRequest.class.getSimpleName();
    private static final String LOCATION = "http://localhost/nifi-api";
    private static final String SAML_REQUEST = "<LoginRequest/>";
    @Mock
    Cache cache;
    MockHttpServletRequest httpServletRequest;
    MockHttpServletResponse httpServletResponse;
    private StandardSaml2LogoutRequestRepository repository;

    StandardSaml2LogoutRequestRepositoryTest() {
    }

    @BeforeEach
    void setRepository() {
        this.repository = new StandardSaml2LogoutRequestRepository(this.cache);
        this.httpServletRequest = new MockHttpServletRequest();
        this.httpServletResponse = new MockHttpServletResponse();
    }

    @Test
    void testLoadLogoutRequestCookieNotFound() {
        Saml2LogoutRequest request = this.repository.loadLogoutRequest((HttpServletRequest)this.httpServletRequest);
        Assertions.assertNull((Object)request);
    }

    @Test
    void testLoadLogoutRequestCacheNotFound() {
        Cookie cookie = new Cookie(ApplicationCookieName.LOGOUT_REQUEST_IDENTIFIER.getCookieName(), REQUEST_IDENTIFIER);
        this.httpServletRequest.setCookies(new Cookie[]{cookie});
        Saml2LogoutRequest request = this.repository.loadLogoutRequest((HttpServletRequest)this.httpServletRequest);
        Assertions.assertNull((Object)request);
    }

    @Test
    void testLoadLogoutRequestFound() {
        Cookie cookie = new Cookie(ApplicationCookieName.LOGOUT_REQUEST_IDENTIFIER.getCookieName(), REQUEST_IDENTIFIER);
        this.httpServletRequest.setCookies(new Cookie[]{cookie});
        Saml2LogoutRequest cachedRequest = this.getRequest();
        Mockito.when((Object)((Saml2LogoutRequest)this.cache.get(ArgumentMatchers.eq((Object)REQUEST_IDENTIFIER), (Class)ArgumentMatchers.eq(Saml2LogoutRequest.class)))).thenReturn((Object)cachedRequest);
        Saml2LogoutRequest request = this.repository.loadLogoutRequest((HttpServletRequest)this.httpServletRequest);
        Assertions.assertNotNull((Object)request);
    }

    @Test
    void testSaveLogoutRequest() {
        this.httpServletRequest.setRequestURI(LOCATION);
        Saml2LogoutRequest request = this.getRequest();
        this.repository.saveLogoutRequest(request, (HttpServletRequest)this.httpServletRequest, (HttpServletResponse)this.httpServletResponse);
        Cookie cookie = this.httpServletResponse.getCookie(ApplicationCookieName.LOGOUT_REQUEST_IDENTIFIER.getCookieName());
        Assertions.assertNotNull((Object)cookie);
    }

    @Test
    void testRemoveLogoutRequestCookieNotFound() {
        Saml2LogoutRequest request = this.repository.removeLogoutRequest((HttpServletRequest)this.httpServletRequest, (HttpServletResponse)this.httpServletResponse);
        Assertions.assertNull((Object)request);
    }

    @Test
    void testRemoveLogoutRequestFound() {
        Cookie cookie = new Cookie(ApplicationCookieName.LOGOUT_REQUEST_IDENTIFIER.getCookieName(), REQUEST_IDENTIFIER);
        this.httpServletRequest.setCookies(new Cookie[]{cookie});
        this.httpServletRequest.setRequestURI(LOCATION);
        Saml2LogoutRequest cachedRequest = this.getRequest();
        Mockito.when((Object)((Saml2LogoutRequest)this.cache.get(ArgumentMatchers.eq((Object)REQUEST_IDENTIFIER), (Class)ArgumentMatchers.eq(Saml2LogoutRequest.class)))).thenReturn((Object)cachedRequest);
        Saml2LogoutRequest request = this.repository.removeLogoutRequest((HttpServletRequest)this.httpServletRequest, (HttpServletResponse)this.httpServletResponse);
        Assertions.assertNotNull((Object)request);
    }

    private Saml2LogoutRequest getRequest() {
        RelyingPartyRegistration registration = RelyingPartyRegistration.withRegistrationId((String)Saml2RegistrationProperty.REGISTRATION_ID.getProperty()).entityId(Saml2RegistrationProperty.REGISTRATION_ID.getProperty()).assertingPartyDetails(assertingPartyDetails -> {
            assertingPartyDetails.entityId(Saml2RegistrationProperty.REGISTRATION_ID.getProperty());
            assertingPartyDetails.singleSignOnServiceLocation(LOCATION);
        }).build();
        return Saml2LogoutRequest.withRelyingPartyRegistration((RelyingPartyRegistration)registration).samlRequest(SAML_REQUEST).relayState(RELAY_STATE).build();
    }
}

