/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.csrf;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.UUID;
import org.apache.nifi.web.security.csrf.StandardCookieCsrfTokenRepository;
import org.apache.nifi.web.security.http.SecurityCookieName;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;
import org.springframework.security.web.csrf.CsrfToken;

public class StandardCookieCsrfTokenRepositoryTest {
    private static final String ALLOWED_CONTEXT_PATHS_PARAMETER = "allowedContextPaths";
    private static final int MAX_AGE_SESSION = -1;
    private static final int MAX_AGE_EXPIRED = 0;
    private static final String ROOT_PATH = "/";
    private static final String CONTEXT_PATH = "/context-path";
    private static final String HTTPS = "https";
    private static final String HOST = "localhost";
    private static final String PORT = "443";
    private static final String EMPTY = "";
    private static final String SET_COOKIE_HEADER = "Set-Cookie";
    private static final String SAME_SITE = "SameSite";
    private MockHttpServletRequest request;
    private MockHttpServletResponse response;
    private StandardCookieCsrfTokenRepository repository;

    @BeforeEach
    public void setRepository() {
        this.repository = new StandardCookieCsrfTokenRepository();
        this.request = new MockHttpServletRequest();
        this.response = new MockHttpServletResponse();
    }

    @Test
    public void testGenerateToken() {
        CsrfToken csrfToken = this.repository.generateToken((HttpServletRequest)this.request);
        Assertions.assertNotNull((Object)csrfToken);
        Assertions.assertNotNull((Object)csrfToken.getToken());
    }

    @Test
    public void testGenerateTokenCookieFound() {
        String token = UUID.randomUUID().toString();
        Cookie cookie = new Cookie(SecurityCookieName.REQUEST_TOKEN.getName(), token);
        this.request.setCookies(new Cookie[]{cookie});
        CsrfToken csrfToken = this.repository.generateToken((HttpServletRequest)this.request);
        Assertions.assertNotNull((Object)csrfToken);
        Assertions.assertEquals((Object)token, (Object)csrfToken.getToken());
    }

    @Test
    public void testLoadToken() {
        String token = UUID.randomUUID().toString();
        Cookie cookie = new Cookie(SecurityCookieName.REQUEST_TOKEN.getName(), token);
        this.request.setCookies(new Cookie[]{cookie});
        CsrfToken csrfToken = this.repository.loadToken((HttpServletRequest)this.request);
        Assertions.assertNotNull((Object)csrfToken);
        Assertions.assertEquals((Object)token, (Object)csrfToken.getToken());
    }

    @Test
    public void testSaveToken() {
        CsrfToken csrfToken = this.repository.generateToken((HttpServletRequest)this.request);
        this.repository.saveToken(csrfToken, (HttpServletRequest)this.request, (HttpServletResponse)this.response);
        Cookie cookie = this.assertCookieFound();
        String setCookieHeader = this.response.getHeader(SET_COOKIE_HEADER);
        this.assertCookieEquals(csrfToken.getToken(), -1, cookie, setCookieHeader);
        Assertions.assertEquals((Object)ROOT_PATH, (Object)cookie.getPath());
    }

    @Test
    public void testSaveTokenNullCsrfToken() {
        this.repository.saveToken(null, (HttpServletRequest)this.request, (HttpServletResponse)this.response);
        Cookie cookie = this.assertCookieFound();
        String setCookieHeader = this.response.getHeader(SET_COOKIE_HEADER);
        this.assertCookieEquals(EMPTY, 0, cookie, setCookieHeader);
    }

    @Test
    public void testSaveTokenProxyContextPath() {
        this.repository = new StandardCookieCsrfTokenRepository();
        CsrfToken csrfToken = this.repository.generateToken((HttpServletRequest)this.request);
        this.request.addHeader("X-ProxyScheme", (Object)HTTPS);
        this.request.addHeader("X-ProxyHost", (Object)HOST);
        this.request.addHeader("X-ProxyPort", (Object)PORT);
        this.request.addHeader("X-ProxyContextPath", (Object)CONTEXT_PATH);
        MockServletContext servletContext = (MockServletContext)this.request.getServletContext();
        servletContext.setInitParameter(ALLOWED_CONTEXT_PATHS_PARAMETER, CONTEXT_PATH);
        this.repository.saveToken(csrfToken, (HttpServletRequest)this.request, (HttpServletResponse)this.response);
        Cookie cookie = this.assertCookieFound();
        String setCookieHeader = this.response.getHeader(SET_COOKIE_HEADER);
        this.assertCookieEquals(csrfToken.getToken(), -1, cookie, setCookieHeader);
        Assertions.assertEquals((Object)CONTEXT_PATH, (Object)cookie.getPath());
    }

    private Cookie assertCookieFound() {
        Cookie cookie = this.response.getCookie(SecurityCookieName.REQUEST_TOKEN.getName());
        Assertions.assertNotNull((Object)cookie);
        return cookie;
    }

    private void assertCookieEquals(String token, int maxAge, Cookie cookie, String setCookieHeader) {
        Assertions.assertNotNull((Object)setCookieHeader);
        Assertions.assertEquals((Object)token, (Object)cookie.getValue());
        Assertions.assertEquals((int)maxAge, (int)cookie.getMaxAge());
        Assertions.assertTrue((boolean)cookie.getSecure());
        Assertions.assertFalse((boolean)cookie.isHttpOnly());
        Assertions.assertEquals((Object)HOST, (Object)cookie.getDomain());
        Assertions.assertTrue((boolean)setCookieHeader.contains(SAME_SITE), (String)"SameSite not found");
    }
}

