/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.jwt.converter;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.PlainJWT;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.nifi.authorization.AccessPolicyProvider;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.Group;
import org.apache.nifi.authorization.ManagedAuthorizer;
import org.apache.nifi.authorization.UserAndGroups;
import org.apache.nifi.authorization.UserGroupProvider;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserDetails;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.security.jwt.converter.StandardJwtAuthenticationConverter;
import org.apache.nifi.web.security.jwt.provider.SupportedClaim;
import org.apache.nifi.web.security.token.NiFiAuthenticationToken;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.security.oauth2.jwt.Jwt;

@ExtendWith(value={MockitoExtension.class})
public class StandardJwtAuthenticationConverterTest {
    private static final String USERNAME = "NiFi";
    private static final String AUTHORIZER_GROUP = "AuthorizerGroup";
    private static final String PROVIDER_GROUP = "ProviderGroup";
    private static final String TYPE_FIELD = "typ";
    private static final String JWT_TYPE = "JWT";
    @Mock
    private ManagedAuthorizer authorizer;
    @Mock
    private AccessPolicyProvider accessPolicyProvider;
    @Mock
    private UserGroupProvider userGroupProvider;
    @Mock
    private UserAndGroups userAndGroups;
    private StandardJwtAuthenticationConverter converter;

    @BeforeEach
    public void setConverter() {
        HashMap properties = new HashMap();
        NiFiProperties niFiProperties = NiFiProperties.createBasicNiFiProperties((String)"", properties);
        this.converter = new StandardJwtAuthenticationConverter((Authorizer)this.authorizer, niFiProperties);
        Mockito.when((Object)this.authorizer.getAccessPolicyProvider()).thenReturn((Object)this.accessPolicyProvider);
        Mockito.when((Object)this.accessPolicyProvider.getUserGroupProvider()).thenReturn((Object)this.userGroupProvider);
        Mockito.when((Object)this.userGroupProvider.getUserAndGroups((String)ArgumentMatchers.eq((Object)USERNAME))).thenReturn((Object)this.userAndGroups);
        Group group = new Group.Builder().name(AUTHORIZER_GROUP).identifier(AUTHORIZER_GROUP).build();
        Mockito.when((Object)this.userAndGroups.getGroups()).thenReturn(Collections.singleton(group));
    }

    @Test
    public void testConvert() {
        List<String> providerGroups = Collections.singletonList(PROVIDER_GROUP);
        JWTClaimsSet claimsSet = new JWTClaimsSet.Builder().subject(USERNAME).claim(SupportedClaim.GROUPS.getClaim(), providerGroups).build();
        String token = new PlainJWT(claimsSet).serialize();
        Jwt jwt = Jwt.withTokenValue((String)token).header(TYPE_FIELD, (Object)JWT_TYPE).subject(USERNAME).claim(SupportedClaim.GROUPS.getClaim(), providerGroups).build();
        NiFiAuthenticationToken authenticationToken = this.converter.convert(jwt);
        Assertions.assertNotNull((Object)authenticationToken);
        Assertions.assertEquals((Object)USERNAME, (Object)authenticationToken.toString());
        NiFiUserDetails details = (NiFiUserDetails)authenticationToken.getDetails();
        NiFiUser user = details.getNiFiUser();
        Set<String> expectedGroups = Collections.singleton(AUTHORIZER_GROUP);
        Assertions.assertEquals(expectedGroups, (Object)user.getGroups());
        Set<String> expectedProviderGroups = Collections.singleton(PROVIDER_GROUP);
        Assertions.assertEquals(expectedProviderGroups, (Object)user.getIdentityProviderGroups());
    }
}

