/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.spring;

import java.io.File;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.apache.nifi.authentication.LoginIdentityProvider;
import org.apache.nifi.bundle.Bundle;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.security.spring.LoginIdentityProviderFactoryBean;
import org.apache.nifi.web.security.spring.mock.MockLoginIdentityProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class LoginIdentityProviderFactoryBeanTest {
    private static final String PROVIDERS_PATH = "/login-identity-providers.xml";
    private static final String PROVIDER_ID = "login-identity-provider";
    @Mock
    NiFiProperties properties;
    @Mock
    ExtensionManager extensionManager;
    @Mock
    Bundle bundle;

    LoginIdentityProviderFactoryBeanTest() {
    }

    @Test
    void testGetObjectNotConfigured() throws Exception {
        LoginIdentityProviderFactoryBean bean = new LoginIdentityProviderFactoryBean();
        bean.setProperties(this.properties);
        bean.setExtensionManager(this.extensionManager);
        Object object = bean.getObject();
        Assertions.assertNull((Object)object);
    }

    @Test
    void testGetObject() throws Exception {
        Mockito.when((Object)this.properties.getProperty((String)ArgumentMatchers.eq((Object)"nifi.security.user.login.identity.provider"))).thenReturn((Object)PROVIDER_ID);
        Mockito.when((Object)this.properties.getLoginIdentityProviderConfigurationFile()).thenReturn((Object)this.getLoginIdentityProvidersFile());
        Mockito.when((Object)this.bundle.getClassLoader()).thenReturn((Object)this.getClass().getClassLoader());
        List<Bundle> bundles = Collections.singletonList(this.bundle);
        Mockito.when((Object)this.extensionManager.getBundles((String)ArgumentMatchers.eq((Object)MockLoginIdentityProvider.class.getName()))).thenReturn(bundles);
        LoginIdentityProviderFactoryBean bean = new LoginIdentityProviderFactoryBean();
        bean.setProperties(this.properties);
        bean.setExtensionManager(this.extensionManager);
        Object object = bean.getObject();
        Assertions.assertInstanceOf(LoginIdentityProvider.class, (Object)object);
    }

    private File getLoginIdentityProvidersFile() {
        URL url = LoginIdentityProviderFactoryBeanTest.class.getResource(PROVIDERS_PATH);
        if (url == null) {
            throw new IllegalStateException(String.format("Providers [%s] not found", PROVIDERS_PATH));
        }
        return new File(url.getPath());
    }
}

