/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.saml2.web.authentication.logout;

import java.io.IOException;
import java.util.UUID;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.nifi.web.security.cookie.ApplicationCookieName;
import org.apache.nifi.web.security.logout.LogoutRequest;
import org.apache.nifi.web.security.logout.LogoutRequestManager;
import org.apache.nifi.web.security.saml2.SamlUrlPath;
import org.apache.nifi.web.security.saml2.web.authentication.logout.Saml2SingleLogoutFilter;
import org.apache.nifi.web.security.token.LogoutAuthenticationToken;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.mock.web.MockFilterChain;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;

@ExtendWith(value={MockitoExtension.class})
class Saml2SingleLogoutFilterTest {
    private static final String REQUEST_IDENTIFIER = UUID.randomUUID().toString();
    private static final String USER_IDENTITY = LogoutRequest.class.getSimpleName();
    @Mock
    LogoutSuccessHandler logoutSuccessHandler;
    MockHttpServletRequest httpServletRequest;
    MockHttpServletResponse httpServletResponse;
    MockFilterChain filterChain;
    LogoutRequestManager logoutRequestManager;
    Saml2SingleLogoutFilter filter;

    Saml2SingleLogoutFilterTest() {
    }

    @BeforeEach
    void setFilter() {
        this.logoutRequestManager = new LogoutRequestManager();
        this.filter = new Saml2SingleLogoutFilter(this.logoutRequestManager, this.logoutSuccessHandler);
        this.httpServletRequest = new MockHttpServletRequest();
        this.httpServletResponse = new MockHttpServletResponse();
        this.filterChain = new MockFilterChain();
    }

    @Test
    void testDoFilterInternalNotMatched() throws ServletException, IOException {
        this.filter.doFilterInternal((HttpServletRequest)this.httpServletRequest, (HttpServletResponse)this.httpServletResponse, (FilterChain)this.filterChain);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.logoutSuccessHandler});
    }

    @Test
    void testDoFilterInternal() throws ServletException, IOException {
        this.httpServletRequest.setPathInfo(SamlUrlPath.SINGLE_LOGOUT_REQUEST.getPath());
        Cookie cookie = new Cookie(ApplicationCookieName.LOGOUT_REQUEST_IDENTIFIER.getCookieName(), REQUEST_IDENTIFIER);
        this.httpServletRequest.setCookies(new Cookie[]{cookie});
        LogoutRequest logoutRequest = new LogoutRequest(REQUEST_IDENTIFIER, USER_IDENTITY);
        this.logoutRequestManager.start(logoutRequest);
        this.filter.doFilterInternal((HttpServletRequest)this.httpServletRequest, (HttpServletResponse)this.httpServletResponse, (FilterChain)this.filterChain);
        ((LogoutSuccessHandler)Mockito.verify((Object)this.logoutSuccessHandler)).onLogoutSuccess((HttpServletRequest)ArgumentMatchers.eq((Object)this.httpServletRequest), (HttpServletResponse)ArgumentMatchers.eq((Object)this.httpServletResponse), (Authentication)ArgumentMatchers.isA(LogoutAuthenticationToken.class));
    }
}

