/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.oidc.userinfo;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.nifi.authorization.util.IdentityMapping;
import org.apache.nifi.web.security.jwt.provider.SupportedClaim;
import org.apache.nifi.web.security.oidc.OidcConfigurationException;
import org.apache.nifi.web.security.oidc.client.web.OidcRegistrationProperty;
import org.apache.nifi.web.security.oidc.userinfo.StandardOidcUserService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.oidc.userinfo.OidcUserRequest;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.oidc.OidcIdToken;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;

class StandardOidcUserServiceTest {
    private static final String REDIRECT_URI = "https://localhost:8443/nifi-api/callback";
    private static final String AUTHORIZATION_URI = "http://localhost/authorize";
    private static final String TOKEN_URI = "http://localhost/token";
    private static final String CLIENT_ID = "client-id";
    private static final String ACCESS_TOKEN = "access";
    private static final String ID_TOKEN = "id";
    private static final String USER_NAME_CLAIM = "email";
    private static final String FALLBACK_CLAIM = "preferred_username";
    private static final String MISSING_CLAIM = "missing";
    private static final String SUBJECT = String.class.getSimpleName();
    private static final String IDENTITY = Authentication.class.getSimpleName();
    private static final String FIRST_GROUP = "$1";
    private static final Pattern MATCH_PATTERN = Pattern.compile("(.*)");
    private static final IdentityMapping UPPER_IDENTITY_MAPPING = new IdentityMapping(IdentityMapping.Transform.UPPER.toString(), MATCH_PATTERN, "$1", IdentityMapping.Transform.UPPER);
    private StandardOidcUserService service;

    StandardOidcUserServiceTest() {
    }

    @BeforeEach
    void setService() {
        this.service = new StandardOidcUserService(Arrays.asList(USER_NAME_CLAIM, FALLBACK_CLAIM), Collections.singletonList(UPPER_IDENTITY_MAPPING));
    }

    @Test
    void testLoadUser() {
        OidcUserRequest userRequest = this.getUserRequest(USER_NAME_CLAIM);
        OidcUser oidcUser = this.service.loadUser(userRequest);
        Assertions.assertNotNull((Object)oidcUser);
        Assertions.assertEquals((Object)IDENTITY.toUpperCase(), (Object)oidcUser.getName());
    }

    @Test
    void testLoadUserFallbackClaim() {
        OidcUserRequest userRequest = this.getUserRequest(FALLBACK_CLAIM);
        OidcUser oidcUser = this.service.loadUser(userRequest);
        Assertions.assertNotNull((Object)oidcUser);
        Assertions.assertEquals((Object)IDENTITY.toUpperCase(), (Object)oidcUser.getName());
    }

    @Test
    void testLoadUserClaimNotFound() {
        OidcUserRequest userRequest = this.getUserRequest(MISSING_CLAIM);
        Assertions.assertThrows(OidcConfigurationException.class, () -> this.service.loadUser(userRequest));
    }

    OidcUserRequest getUserRequest(String userNameClaim) {
        ClientRegistration clientRegistration = this.getClientRegistrationBuilder().build();
        Instant issuedAt = Instant.now();
        Instant expiresAt = Instant.MAX;
        OAuth2AccessToken accessToken = new OAuth2AccessToken(OAuth2AccessToken.TokenType.BEARER, ACCESS_TOKEN, issuedAt, expiresAt);
        Map<String, Object> claims = this.getClaims(userNameClaim);
        OidcIdToken idToken = new OidcIdToken(ID_TOKEN, issuedAt, expiresAt, claims);
        return new OidcUserRequest(clientRegistration, accessToken, idToken);
    }

    Map<String, Object> getClaims(String userNameClaim) {
        LinkedHashMap<String, Object> claims = new LinkedHashMap<String, Object>();
        claims.put(SupportedClaim.SUBJECT.getClaim(), SUBJECT);
        claims.put(SupportedClaim.ISSUED_AT.getClaim(), Instant.now());
        claims.put(SupportedClaim.EXPIRATION.getClaim(), Instant.MAX);
        claims.put(userNameClaim, IDENTITY);
        return claims;
    }

    ClientRegistration.Builder getClientRegistrationBuilder() {
        return ClientRegistration.withRegistrationId((String)OidcRegistrationProperty.REGISTRATION_ID.getProperty()).authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE).clientId(CLIENT_ID).redirectUri(REDIRECT_URI).authorizationUri(AUTHORIZATION_URI).tokenUri(TOKEN_URI);
    }
}

