/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.oidc.client.web;

import java.util.UUID;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.nifi.web.security.cookie.ApplicationCookieName;
import org.apache.nifi.web.security.oidc.client.web.StandardAuthorizationRequestRepository;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.cache.Cache;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;

@ExtendWith(value={MockitoExtension.class})
class StandardAuthorizationRequestRepositoryTest {
    private static final String AUTHORIZATION_REQUEST_URI = "http://localhost/authorize";
    private static final String CLIENT_ID = "client-id";
    private static final int MAX_AGE_EXPIRED = 0;
    @Captor
    ArgumentCaptor<String> identifierCaptor;
    @Mock
    Cache cache;
    MockHttpServletRequest httpServletRequest;
    MockHttpServletResponse httpServletResponse;
    StandardAuthorizationRequestRepository repository;

    StandardAuthorizationRequestRepositoryTest() {
    }

    @BeforeEach
    void setRepository() {
        this.repository = new StandardAuthorizationRequestRepository(this.cache);
        this.httpServletRequest = new MockHttpServletRequest();
        this.httpServletResponse = new MockHttpServletResponse();
    }

    @Test
    void testLoadAuthorizationRequestNotFound() {
        OAuth2AuthorizationRequest authorizationRequest = this.repository.loadAuthorizationRequest((HttpServletRequest)this.httpServletRequest);
        Assertions.assertNull((Object)authorizationRequest);
    }

    @Test
    void testLoadAuthorizationRequestFound() {
        String identifier = UUID.randomUUID().toString();
        this.httpServletRequest.setCookies(new Cookie[]{new Cookie(ApplicationCookieName.OIDC_REQUEST_IDENTIFIER.getCookieName(), identifier)});
        OAuth2AuthorizationRequest authorizationRequest = this.getAuthorizationRequest();
        Mockito.when((Object)((OAuth2AuthorizationRequest)this.cache.get(ArgumentMatchers.eq((Object)identifier), (Class)ArgumentMatchers.eq(OAuth2AuthorizationRequest.class)))).thenReturn((Object)authorizationRequest);
        OAuth2AuthorizationRequest loadedAuthorizationRequest = this.repository.loadAuthorizationRequest((HttpServletRequest)this.httpServletRequest);
        Assertions.assertEquals((Object)authorizationRequest, (Object)loadedAuthorizationRequest);
    }

    @Test
    void testRemoveAuthorizationRequestNotFound() {
        OAuth2AuthorizationRequest authorizationRequest = this.repository.removeAuthorizationRequest((HttpServletRequest)this.httpServletRequest);
        Assertions.assertNull((Object)authorizationRequest);
    }

    @Test
    void testRemoveAuthorizationRequestFound() {
        String identifier = UUID.randomUUID().toString();
        this.httpServletRequest.setCookies(new Cookie[]{new Cookie(ApplicationCookieName.OIDC_REQUEST_IDENTIFIER.getCookieName(), identifier)});
        OAuth2AuthorizationRequest authorizationRequest = this.getAuthorizationRequest();
        Mockito.when((Object)((OAuth2AuthorizationRequest)this.cache.get(ArgumentMatchers.eq((Object)identifier), (Class)ArgumentMatchers.eq(OAuth2AuthorizationRequest.class)))).thenReturn((Object)authorizationRequest);
        OAuth2AuthorizationRequest removedAuthorizationRequest = this.repository.removeAuthorizationRequest((HttpServletRequest)this.httpServletRequest, (HttpServletResponse)this.httpServletResponse);
        Assertions.assertEquals((Object)authorizationRequest, (Object)removedAuthorizationRequest);
        ((Cache)Mockito.verify((Object)this.cache)).evict(this.identifierCaptor.capture());
        String evictedIdentifier = (String)this.identifierCaptor.getValue();
        Assertions.assertEquals((Object)identifier, (Object)evictedIdentifier);
        Cookie cookie = this.httpServletResponse.getCookie(ApplicationCookieName.OIDC_REQUEST_IDENTIFIER.getCookieName());
        Assertions.assertNotNull((Object)cookie);
        Assertions.assertEquals((int)0, (int)cookie.getMaxAge());
    }

    @Test
    void testSaveAuthorizationRequest() {
        OAuth2AuthorizationRequest authorizationRequest = this.getAuthorizationRequest();
        this.repository.saveAuthorizationRequest(authorizationRequest, (HttpServletRequest)this.httpServletRequest, (HttpServletResponse)this.httpServletResponse);
        ((Cache)Mockito.verify((Object)this.cache)).put(this.identifierCaptor.capture(), ArgumentMatchers.eq((Object)authorizationRequest));
        String identifier = (String)this.identifierCaptor.getValue();
        this.assertCookieFound(identifier);
    }

    private void assertCookieFound(String identifier) {
        Cookie cookie = this.httpServletResponse.getCookie(ApplicationCookieName.OIDC_REQUEST_IDENTIFIER.getCookieName());
        Assertions.assertNotNull((Object)cookie);
        String cookieValue = cookie.getValue();
        Assertions.assertEquals((Object)identifier, (Object)cookieValue);
    }

    private OAuth2AuthorizationRequest getAuthorizationRequest() {
        return OAuth2AuthorizationRequest.authorizationCode().authorizationRequestUri(AUTHORIZATION_REQUEST_URI).authorizationUri(AUTHORIZATION_REQUEST_URI).clientId(CLIENT_ID).build();
    }
}

