/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.jwt.jws;

import java.time.Instant;
import java.util.UUID;
import org.apache.nifi.web.security.jwt.jws.JwsSignerContainer;
import org.apache.nifi.web.security.jwt.jws.SigningKeyListener;
import org.apache.nifi.web.security.jwt.jws.StandardJwsSignerProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class StandardJwsSignerProviderTest {
    private static final String KEY_IDENTIFIER = UUID.randomUUID().toString();
    @Mock
    private SigningKeyListener signingKeyListener;
    @Mock
    private JwsSignerContainer jwsSignerContainer;
    @Captor
    private ArgumentCaptor<String> keyIdentifierCaptor;
    @Captor
    private ArgumentCaptor<Instant> expirationCaptor;
    private StandardJwsSignerProvider provider;

    @BeforeEach
    public void setProvider() {
        this.provider = new StandardJwsSignerProvider(this.signingKeyListener);
        Mockito.when((Object)this.jwsSignerContainer.getKeyIdentifier()).thenReturn((Object)KEY_IDENTIFIER);
    }

    @Test
    public void testOnSignerUpdated() {
        this.provider.onSignerUpdated(this.jwsSignerContainer);
        Instant expiration = Instant.now();
        JwsSignerContainer container = this.provider.getJwsSignerContainer(expiration);
        Assertions.assertEquals((Object)this.jwsSignerContainer, (Object)container, (String)"JWS Signer Container not matched");
        ((SigningKeyListener)Mockito.verify((Object)this.signingKeyListener)).onSigningKeyUsed((String)this.keyIdentifierCaptor.capture(), (Instant)this.expirationCaptor.capture());
        Assertions.assertEquals((Object)KEY_IDENTIFIER, (Object)this.keyIdentifierCaptor.getValue());
        Assertions.assertEquals((Object)expiration, (Object)this.expirationCaptor.getValue());
    }
}

