/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.oidc.client.web;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.components.state.StateMap;
import org.apache.nifi.web.security.oidc.client.web.OidcAuthorizedClient;
import org.apache.nifi.web.security.oidc.client.web.TrackedAuthorizedClientRepository;
import org.apache.nifi.web.security.oidc.client.web.converter.AuthorizedClientConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.security.oauth2.core.oidc.OidcIdToken;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.security.oauth2.core.user.OAuth2User;

public class StandardOidcAuthorizedClientRepository
implements OAuth2AuthorizedClientRepository,
TrackedAuthorizedClientRepository {
    private static final Logger logger = LoggerFactory.getLogger(StandardOidcAuthorizedClientRepository.class);
    private static final Scope SCOPE = Scope.LOCAL;
    private final StateManager stateManager;
    private final AuthorizedClientConverter authorizedClientConverter;

    public StandardOidcAuthorizedClientRepository(StateManager stateManager, AuthorizedClientConverter authorizedClientConverter) {
        this.stateManager = Objects.requireNonNull(stateManager, "State Manager required");
        this.authorizedClientConverter = Objects.requireNonNull(authorizedClientConverter, "Authorized Client Converter required");
    }

    public <T extends OAuth2AuthorizedClient> T loadAuthorizedClient(String clientRegistrationId, Authentication principal, HttpServletRequest request) {
        OidcAuthorizedClient authorizedClient;
        String encoded = this.findEncoded(principal);
        String principalId = this.getPrincipalId(principal);
        if (encoded == null) {
            logger.debug("Identity [{}] OIDC Authorized Client not found", (Object)principalId);
            authorizedClient = null;
        } else {
            authorizedClient = this.authorizedClientConverter.getDecoded(encoded);
            if (authorizedClient == null) {
                logger.warn("Identity [{}] Removing OIDC Authorized Client after decoding failed", (Object)principalId);
                this.removeAuthorizedClient(principal);
            }
        }
        return (T)((Object)authorizedClient);
    }

    public void saveAuthorizedClient(OAuth2AuthorizedClient authorizedClient, Authentication principal, HttpServletRequest request, HttpServletResponse response) {
        OidcAuthorizedClient oidcAuthorizedClient = this.getOidcAuthorizedClient(authorizedClient, principal);
        String encoded = this.authorizedClientConverter.getEncoded(oidcAuthorizedClient);
        String principalId = this.getPrincipalId(principal);
        this.updateState(principalId, stateMap -> stateMap.put(principalId, encoded));
    }

    public void removeAuthorizedClient(String clientRegistrationId, Authentication principal, HttpServletRequest request, HttpServletResponse response) {
        this.removeAuthorizedClient(principal);
    }

    @Override
    public synchronized List<OidcAuthorizedClient> deleteExpired() {
        StateMap stateMap = this.getStateMap();
        Map currentStateMap = stateMap.toMap();
        LinkedHashMap<String, String> updatedStateMap = new LinkedHashMap<String, String>();
        ArrayList<OidcAuthorizedClient> deletedAuthorizedClients = new ArrayList<OidcAuthorizedClient>();
        for (Map.Entry encodedEntry : currentStateMap.entrySet()) {
            String identity = (String)encodedEntry.getKey();
            String encoded = (String)encodedEntry.getValue();
            try {
                OidcAuthorizedClient authorizedClient = this.authorizedClientConverter.getDecoded(encoded);
                if (this.isExpired(authorizedClient)) {
                    deletedAuthorizedClients.add(authorizedClient);
                    continue;
                }
                updatedStateMap.put(identity, encoded);
            }
            catch (Exception e) {
                logger.warn("Decoding OIDC Authorized Client [{}] failed", (Object)identity, (Object)e);
            }
        }
        this.setStateMap(updatedStateMap);
        if (deletedAuthorizedClients.isEmpty()) {
            logger.debug("Expired Authorized Clients not found");
        } else {
            logger.debug("Deleted Expired Authorized Clients: State before contained [{}] and after [{}]", (Object)currentStateMap.size(), (Object)updatedStateMap.size());
        }
        return deletedAuthorizedClients;
    }

    private boolean isExpired(OidcAuthorizedClient authorizedClient) {
        OAuth2AccessToken accessToken = authorizedClient.getAccessToken();
        Instant expiration = accessToken.getExpiresAt();
        return expiration == null || Instant.now().isAfter(expiration);
    }

    private void removeAuthorizedClient(Authentication principal) {
        String principalId = this.getPrincipalId(principal);
        this.updateState(principalId, stateMap -> stateMap.remove(principalId));
    }

    private OidcAuthorizedClient getOidcAuthorizedClient(OAuth2AuthorizedClient authorizedClient, Authentication authentication) {
        OidcIdToken oidcIdToken = this.getOidcIdToken(authentication);
        return new OidcAuthorizedClient(authorizedClient.getClientRegistration(), authorizedClient.getPrincipalName(), authorizedClient.getAccessToken(), authorizedClient.getRefreshToken(), oidcIdToken);
    }

    private OidcIdToken getOidcIdToken(Authentication authentication) {
        OAuth2User oAuth2User;
        if (authentication instanceof OAuth2AuthenticationToken) {
            OAuth2AuthenticationToken authenticationToken = (OAuth2AuthenticationToken)authentication;
            oAuth2User = authenticationToken.getPrincipal();
            if (!(oAuth2User instanceof OidcUser)) {
                String message = String.format("OpenID Connect User not found [%s]", oAuth2User.getClass());
                throw new IllegalArgumentException(message);
            }
        } else {
            String message = String.format("OpenID Connect Authentication Token not found [%s]", authentication.getClass());
            throw new IllegalArgumentException(message);
        }
        OidcUser oidcUser = (OidcUser)oAuth2User;
        OidcIdToken oidcIdToken = oidcUser.getIdToken();
        return oidcIdToken;
    }

    private String findEncoded(Authentication authentication) {
        String principalId = this.getPrincipalId(authentication);
        StateMap stateMap = this.getStateMap();
        return stateMap.get(principalId);
    }

    private String getPrincipalId(Authentication authentication) {
        return authentication.getName();
    }

    private synchronized void updateState(String principalId, Consumer<Map<String, String>> stateConsumer) {
        try {
            StateMap stateMap = this.getStateMap();
            LinkedHashMap updated = new LinkedHashMap(stateMap.toMap());
            stateConsumer.accept(updated);
            boolean completed = this.stateManager.replace(stateMap, updated, SCOPE);
            if (completed) {
                logger.info("Identity [{}] OIDC Authorized Client update completed", (Object)principalId);
            } else {
                logger.info("Identity [{}] OIDC Authorized Client update failed", (Object)principalId);
            }
        }
        catch (Exception e) {
            logger.warn("Identity [{}] OIDC Authorized Client update processing failed", (Object)principalId, (Object)e);
        }
    }

    private void setStateMap(Map<String, String> stateMap) {
        try {
            this.stateManager.setState(stateMap, SCOPE);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private StateMap getStateMap() {
        try {
            return this.stateManager.getState(SCOPE);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Get State for OIDC Authorized Clients failed", e);
        }
    }
}

