/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.token;

import java.time.Instant;
import java.util.Collection;
import org.apache.nifi.security.util.CertificateUtils;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.GrantedAuthority;

public class LoginAuthenticationToken
extends AbstractAuthenticationToken {
    private final String identity;
    private final String username;
    private final long expiration;
    private final String issuer;

    public LoginAuthenticationToken(String identity, long expiration, String issuer) {
        this(identity, null, expiration, issuer, null);
    }

    public LoginAuthenticationToken(String identity, String username, long expiration, String issuer) {
        this(identity, username, expiration, issuer, null);
    }

    public LoginAuthenticationToken(String identity, String username, long expiration, String issuer, Collection<? extends GrantedAuthority> authorities) {
        super(authorities);
        this.setAuthenticated(true);
        this.identity = identity;
        this.username = username;
        this.issuer = issuer;
        this.expiration = Instant.now().plusMillis(expiration).toEpochMilli();
    }

    public Object getCredentials() {
        return null;
    }

    public Object getPrincipal() {
        return this.identity;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getName() {
        if (this.username == null) {
            return CertificateUtils.extractUsername((String)this.identity);
        }
        return this.username;
    }

    public String toString() {
        Instant expirationTime = Instant.ofEpochMilli(this.expiration);
        long remainingTime = expirationTime.toEpochMilli() - Instant.now().toEpochMilli();
        return "LoginAuthenticationToken for " + this.getName() + " issued by " + this.getIssuer() + " expiring at " + expirationTime + " [" + this.getExpiration() + " ms, " + remainingTime + " ms remaining]";
    }
}

