/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.log;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.nifi.web.security.log.AuthenticationUserAttribute;
import org.apache.nifi.web.security.log.AuthenticationUserFilter;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextImpl;

@ExtendWith(value={MockitoExtension.class})
public class AuthenticationUserFilterTest {
    private static final String USERNAME = "User";
    @Mock
    private HttpServletRequest request;
    @Mock
    private HttpServletResponse response;
    @Mock
    private FilterChain filterChain;
    @Mock
    private Authentication authentication;
    @Captor
    private ArgumentCaptor<String> usernameCaptor;

    @Test
    public void testDoFilterInternalAuthenticationFound() throws ServletException, IOException {
        AuthenticationUserFilter filter = new AuthenticationUserFilter();
        Mockito.when((Object)this.authentication.getName()).thenReturn((Object)USERNAME);
        SecurityContextImpl securityContext = new SecurityContextImpl(this.authentication);
        SecurityContextHolder.setContext((SecurityContext)securityContext);
        filter.doFilterInternal(this.request, this.response, this.filterChain);
        ((HttpServletRequest)Mockito.verify((Object)this.request)).setAttribute((String)ArgumentMatchers.eq((Object)AuthenticationUserAttribute.USERNAME.getName()), this.usernameCaptor.capture());
        Assertions.assertEquals((Object)USERNAME, (Object)this.usernameCaptor.getValue());
    }

    @Test
    public void testDoFilterInternalAuthenticationNotFound() throws ServletException, IOException {
        AuthenticationUserFilter filter = new AuthenticationUserFilter();
        SecurityContextImpl securityContext = new SecurityContextImpl();
        SecurityContextHolder.setContext((SecurityContext)securityContext);
        filter.doFilterInternal(this.request, this.response, this.filterChain);
        ((HttpServletRequest)Mockito.verify((Object)this.request)).getRemoteAddr();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.request});
    }
}

