/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.cookie;

import java.net.URI;
import java.util.Optional;
import java.util.UUID;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.nifi.web.security.cookie.ApplicationCookieName;
import org.apache.nifi.web.security.cookie.StandardApplicationCookieService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.springframework.mock.web.MockCookie;

@RunWith(value=MockitoJUnitRunner.class)
public class StandardApplicationCookieServiceTest {
    private static final String DOMAIN = "localhost.localdomain";
    private static final String RESOURCE_URI = String.format("https://%s", "localhost.localdomain");
    private static final String ROOT_PATH = "/";
    private static final String CONTEXT_PATH = "/context";
    private static final String CONTEXT_RESOURCE_URI = String.format("https://%s%s", "localhost.localdomain", "/context");
    private static final int EXPECTED_MAX_AGE = 60;
    private static final int SESSION_MAX_AGE = -1;
    private static final int REMOVE_MAX_AGE = 0;
    private static final String SAME_SITE_STRICT = "SameSite=Strict";
    private static final String COOKIE_VALUE = UUID.randomUUID().toString();
    private static final ApplicationCookieName COOKIE_NAME = ApplicationCookieName.LOGOUT_REQUEST_IDENTIFIER;
    private URI resourceUri;
    private URI contextResourceUri;
    private StandardApplicationCookieService service;
    @Mock
    private HttpServletRequest request;
    @Mock
    private HttpServletResponse response;
    @Captor
    private ArgumentCaptor<String> cookieArgumentCaptor;

    @Before
    public void setService() {
        this.service = new StandardApplicationCookieService();
        this.resourceUri = URI.create(RESOURCE_URI);
        this.contextResourceUri = URI.create(CONTEXT_RESOURCE_URI);
    }

    @Test
    public void testAddCookie() {
        this.service.addCookie(this.resourceUri, this.response, COOKIE_NAME, COOKIE_VALUE);
        ((HttpServletResponse)Mockito.verify((Object)this.response)).addHeader((String)ArgumentMatchers.eq((Object)"Set-Cookie"), (String)this.cookieArgumentCaptor.capture());
        String setCookieHeader = (String)this.cookieArgumentCaptor.getValue();
        this.assertAddCookieMatches(setCookieHeader, ROOT_PATH, 60L);
    }

    @Test
    public void testAddCookieContextPath() {
        this.service.addCookie(this.contextResourceUri, this.response, COOKIE_NAME, COOKIE_VALUE);
        ((HttpServletResponse)Mockito.verify((Object)this.response)).addHeader((String)ArgumentMatchers.eq((Object)"Set-Cookie"), (String)this.cookieArgumentCaptor.capture());
        String setCookieHeader = (String)this.cookieArgumentCaptor.getValue();
        this.assertAddCookieMatches(setCookieHeader, CONTEXT_PATH, 60L);
    }

    @Test
    public void testAddSessionCookie() {
        this.service.addSessionCookie(this.resourceUri, this.response, COOKIE_NAME, COOKIE_VALUE);
        ((HttpServletResponse)Mockito.verify((Object)this.response)).addHeader((String)ArgumentMatchers.eq((Object)"Set-Cookie"), (String)this.cookieArgumentCaptor.capture());
        String setCookieHeader = (String)this.cookieArgumentCaptor.getValue();
        this.assertAddCookieMatches(setCookieHeader, ROOT_PATH, -1L);
        Assert.assertTrue((String)"SameSite not found", (boolean)setCookieHeader.endsWith(SAME_SITE_STRICT));
    }

    @Test
    public void testAddSessionCookieContextPath() {
        this.service.addSessionCookie(this.contextResourceUri, this.response, COOKIE_NAME, COOKIE_VALUE);
        ((HttpServletResponse)Mockito.verify((Object)this.response)).addHeader((String)ArgumentMatchers.eq((Object)"Set-Cookie"), (String)this.cookieArgumentCaptor.capture());
        String setCookieHeader = (String)this.cookieArgumentCaptor.getValue();
        this.assertAddCookieMatches(setCookieHeader, CONTEXT_PATH, -1L);
        Assert.assertTrue((String)"SameSite not found", (boolean)setCookieHeader.endsWith(SAME_SITE_STRICT));
    }

    @Test
    public void testGetCookieValue() {
        Cookie cookie = new Cookie(COOKIE_NAME.getCookieName(), COOKIE_VALUE);
        Mockito.when((Object)this.request.getCookies()).thenReturn((Object)new Cookie[]{cookie});
        Optional cookieValue = this.service.getCookieValue(this.request, COOKIE_NAME);
        Assert.assertTrue((boolean)cookieValue.isPresent());
        Assert.assertEquals((Object)COOKIE_VALUE, cookieValue.get());
    }

    @Test
    public void testGetCookieValueEmpty() {
        Optional cookieValue = this.service.getCookieValue(this.request, COOKIE_NAME);
        Assert.assertFalse((boolean)cookieValue.isPresent());
    }

    @Test
    public void testRemoveCookie() {
        this.service.removeCookie(this.resourceUri, this.response, COOKIE_NAME);
        ((HttpServletResponse)Mockito.verify((Object)this.response)).addHeader((String)ArgumentMatchers.eq((Object)"Set-Cookie"), (String)this.cookieArgumentCaptor.capture());
        String setCookieHeader = (String)this.cookieArgumentCaptor.getValue();
        this.assertRemoveCookieMatches(setCookieHeader, ROOT_PATH);
    }

    @Test
    public void testRemoveCookieContextPath() {
        this.service.removeCookie(this.contextResourceUri, this.response, COOKIE_NAME);
        ((HttpServletResponse)Mockito.verify((Object)this.response)).addHeader((String)ArgumentMatchers.eq((Object)"Set-Cookie"), (String)this.cookieArgumentCaptor.capture());
        String setCookieHeader = (String)this.cookieArgumentCaptor.getValue();
        this.assertRemoveCookieMatches(setCookieHeader, CONTEXT_PATH);
    }

    private void assertAddCookieMatches(String setCookieHeader, String path, long maxAge) {
        MockCookie cookie = MockCookie.parse((String)setCookieHeader);
        this.assertCookieMatches(setCookieHeader, (Cookie)cookie, path);
        Assert.assertEquals((Object)COOKIE_VALUE, (Object)cookie.getValue());
        Assert.assertEquals((long)maxAge, (long)cookie.getMaxAge());
    }

    private void assertRemoveCookieMatches(String setCookieHeader, String path) {
        MockCookie cookie = MockCookie.parse((String)setCookieHeader);
        this.assertCookieMatches(setCookieHeader, (Cookie)cookie, path);
        Assert.assertEquals((Object)"", (Object)cookie.getValue());
        Assert.assertEquals((long)0L, (long)cookie.getMaxAge());
    }

    private void assertCookieMatches(String setCookieHeader, Cookie cookie, String path) {
        Assert.assertEquals((String)"Cookie Name not matched", (Object)COOKIE_NAME.getCookieName(), (Object)cookie.getName());
        Assert.assertEquals((String)"Path not matched", (Object)path, (Object)cookie.getPath());
        Assert.assertEquals((String)"Domain not matched", (Object)DOMAIN, (Object)cookie.getDomain());
        Assert.assertTrue((String)"HTTP Only not matched", (boolean)cookie.isHttpOnly());
        Assert.assertTrue((String)"Secure not matched", (boolean)cookie.getSecure());
    }
}

