/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.jwt.converter;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.PlainJWT;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.apache.nifi.admin.service.IdpUserGroupService;
import org.apache.nifi.authorization.AccessPolicyProvider;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.Group;
import org.apache.nifi.authorization.ManagedAuthorizer;
import org.apache.nifi.authorization.UserAndGroups;
import org.apache.nifi.authorization.UserGroupProvider;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserDetails;
import org.apache.nifi.idp.IdpUserGroup;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.security.jwt.converter.StandardJwtAuthenticationConverter;
import org.apache.nifi.web.security.token.NiFiAuthenticationToken;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.springframework.security.oauth2.jwt.Jwt;

@RunWith(value=MockitoJUnitRunner.class)
public class StandardJwtAuthenticationConverterTest {
    private static final String USERNAME = "NiFi";
    private static final String AUTHORIZER_GROUP = "AuthorizerGroup";
    private static final String PROVIDER_GROUP = "ProviderGroup";
    private static final String TYPE_FIELD = "typ";
    private static final String JWT_TYPE = "JWT";
    @Mock
    private ManagedAuthorizer authorizer;
    @Mock
    private AccessPolicyProvider accessPolicyProvider;
    @Mock
    private UserGroupProvider userGroupProvider;
    @Mock
    private UserAndGroups userAndGroups;
    @Mock
    private IdpUserGroupService idpUserGroupService;
    private StandardJwtAuthenticationConverter converter;

    @Before
    public void setConverter() {
        HashMap properties = new HashMap();
        NiFiProperties niFiProperties = NiFiProperties.createBasicNiFiProperties((String)"", properties);
        this.converter = new StandardJwtAuthenticationConverter((Authorizer)this.authorizer, this.idpUserGroupService, niFiProperties);
        Mockito.when((Object)this.authorizer.getAccessPolicyProvider()).thenReturn((Object)this.accessPolicyProvider);
        Mockito.when((Object)this.accessPolicyProvider.getUserGroupProvider()).thenReturn((Object)this.userGroupProvider);
        Mockito.when((Object)this.userGroupProvider.getUserAndGroups((String)ArgumentMatchers.eq((Object)USERNAME))).thenReturn((Object)this.userAndGroups);
        Group group = new Group.Builder().name(AUTHORIZER_GROUP).identifier(AUTHORIZER_GROUP).build();
        Mockito.when((Object)this.userAndGroups.getGroups()).thenReturn(Collections.singleton(group));
        IdpUserGroup idpUserGroup = new IdpUserGroup();
        idpUserGroup.setGroupName(PROVIDER_GROUP);
        Mockito.when((Object)this.idpUserGroupService.getUserGroups((String)ArgumentMatchers.eq((Object)USERNAME))).thenReturn(Collections.singletonList(idpUserGroup));
    }

    @Test
    public void testConvert() {
        JWTClaimsSet claimsSet = new JWTClaimsSet.Builder().subject(USERNAME).build();
        String token = new PlainJWT(claimsSet).serialize();
        Jwt jwt = Jwt.withTokenValue((String)token).header(TYPE_FIELD, (Object)JWT_TYPE).subject(USERNAME).build();
        NiFiAuthenticationToken authenticationToken = this.converter.convert(jwt);
        Assert.assertNotNull((Object)authenticationToken);
        Assert.assertEquals((Object)USERNAME, (Object)authenticationToken.toString());
        NiFiUserDetails details = (NiFiUserDetails)authenticationToken.getDetails();
        NiFiUser user = details.getNiFiUser();
        Set<String> expectedGroups = Collections.singleton(AUTHORIZER_GROUP);
        Assert.assertEquals(expectedGroups, (Object)user.getGroups());
        Set<String> expectedProviderGroups = Collections.singleton(PROVIDER_GROUP);
        Assert.assertEquals(expectedProviderGroups, (Object)user.getIdentityProviderGroups());
    }
}

