/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.oidc;

import com.nimbusds.oauth2.sdk.Scope;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.security.oidc.StandardOidcIdentityProvider;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class StandardOidcIdentityProviderTest {
    @Test
    public void testValidateScopes() throws IllegalAccessException {
        String additionalScope_profile = "profile";
        String additionalScope_abc = "abc";
        StandardOidcIdentityProvider provider = this.createOidcProviderWithAdditionalScopes("profile", "abc");
        Scope scope = provider.getScope();
        Assert.assertEquals((long)scope.toArray().length, (long)4L);
        Assert.assertTrue((boolean)scope.contains("openid"));
        Assert.assertTrue((boolean)scope.contains("email"));
        Assert.assertTrue((boolean)scope.contains("profile"));
        Assert.assertTrue((boolean)scope.contains("abc"));
    }

    @Test
    public void testNoDuplicatedScopes() throws IllegalAccessException {
        String additionalScopeDuplicate = "abc";
        StandardOidcIdentityProvider provider = this.createOidcProviderWithAdditionalScopes("abc", "def", "abc");
        Scope scope = provider.getScope();
        Assert.assertEquals((long)scope.toArray().length, (long)4L);
    }

    private StandardOidcIdentityProvider createOidcProviderWithAdditionalScopes(String ... additionalScopes) throws IllegalAccessException {
        StandardOidcIdentityProvider provider = (StandardOidcIdentityProvider)Mockito.mock(StandardOidcIdentityProvider.class);
        NiFiProperties properties = this.createNiFiPropertiesMockWithAdditionalScopes(Arrays.asList(additionalScopes));
        Field propertiesField = FieldUtils.getDeclaredField(StandardOidcIdentityProvider.class, (String)"properties", (boolean)true);
        propertiesField.set(provider, properties);
        Mockito.when((Object)provider.isOidcEnabled()).thenReturn((Object)true);
        Mockito.when((Object)provider.getScope()).thenCallRealMethod();
        return provider;
    }

    private NiFiProperties createNiFiPropertiesMockWithAdditionalScopes(List<String> additionalScopes) {
        NiFiProperties properties = (NiFiProperties)Mockito.mock(NiFiProperties.class);
        Mockito.when((Object)properties.getOidcAdditionalScopes()).thenReturn(additionalScopes);
        return properties;
    }
}

