/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.jwt.provider;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPublicKey;
import java.text.ParseException;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.UUID;
import org.apache.nifi.web.security.jwt.jws.JwsSignerContainer;
import org.apache.nifi.web.security.jwt.jws.JwsSignerProvider;
import org.apache.nifi.web.security.jwt.provider.StandardBearerTokenProvider;
import org.apache.nifi.web.security.jwt.provider.SupportedClaim;
import org.apache.nifi.web.security.token.LoginAuthenticationToken;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class StandardBearerTokenProviderTest {
    private static final String USERNAME = "USERNAME";
    private static final String IDENTITY = "IDENTITY";
    private static final Duration EXPIRATION = Duration.ofHours(1L);
    private static final Duration MAXIMUM_DURATION_EXCEEDED = Duration.parse("PT12H5M");
    private static final Duration MINIMUM_DURATION_EXCEEDED = Duration.parse("PT30S");
    private static final String ISSUER = "ISSUER";
    private static final String KEY_ALGORITHM = "RSA";
    private static final int KEY_SIZE = 4096;
    private static final JWSAlgorithm JWS_ALGORITHM = JWSAlgorithm.PS512;
    @Mock
    private JwsSignerProvider jwsSignerProvider;
    private StandardBearerTokenProvider provider;
    private JWSVerifier jwsVerifier;
    private JWSSigner jwsSigner;

    @BeforeEach
    public void setProvider() throws NoSuchAlgorithmException {
        this.provider = new StandardBearerTokenProvider(this.jwsSignerProvider);
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(KEY_ALGORITHM);
        keyPairGenerator.initialize(4096);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        this.jwsVerifier = new RSASSAVerifier((RSAPublicKey)keyPair.getPublic());
        this.jwsSigner = new RSASSASigner(keyPair.getPrivate());
    }

    @Test
    public void testGetBearerToken() throws ParseException, JOSEException {
        LoginAuthenticationToken loginAuthenticationToken = new LoginAuthenticationToken(IDENTITY, USERNAME, EXPIRATION.toMillis(), ISSUER);
        this.setSignerProvider();
        String bearerToken = this.provider.getBearerToken(loginAuthenticationToken);
        SignedJWT signedJwt = this.assertTokenVerified(bearerToken);
        JWTClaimsSet claims = signedJwt.getJWTClaimsSet();
        Assertions.assertNotNull((Object)claims.getIssueTime(), (String)"Issue Time not found");
        Assertions.assertNotNull((Object)claims.getNotBeforeTime(), (String)"Not Before Time not found");
        Date claimExpirationTime = claims.getExpirationTime();
        Assertions.assertNotNull((Object)claimExpirationTime, (String)"Expiration Time not found");
        Date loginExpirationTime = new Date(loginAuthenticationToken.getExpiration());
        Assertions.assertEquals((Object)loginExpirationTime.toString(), (Object)claimExpirationTime.toString(), (String)"Expiration Time not matched");
        Assertions.assertEquals((Object)ISSUER, (Object)claims.getIssuer());
        Assertions.assertEquals(Collections.singletonList(ISSUER), (Object)claims.getAudience());
        Assertions.assertEquals((Object)IDENTITY, (Object)claims.getSubject());
        Assertions.assertEquals((Object)USERNAME, (Object)claims.getClaim(SupportedClaim.PREFERRED_USERNAME.getClaim()));
        Assertions.assertNotNull((Object)"JSON Web Token Identifier not found", (String)claims.getJWTID());
    }

    @Test
    public void testGetBearerTokenExpirationMaximum() throws ParseException, JOSEException {
        long expiration = MAXIMUM_DURATION_EXCEEDED.toMillis();
        LoginAuthenticationToken loginAuthenticationToken = new LoginAuthenticationToken(IDENTITY, USERNAME, expiration, ISSUER);
        this.setSignerProvider();
        String bearerToken = this.provider.getBearerToken(loginAuthenticationToken);
        SignedJWT signedJwt = this.assertTokenVerified(bearerToken);
        JWTClaimsSet claims = signedJwt.getJWTClaimsSet();
        Date claimExpirationTime = claims.getExpirationTime();
        Assertions.assertNotNull((Object)claimExpirationTime, (String)"Expiration Time not found");
        Date loginExpirationTime = new Date(loginAuthenticationToken.getExpiration());
        Assertions.assertNotSame((Object)loginExpirationTime.toString(), (Object)claimExpirationTime.toString(), (String)"Expiration Time matched");
        Assertions.assertTrue((boolean)claimExpirationTime.toInstant().isBefore(loginExpirationTime.toInstant()), (String)"Claim Expiration after Login Expiration");
    }

    @Test
    public void testGetBearerTokenExpirationMinimum() throws ParseException, JOSEException {
        long expiration = MINIMUM_DURATION_EXCEEDED.toMillis();
        LoginAuthenticationToken loginAuthenticationToken = new LoginAuthenticationToken(IDENTITY, USERNAME, expiration, ISSUER);
        this.setSignerProvider();
        String bearerToken = this.provider.getBearerToken(loginAuthenticationToken);
        SignedJWT signedJwt = this.assertTokenVerified(bearerToken);
        JWTClaimsSet claims = signedJwt.getJWTClaimsSet();
        Date claimExpirationTime = claims.getExpirationTime();
        Assertions.assertNotNull((Object)claimExpirationTime, (String)"Expiration Time not found");
        Date loginExpirationTime = new Date(loginAuthenticationToken.getExpiration());
        Assertions.assertNotSame((Object)loginExpirationTime.toString(), (Object)claimExpirationTime.toString(), (String)"Expiration Time matched");
        Assertions.assertTrue((boolean)claimExpirationTime.toInstant().isAfter(loginExpirationTime.toInstant()), (String)"Claim Expiration before Login Expiration");
    }

    private void setSignerProvider() {
        String keyIdentifier = UUID.randomUUID().toString();
        JwsSignerContainer jwsSignerContainer = new JwsSignerContainer(keyIdentifier, JWS_ALGORITHM, this.jwsSigner);
        Mockito.when((Object)this.jwsSignerProvider.getJwsSignerContainer((Instant)ArgumentMatchers.isA(Instant.class))).thenReturn((Object)jwsSignerContainer);
    }

    private SignedJWT assertTokenVerified(String bearerToken) throws ParseException, JOSEException {
        SignedJWT signedJwt = SignedJWT.parse((String)bearerToken);
        Assertions.assertTrue((boolean)signedJwt.verify(this.jwsVerifier), (String)"Verification Failed");
        return signedJwt;
    }
}

