/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.ref.SoftReference;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.web.security.ProxiedEntitiesUtils;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.powerassert.AssertionRenderer;
import org.codehaus.groovy.runtime.powerassert.ValueRecorder;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=JUnit4.class)
public class ProxiedEntitiesUtilsTest
implements GroovyObject {
    private static final Logger logger;
    private static final String SAFE_USER_NAME_ANDY = "alopresto";
    private static final String SAFE_USER_DN_ANDY;
    private static final String SAFE_USER_NAME_JOHN = "jdoe";
    private static final String SAFE_USER_DN_JOHN;
    private static final String SAFE_USER_NAME_PROXY_1 = "proxy1.nifi.apache.org";
    private static final String SAFE_USER_DN_PROXY_1;
    private static final String SAFE_USER_NAME_PROXY_2 = "proxy2.nifi.apache.org";
    private static final String SAFE_USER_DN_PROXY_2;
    private static final String MALICIOUS_USER_NAME_JOHN;
    private static final String MALICIOUS_USER_DN_JOHN;
    private static final String MALICIOUS_USER_NAME_JOHN_ESCAPED;
    private static final String MALICIOUS_USER_DN_JOHN_ESCAPED;
    private static final String UNICODE_DN_1 = "CN=\u0410\u043b\u0439\u0441, OU=Apache NiFi";
    private static final String UNICODE_DN_1_ENCODED;
    private static final String UNICODE_DN_2 = "CN=\u0411\u043e\u0431, OU=Apache NiFi";
    private static final String UNICODE_DN_2_ENCODED;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public ProxiedEntitiesUtilsTest() {
        MetaClass metaClass;
        CallSite[] callSiteArray = ProxiedEntitiesUtilsTest.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @BeforeClass
    public static void setUpOnce() throws Exception {
        CallSite[] callSiteArray = ProxiedEntitiesUtilsTest.$getCallSiteArray();
        public final class _setUpOnce_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _setUpOnce_closure1(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _setUpOnce_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(String name, Object args) {
                CallSite[] callSiteArray = _setUpOnce_closure1.$getCallSiteArray();
                return callSiteArray[0].call(ScriptBytecodeAdapter.getField(_setUpOnce_closure1.class, ProxiedEntitiesUtilsTest.class, (String)"logger"), (Object)new GStringImpl(new Object[]{callSiteArray[1].callSafe((Object)name), callSiteArray[2].call((Object)((List)ScriptBytecodeAdapter.asType((Object)args, List.class)), (Object)" ")}, new String[]{"[", "] ", ""}));
            }

            @Generated
            public Object call(String name, Object args) {
                CallSite[] callSiteArray = _setUpOnce_closure1.$getCallSiteArray();
                return callSiteArray[3].callCurrent((GroovyObject)this, (Object)name, args);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _setUpOnce_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "info";
                stringArray[1] = "toUpperCase";
                stringArray[2] = "join";
                stringArray[3] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _setUpOnce_closure1.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_setUpOnce_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _setUpOnce_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        _setUpOnce_closure1 _setUpOnce_closure12 = new _setUpOnce_closure1(ProxiedEntitiesUtilsTest.class, ProxiedEntitiesUtilsTest.class);
        ScriptBytecodeAdapter.setProperty((Object)((Object)_setUpOnce_closure12), null, (Object)callSiteArray[0].callGetProperty((Object)logger), (String)"methodMissing");
    }

    @Before
    public void setUp() {
        CallSite[] callSiteArray = ProxiedEntitiesUtilsTest.$getCallSiteArray();
    }

    @After
    public void tearDown() {
        CallSite[] callSiteArray = ProxiedEntitiesUtilsTest.$getCallSiteArray();
    }

    private static String sanitizeDn(String dn) {
        CallSite[] callSiteArray = ProxiedEntitiesUtilsTest.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[1].call(callSiteArray[2].call((Object)dn, (Object)">", (Object)"\\\\>"), (Object)"<", (Object)"\\\\<"));
    }

    private static String base64Encode(String dn) {
        CallSite[] callSiteArray = ProxiedEntitiesUtilsTest.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[3].call(callSiteArray[4].call(Base64.class), callSiteArray[5].call((Object)dn, callSiteArray[6].callGetProperty(StandardCharsets.class))));
    }

    private static String printUnicodeString(String raw) {
        CallSite[] callSiteArray = ProxiedEntitiesUtilsTest.$getCallSiteArray();
        StringBuilder sb = (StringBuilder)ScriptBytecodeAdapter.castToType((Object)callSiteArray[7].callConstructor(StringBuilder.class), StringBuilder.class);
        if (!BytecodeInterface8.isOrigInt() || !BytecodeInterface8.isOrigZ() || __$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            int i = 0;
            while (ScriptBytecodeAdapter.compareLessThan((Object)i, (Object)callSiteArray[8].call((Object)raw))) {
                int codePoint = DefaultTypeTransformation.intUnbox((Object)callSiteArray[9].call(Character.class, (Object)raw, (Object)i));
                int charCount = DefaultTypeTransformation.intUnbox((Object)callSiteArray[10].call(Character.class, (Object)codePoint));
                if (charCount > 1) {
                    i = DefaultTypeTransformation.intUnbox((Object)callSiteArray[11].call((Object)i, callSiteArray[12].call((Object)charCount, (Object)1)));
                    if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)i, (Object)callSiteArray[13].call((Object)raw))) {
                        throw (Throwable)callSiteArray[14].callConstructor(IllegalArgumentException.class, (Object)"Code point indicated more characters than available");
                    }
                }
                callSiteArray[15].call((Object)sb, callSiteArray[16].call(String.class, (Object)"\\u%04x ", (Object)codePoint));
                int n = i;
                i = DefaultTypeTransformation.intUnbox((Object)callSiteArray[17].call((Object)n));
            }
        } else {
            int i = 0;
            while (ScriptBytecodeAdapter.compareLessThan((Object)i, (Object)callSiteArray[18].call((Object)raw))) {
                int codePoint = DefaultTypeTransformation.intUnbox((Object)callSiteArray[19].call(Character.class, (Object)raw, (Object)i));
                int charCount = DefaultTypeTransformation.intUnbox((Object)callSiteArray[20].call(Character.class, (Object)codePoint));
                if (charCount > 1) {
                    i = i + (charCount - 1);
                    if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)i, (Object)callSiteArray[21].call((Object)raw))) {
                        throw (Throwable)callSiteArray[22].callConstructor(IllegalArgumentException.class, (Object)"Code point indicated more characters than available");
                    }
                }
                callSiteArray[23].call((Object)sb, callSiteArray[24].call(String.class, (Object)"\\u%04x ", (Object)codePoint));
                int n = i;
                int cfr_ignored_0 = n + 1;
            }
        }
        return ShortTypeHandling.castToString((Object)callSiteArray[25].call(callSiteArray[26].call((Object)sb)));
    }

    @Test
    public void testSanitizeDnShouldHandleFuzzing() throws Exception {
        CallSite[] callSiteArray = ProxiedEntitiesUtilsTest.$getCallSiteArray();
        Reference DESIRED_NAME = new Reference((Object)SAFE_USER_NAME_JOHN);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[27].call((Object)logger, (Object)new GStringImpl(new Object[]{(String)DESIRED_NAME.get(), callSiteArray[28].callStatic(ProxiedEntitiesUtilsTest.class, (Object)((String)DESIRED_NAME.get()))}, new String[]{"  Desired name: ", " |  ", ""}));
        } else {
            callSiteArray[29].call((Object)logger, (Object)new GStringImpl(new Object[]{(String)DESIRED_NAME.get(), ProxiedEntitiesUtilsTest.printUnicodeString((String)DESIRED_NAME.get())}, new String[]{"  Desired name: ", " |  ", ""}));
        }
        List MALICIOUS_NAMES = ScriptBytecodeAdapter.createList((Object[])new Object[]{MALICIOUS_USER_NAME_JOHN, callSiteArray[30].call((Object)SAFE_USER_NAME_JOHN, (Object)">"), callSiteArray[31].call((Object)SAFE_USER_NAME_JOHN, (Object)"><>"), callSiteArray[32].call((Object)SAFE_USER_NAME_JOHN, (Object)"\\>"), callSiteArray[33].call((Object)SAFE_USER_NAME_JOHN, (Object)">"), callSiteArray[34].call((Object)SAFE_USER_NAME_JOHN, (Object)"\\>"), callSiteArray[35].call((Object)SAFE_USER_NAME_JOHN, (Object)"\u0000"), callSiteArray[36].call((Object)SAFE_USER_NAME_JOHN, (Object)"\bn")});
        public final class _testSanitizeDnShouldHandleFuzzing_closure2
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference DESIRED_NAME;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _testSanitizeDnShouldHandleFuzzing_closure2(Object _outerInstance, Object _thisObject, Reference DESIRED_NAME) {
                Reference reference;
                CallSite[] callSiteArray = _testSanitizeDnShouldHandleFuzzing_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.DESIRED_NAME = reference = DESIRED_NAME;
            }

            public Object doCall(String name) {
                CallSite[] callSiteArray = _testSanitizeDnShouldHandleFuzzing_closure2.$getCallSiteArray();
                callSiteArray[0].call(ScriptBytecodeAdapter.getField(_testSanitizeDnShouldHandleFuzzing_closure2.class, ProxiedEntitiesUtilsTest.class, (String)"logger"), (Object)new GStringImpl(new Object[]{name, callSiteArray[1].callCurrent((GroovyObject)this, (Object)name)}, new String[]{"      Raw name: ", " | ", ""}));
                String sanitizedName = ShortTypeHandling.castToString((Object)callSiteArray[2].call(ProxiedEntitiesUtils.class, (Object)name));
                callSiteArray[3].call(ScriptBytecodeAdapter.getField(_testSanitizeDnShouldHandleFuzzing_closure2.class, ProxiedEntitiesUtilsTest.class, (String)"logger"), (Object)new GStringImpl(new Object[]{sanitizedName, callSiteArray[4].callCurrent((GroovyObject)this, (Object)sanitizedName)}, new String[]{"Sanitized name: ", " | ", ""}));
                ValueRecorder valueRecorder = new ValueRecorder();
                try {
                    String string = sanitizedName;
                    valueRecorder.record((Object)string, 8);
                    Object object = this.DESIRED_NAME.get();
                    valueRecorder.record(object, 25);
                    valueRecorder.record(object, 25);
                    boolean bl = ScriptBytecodeAdapter.compareNotEqual((Object)string, (Object)object);
                    valueRecorder.record((Object)bl, 22);
                    if (bl) {
                        valueRecorder.clear();
                    } else {
                        ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert sanitizedName != DESIRED_NAME", (ValueRecorder)valueRecorder), null);
                    }
                }
                catch (Throwable throwable) {
                    valueRecorder.clear();
                    throw throwable;
                }
                return null;
            }

            @Generated
            public Object call(String name) {
                CallSite[] callSiteArray = _testSanitizeDnShouldHandleFuzzing_closure2.$getCallSiteArray();
                if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
                    return callSiteArray[5].callCurrent((GroovyObject)this, (Object)name);
                }
                return this.doCall(name);
            }

            @Generated
            public String getDESIRED_NAME() {
                CallSite[] callSiteArray = _testSanitizeDnShouldHandleFuzzing_closure2.$getCallSiteArray();
                return ShortTypeHandling.castToString((Object)this.DESIRED_NAME.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testSanitizeDnShouldHandleFuzzing_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "info";
                stringArray[1] = "printUnicodeString";
                stringArray[2] = "sanitizeDn";
                stringArray[3] = "info";
                stringArray[4] = "printUnicodeString";
                stringArray[5] = "doCall";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[6];
                _testSanitizeDnShouldHandleFuzzing_closure2.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_testSanitizeDnShouldHandleFuzzing_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testSanitizeDnShouldHandleFuzzing_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[37].call((Object)MALICIOUS_NAMES, (Object)new _testSanitizeDnShouldHandleFuzzing_closure2(this, this, DESIRED_NAME));
    }

    @Test
    public void testShouldFormatProxyDn() throws Exception {
        CallSite[] callSiteArray = ProxiedEntitiesUtilsTest.$getCallSiteArray();
        String DN = SAFE_USER_DN_JOHN;
        callSiteArray[38].call((Object)logger, (Object)new GStringImpl(new Object[]{DN}, new String[]{" Provided proxy DN: ", ""}));
        String EXPECTED_PROXY_DN = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{DN}, new String[]{"<", ">"}));
        callSiteArray[39].call((Object)logger, (Object)new GStringImpl(new Object[]{EXPECTED_PROXY_DN}, new String[]{" Expected proxy DN: ", ""}));
        String forjohnedProxyDn = ShortTypeHandling.castToString((Object)callSiteArray[40].call(ProxiedEntitiesUtils.class, (Object)DN));
        callSiteArray[41].call((Object)logger, (Object)new GStringImpl(new Object[]{forjohnedProxyDn}, new String[]{"Forjohned proxy DN: ", ""}));
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            String string = forjohnedProxyDn;
            valueRecorder.record((Object)string, 8);
            String string2 = EXPECTED_PROXY_DN;
            valueRecorder.record((Object)string2, 28);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)string, (Object)string2);
            valueRecorder.record((Object)bl, 25);
            if (bl) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert forjohnedProxyDn == EXPECTED_PROXY_DN", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
    }

    @Test
    public void testFormatProxyDnShouldHandleMaliciousInput() throws Exception {
        CallSite[] callSiteArray = ProxiedEntitiesUtilsTest.$getCallSiteArray();
        String DN = MALICIOUS_USER_DN_JOHN;
        callSiteArray[42].call((Object)logger, (Object)new GStringImpl(new Object[]{DN}, new String[]{" Provided proxy DN: ", ""}));
        String SANITIZED_DN = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object = callSiteArray[43].callStatic(ProxiedEntitiesUtilsTest.class, (Object)DN);
            SANITIZED_DN = ShortTypeHandling.castToString((Object)object);
        } else {
            String string;
            SANITIZED_DN = string = ProxiedEntitiesUtilsTest.sanitizeDn(DN);
        }
        String EXPECTED_PROXY_DN = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{SANITIZED_DN}, new String[]{"<", ">"}));
        callSiteArray[44].call((Object)logger, (Object)new GStringImpl(new Object[]{EXPECTED_PROXY_DN}, new String[]{" Expected proxy DN: ", ""}));
        String forjohnedProxyDn = ShortTypeHandling.castToString((Object)callSiteArray[45].call(ProxiedEntitiesUtils.class, (Object)DN));
        callSiteArray[46].call((Object)logger, (Object)new GStringImpl(new Object[]{forjohnedProxyDn}, new String[]{"Forjohned proxy DN: ", ""}));
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            String string = forjohnedProxyDn;
            valueRecorder.record((Object)string, 8);
            String string2 = EXPECTED_PROXY_DN;
            valueRecorder.record((Object)string2, 28);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)string, (Object)string2);
            valueRecorder.record((Object)bl, 25);
            if (bl) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert forjohnedProxyDn == EXPECTED_PROXY_DN", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
    }

    @Test
    public void testGetProxiedEntitiesChain() throws Exception {
        CallSite[] callSiteArray = ProxiedEntitiesUtilsTest.$getCallSiteArray();
        String[] input = new String[]{SAFE_USER_NAME_JOHN, SAFE_USER_DN_PROXY_1, SAFE_USER_DN_PROXY_2};
        String expectedOutput = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{SAFE_USER_NAME_JOHN, SAFE_USER_DN_PROXY_1, SAFE_USER_DN_PROXY_2}, new String[]{"<", "><", "><", ">"}));
        Object output = callSiteArray[47].call(ProxiedEntitiesUtils.class, (Object)input);
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            Object object = output;
            valueRecorder.record(object, 8);
            String string = expectedOutput;
            valueRecorder.record((Object)string, 18);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)object, (Object)string);
            valueRecorder.record((Object)bl, 15);
            if (bl) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert output == expectedOutput", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
    }

    @Test
    public void testGetProxiedEntitiesChainShouldHandleMaliciousInput() throws Exception {
        CallSite[] callSiteArray = ProxiedEntitiesUtilsTest.$getCallSiteArray();
        String[] input = new String[]{MALICIOUS_USER_DN_JOHN, SAFE_USER_DN_PROXY_1, SAFE_USER_DN_PROXY_2};
        String expectedOutput = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            GStringImpl gStringImpl = new GStringImpl(new Object[]{callSiteArray[48].callStatic(ProxiedEntitiesUtilsTest.class, (Object)MALICIOUS_USER_DN_JOHN), SAFE_USER_DN_PROXY_1, SAFE_USER_DN_PROXY_2}, new String[]{"<", "><", "><", ">"});
            expectedOutput = ShortTypeHandling.castToString((Object)gStringImpl);
        } else {
            GStringImpl gStringImpl = new GStringImpl(new Object[]{ProxiedEntitiesUtilsTest.sanitizeDn(MALICIOUS_USER_DN_JOHN), SAFE_USER_DN_PROXY_1, SAFE_USER_DN_PROXY_2}, new String[]{"<", "><", "><", ">"});
            expectedOutput = ShortTypeHandling.castToString((Object)gStringImpl);
        }
        Object output = callSiteArray[49].call(ProxiedEntitiesUtils.class, (Object)input);
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            Object object = output;
            valueRecorder.record(object, 8);
            String string = expectedOutput;
            valueRecorder.record((Object)string, 18);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)object, (Object)string);
            valueRecorder.record((Object)bl, 15);
            if (bl) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert output == expectedOutput", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
    }

    @Test
    public void testGetProxiedEntitiesChainShouldEncodeUnicode() throws Exception {
        CallSite[] callSiteArray = ProxiedEntitiesUtilsTest.$getCallSiteArray();
        String[] input = new String[]{SAFE_USER_NAME_JOHN, UNICODE_DN_1, UNICODE_DN_2};
        String expectedOutput = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{SAFE_USER_NAME_JOHN, UNICODE_DN_1_ENCODED, UNICODE_DN_2_ENCODED}, new String[]{"<", "><", "><", ">"}));
        Object output = callSiteArray[50].call(ProxiedEntitiesUtils.class, (Object)input);
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            Object object = output;
            valueRecorder.record(object, 8);
            String string = expectedOutput;
            valueRecorder.record((Object)string, 18);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)object, (Object)string);
            valueRecorder.record((Object)bl, 15);
            if (bl) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert output == expectedOutput", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
    }

    @Test
    public void testFormatProxyDnShouldEncodeNonAsciiCharacters() throws Exception {
        CallSite[] callSiteArray = ProxiedEntitiesUtilsTest.$getCallSiteArray();
        callSiteArray[51].call((Object)logger, (Object)new GStringImpl(new Object[]{UNICODE_DN_1}, new String[]{" Provided DN: ", ""}));
        String expectedFormattedDn = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{UNICODE_DN_1_ENCODED}, new String[]{"<", ">"}));
        callSiteArray[52].call((Object)logger, (Object)" Expected DN: expected");
        String formattedDn = ShortTypeHandling.castToString((Object)callSiteArray[53].call(ProxiedEntitiesUtils.class, (Object)UNICODE_DN_1));
        callSiteArray[54].call((Object)logger, (Object)new GStringImpl(new Object[]{formattedDn}, new String[]{"Formatted DN: ", ""}));
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            String string = formattedDn;
            valueRecorder.record((Object)string, 8);
            String string2 = expectedFormattedDn;
            valueRecorder.record((Object)string2, 23);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)string, (Object)string2);
            valueRecorder.record((Object)bl, 20);
            if (bl) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert formattedDn == expectedFormattedDn", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
    }

    @Test
    public void testShouldBuildProxyChain() throws Exception {
        CallSite[] callSiteArray = ProxiedEntitiesUtilsTest.$getCallSiteArray();
        public final class _testShouldBuildProxyChain_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _testShouldBuildProxyChain_closure3(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _testShouldBuildProxyChain_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _testShouldBuildProxyChain_closure3.$getCallSiteArray();
                return ScriptBytecodeAdapter.getField(_testShouldBuildProxyChain_closure3.class, ProxiedEntitiesUtilsTest.class, (String)"SAFE_USER_NAME_PROXY_1");
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testShouldBuildProxyChain_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_testShouldBuildProxyChain_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testShouldBuildProxyChain_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public final class _testShouldBuildProxyChain_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _testShouldBuildProxyChain_closure4(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _testShouldBuildProxyChain_closure4.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _testShouldBuildProxyChain_closure4.$getCallSiteArray();
                return null;
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testShouldBuildProxyChain_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_testShouldBuildProxyChain_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testShouldBuildProxyChain_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public final class _testShouldBuildProxyChain_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _testShouldBuildProxyChain_closure5(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _testShouldBuildProxyChain_closure5.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _testShouldBuildProxyChain_closure5.$getCallSiteArray();
                return false;
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testShouldBuildProxyChain_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_testShouldBuildProxyChain_closure5.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testShouldBuildProxyChain_closure5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Reference mockProxy1 = new Reference((Object)((NiFiUser)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"getIdentity", new _testShouldBuildProxyChain_closure3(this, this), "getChain", new _testShouldBuildProxyChain_closure4(this, this), "isAnonymous", new _testShouldBuildProxyChain_closure5(this, this)}), NiFiUser.class)));
        public final class _testShouldBuildProxyChain_closure6
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _testShouldBuildProxyChain_closure6(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _testShouldBuildProxyChain_closure6.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _testShouldBuildProxyChain_closure6.$getCallSiteArray();
                return ScriptBytecodeAdapter.getField(_testShouldBuildProxyChain_closure6.class, ProxiedEntitiesUtilsTest.class, (String)"SAFE_USER_NAME_JOHN");
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testShouldBuildProxyChain_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_testShouldBuildProxyChain_closure6.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testShouldBuildProxyChain_closure6.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public final class _testShouldBuildProxyChain_closure7
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference mockProxy1;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _testShouldBuildProxyChain_closure7(Object _outerInstance, Object _thisObject, Reference mockProxy1) {
                Reference reference;
                CallSite[] callSiteArray = _testShouldBuildProxyChain_closure7.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.mockProxy1 = reference = mockProxy1;
            }

            public Object doCall() {
                CallSite[] callSiteArray = _testShouldBuildProxyChain_closure7.$getCallSiteArray();
                return this.mockProxy1.get();
            }

            @Generated
            public Object getMockProxy1() {
                CallSite[] callSiteArray = _testShouldBuildProxyChain_closure7.$getCallSiteArray();
                return this.mockProxy1.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testShouldBuildProxyChain_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_testShouldBuildProxyChain_closure7.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testShouldBuildProxyChain_closure7.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public final class _testShouldBuildProxyChain_closure8
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _testShouldBuildProxyChain_closure8(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _testShouldBuildProxyChain_closure8.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _testShouldBuildProxyChain_closure8.$getCallSiteArray();
                return false;
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testShouldBuildProxyChain_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_testShouldBuildProxyChain_closure8.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testShouldBuildProxyChain_closure8.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        NiFiUser mockJohn = (NiFiUser)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"getIdentity", new _testShouldBuildProxyChain_closure6(this, this), "getChain", new _testShouldBuildProxyChain_closure7(this, this, mockProxy1), "isAnonymous", new _testShouldBuildProxyChain_closure8(this, this)}), NiFiUser.class);
        String proxiedEntitiesChain = ShortTypeHandling.castToString((Object)callSiteArray[55].call(ProxiedEntitiesUtils.class, (Object)mockJohn));
        callSiteArray[56].call((Object)logger, (Object)new GStringImpl(new Object[]{proxiedEntitiesChain}, new String[]{"Proxied entities chain: ", ""}));
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            String string = proxiedEntitiesChain;
            valueRecorder.record((Object)string, 8);
            Object[] objectArray = new Object[2];
            String string2 = SAFE_USER_NAME_JOHN;
            valueRecorder.record((Object)string2, 36);
            valueRecorder.record((Object)string2, 36);
            objectArray[0] = string2;
            String string3 = SAFE_USER_NAME_PROXY_1;
            valueRecorder.record((Object)string3, 60);
            valueRecorder.record((Object)string3, 60);
            objectArray[1] = string3;
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)string, (Object)((String)ScriptBytecodeAdapter.asType((Object)new GStringImpl(objectArray, new String[]{"<", "><", ">"}), String.class)));
            valueRecorder.record((Object)bl, 29);
            if (bl) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert proxiedEntitiesChain == \"<${SAFE_USER_NAME_JOHN}><${SAFE_USER_NAME_PROXY_1}>\" as String", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
    }

    @Test
    public void testBuildProxyChainFromNullUserShouldBeAnonymous() throws Exception {
        CallSite[] callSiteArray = ProxiedEntitiesUtilsTest.$getCallSiteArray();
        String proxiedEntitiesChain = ShortTypeHandling.castToString((Object)callSiteArray[57].call(ProxiedEntitiesUtils.class, null));
        callSiteArray[58].call((Object)logger, (Object)new GStringImpl(new Object[]{proxiedEntitiesChain}, new String[]{"Proxied entities chain: ", ""}));
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            String string = proxiedEntitiesChain;
            valueRecorder.record((Object)string, 8);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)string, (Object)"<>");
            valueRecorder.record((Object)bl, 29);
            if (bl) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert proxiedEntitiesChain == \"<>\"", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
    }

    @Test
    public void testBuildProxyChainFromAnonymousUserShouldBeAnonymous() throws Exception {
        CallSite[] callSiteArray = ProxiedEntitiesUtilsTest.$getCallSiteArray();
        public final class _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure9
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure9(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure9.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure9.$getCallSiteArray();
                return ScriptBytecodeAdapter.getField(_testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure9.class, ProxiedEntitiesUtilsTest.class, (String)"SAFE_USER_NAME_PROXY_1");
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure9.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure9.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure9.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public final class _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure10
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure10(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure10.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure10.$getCallSiteArray();
                return null;
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure10.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure10.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure10.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public final class _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure11
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure11(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure11.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure11.$getCallSiteArray();
                return false;
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure11.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure11.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure11.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Reference mockProxy1 = new Reference((Object)((NiFiUser)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"getIdentity", new _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure9(this, this), "getChain", new _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure10(this, this), "isAnonymous", new _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure11(this, this)}), NiFiUser.class)));
        public final class _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure12
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure12(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure12.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure12.$getCallSiteArray();
                return "anonymous";
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure12.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure12.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure12.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public final class _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure13
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference mockProxy1;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure13(Object _outerInstance, Object _thisObject, Reference mockProxy1) {
                Reference reference;
                CallSite[] callSiteArray = _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure13.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.mockProxy1 = reference = mockProxy1;
            }

            public Object doCall() {
                CallSite[] callSiteArray = _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure13.$getCallSiteArray();
                return this.mockProxy1.get();
            }

            @Generated
            public Object getMockProxy1() {
                CallSite[] callSiteArray = _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure13.$getCallSiteArray();
                return this.mockProxy1.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure13.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure13.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure13.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public final class _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure14
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure14(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure14.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure14.$getCallSiteArray();
                return true;
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure14.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure14.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure14.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        NiFiUser mockAnonymous = (NiFiUser)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"getIdentity", new _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure12(this, this), "getChain", new _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure13(this, this, mockProxy1), "isAnonymous", new _testBuildProxyChainFromAnonymousUserShouldBeAnonymous_closure14(this, this)}), NiFiUser.class);
        String proxiedEntitiesChain = ShortTypeHandling.castToString((Object)callSiteArray[59].call(ProxiedEntitiesUtils.class, (Object)mockAnonymous));
        callSiteArray[60].call((Object)logger, (Object)new GStringImpl(new Object[]{proxiedEntitiesChain}, new String[]{"Proxied entities chain: ", ""}));
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            String string = proxiedEntitiesChain;
            valueRecorder.record((Object)string, 8);
            Object[] objectArray = new Object[1];
            String string2 = SAFE_USER_NAME_PROXY_1;
            valueRecorder.record((Object)string2, 38);
            valueRecorder.record((Object)string2, 38);
            objectArray[0] = string2;
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)string, (Object)((String)ScriptBytecodeAdapter.asType((Object)new GStringImpl(objectArray, new String[]{"<><", ">"}), String.class)));
            valueRecorder.record((Object)bl, 29);
            if (bl) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert proxiedEntitiesChain == \"<><${SAFE_USER_NAME_PROXY_1}>\" as String", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
    }

    @Test
    public void testBuildProxyChainShouldHandleUnicode() throws Exception {
        CallSite[] callSiteArray = ProxiedEntitiesUtilsTest.$getCallSiteArray();
        public final class _testBuildProxyChainShouldHandleUnicode_closure15
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _testBuildProxyChainShouldHandleUnicode_closure15(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _testBuildProxyChainShouldHandleUnicode_closure15.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _testBuildProxyChainShouldHandleUnicode_closure15.$getCallSiteArray();
                return ScriptBytecodeAdapter.getField(_testBuildProxyChainShouldHandleUnicode_closure15.class, ProxiedEntitiesUtilsTest.class, (String)"UNICODE_DN_1");
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testBuildProxyChainShouldHandleUnicode_closure15.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_testBuildProxyChainShouldHandleUnicode_closure15.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testBuildProxyChainShouldHandleUnicode_closure15.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public final class _testBuildProxyChainShouldHandleUnicode_closure16
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _testBuildProxyChainShouldHandleUnicode_closure16(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _testBuildProxyChainShouldHandleUnicode_closure16.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _testBuildProxyChainShouldHandleUnicode_closure16.$getCallSiteArray();
                return null;
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testBuildProxyChainShouldHandleUnicode_closure16.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_testBuildProxyChainShouldHandleUnicode_closure16.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testBuildProxyChainShouldHandleUnicode_closure16.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public final class _testBuildProxyChainShouldHandleUnicode_closure17
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _testBuildProxyChainShouldHandleUnicode_closure17(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _testBuildProxyChainShouldHandleUnicode_closure17.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _testBuildProxyChainShouldHandleUnicode_closure17.$getCallSiteArray();
                return false;
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testBuildProxyChainShouldHandleUnicode_closure17.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_testBuildProxyChainShouldHandleUnicode_closure17.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testBuildProxyChainShouldHandleUnicode_closure17.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Reference mockProxy1 = new Reference((Object)((NiFiUser)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"getIdentity", new _testBuildProxyChainShouldHandleUnicode_closure15(this, this), "getChain", new _testBuildProxyChainShouldHandleUnicode_closure16(this, this), "isAnonymous", new _testBuildProxyChainShouldHandleUnicode_closure17(this, this)}), NiFiUser.class)));
        public final class _testBuildProxyChainShouldHandleUnicode_closure18
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _testBuildProxyChainShouldHandleUnicode_closure18(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _testBuildProxyChainShouldHandleUnicode_closure18.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _testBuildProxyChainShouldHandleUnicode_closure18.$getCallSiteArray();
                return ScriptBytecodeAdapter.getField(_testBuildProxyChainShouldHandleUnicode_closure18.class, ProxiedEntitiesUtilsTest.class, (String)"SAFE_USER_NAME_JOHN");
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testBuildProxyChainShouldHandleUnicode_closure18.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_testBuildProxyChainShouldHandleUnicode_closure18.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testBuildProxyChainShouldHandleUnicode_closure18.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public final class _testBuildProxyChainShouldHandleUnicode_closure19
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference mockProxy1;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _testBuildProxyChainShouldHandleUnicode_closure19(Object _outerInstance, Object _thisObject, Reference mockProxy1) {
                Reference reference;
                CallSite[] callSiteArray = _testBuildProxyChainShouldHandleUnicode_closure19.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.mockProxy1 = reference = mockProxy1;
            }

            public Object doCall() {
                CallSite[] callSiteArray = _testBuildProxyChainShouldHandleUnicode_closure19.$getCallSiteArray();
                return this.mockProxy1.get();
            }

            @Generated
            public Object getMockProxy1() {
                CallSite[] callSiteArray = _testBuildProxyChainShouldHandleUnicode_closure19.$getCallSiteArray();
                return this.mockProxy1.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testBuildProxyChainShouldHandleUnicode_closure19.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_testBuildProxyChainShouldHandleUnicode_closure19.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testBuildProxyChainShouldHandleUnicode_closure19.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public final class _testBuildProxyChainShouldHandleUnicode_closure20
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _testBuildProxyChainShouldHandleUnicode_closure20(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _testBuildProxyChainShouldHandleUnicode_closure20.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _testBuildProxyChainShouldHandleUnicode_closure20.$getCallSiteArray();
                return false;
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testBuildProxyChainShouldHandleUnicode_closure20.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_testBuildProxyChainShouldHandleUnicode_closure20.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testBuildProxyChainShouldHandleUnicode_closure20.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        NiFiUser mockJohn = (NiFiUser)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"getIdentity", new _testBuildProxyChainShouldHandleUnicode_closure18(this, this), "getChain", new _testBuildProxyChainShouldHandleUnicode_closure19(this, this, mockProxy1), "isAnonymous", new _testBuildProxyChainShouldHandleUnicode_closure20(this, this)}), NiFiUser.class);
        String proxiedEntitiesChain = ShortTypeHandling.castToString((Object)callSiteArray[61].call(ProxiedEntitiesUtils.class, (Object)mockJohn));
        callSiteArray[62].call((Object)logger, (Object)new GStringImpl(new Object[]{proxiedEntitiesChain}, new String[]{"Proxied entities chain: ", ""}));
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            String string = proxiedEntitiesChain;
            valueRecorder.record((Object)string, 8);
            Object[] objectArray = new Object[2];
            String string2 = SAFE_USER_NAME_JOHN;
            valueRecorder.record((Object)string2, 36);
            valueRecorder.record((Object)string2, 36);
            objectArray[0] = string2;
            String string3 = UNICODE_DN_1_ENCODED;
            valueRecorder.record((Object)string3, 60);
            valueRecorder.record((Object)string3, 60);
            objectArray[1] = string3;
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)string, (Object)((String)ScriptBytecodeAdapter.asType((Object)new GStringImpl(objectArray, new String[]{"<", "><", ">"}), String.class)));
            valueRecorder.record((Object)bl, 29);
            if (bl) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert proxiedEntitiesChain == \"<${SAFE_USER_NAME_JOHN}><${UNICODE_DN_1_ENCODED}>\" as String", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
    }

    @Test
    public void testBuildProxyChainShouldHandleMaliciousUser() throws Exception {
        CallSite[] callSiteArray = ProxiedEntitiesUtilsTest.$getCallSiteArray();
        public final class _testBuildProxyChainShouldHandleMaliciousUser_closure21
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _testBuildProxyChainShouldHandleMaliciousUser_closure21(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _testBuildProxyChainShouldHandleMaliciousUser_closure21.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _testBuildProxyChainShouldHandleMaliciousUser_closure21.$getCallSiteArray();
                return ScriptBytecodeAdapter.getField(_testBuildProxyChainShouldHandleMaliciousUser_closure21.class, ProxiedEntitiesUtilsTest.class, (String)"SAFE_USER_NAME_PROXY_1");
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testBuildProxyChainShouldHandleMaliciousUser_closure21.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_testBuildProxyChainShouldHandleMaliciousUser_closure21.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testBuildProxyChainShouldHandleMaliciousUser_closure21.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public final class _testBuildProxyChainShouldHandleMaliciousUser_closure22
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _testBuildProxyChainShouldHandleMaliciousUser_closure22(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _testBuildProxyChainShouldHandleMaliciousUser_closure22.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _testBuildProxyChainShouldHandleMaliciousUser_closure22.$getCallSiteArray();
                return null;
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testBuildProxyChainShouldHandleMaliciousUser_closure22.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_testBuildProxyChainShouldHandleMaliciousUser_closure22.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testBuildProxyChainShouldHandleMaliciousUser_closure22.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public final class _testBuildProxyChainShouldHandleMaliciousUser_closure23
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _testBuildProxyChainShouldHandleMaliciousUser_closure23(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _testBuildProxyChainShouldHandleMaliciousUser_closure23.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _testBuildProxyChainShouldHandleMaliciousUser_closure23.$getCallSiteArray();
                return false;
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testBuildProxyChainShouldHandleMaliciousUser_closure23.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_testBuildProxyChainShouldHandleMaliciousUser_closure23.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testBuildProxyChainShouldHandleMaliciousUser_closure23.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        Reference mockProxy1 = new Reference((Object)((NiFiUser)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"getIdentity", new _testBuildProxyChainShouldHandleMaliciousUser_closure21(this, this), "getChain", new _testBuildProxyChainShouldHandleMaliciousUser_closure22(this, this), "isAnonymous", new _testBuildProxyChainShouldHandleMaliciousUser_closure23(this, this)}), NiFiUser.class)));
        public final class _testBuildProxyChainShouldHandleMaliciousUser_closure24
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _testBuildProxyChainShouldHandleMaliciousUser_closure24(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _testBuildProxyChainShouldHandleMaliciousUser_closure24.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _testBuildProxyChainShouldHandleMaliciousUser_closure24.$getCallSiteArray();
                return ScriptBytecodeAdapter.getField(_testBuildProxyChainShouldHandleMaliciousUser_closure24.class, ProxiedEntitiesUtilsTest.class, (String)"MALICIOUS_USER_NAME_JOHN");
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testBuildProxyChainShouldHandleMaliciousUser_closure24.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_testBuildProxyChainShouldHandleMaliciousUser_closure24.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testBuildProxyChainShouldHandleMaliciousUser_closure24.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public final class _testBuildProxyChainShouldHandleMaliciousUser_closure25
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference mockProxy1;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _testBuildProxyChainShouldHandleMaliciousUser_closure25(Object _outerInstance, Object _thisObject, Reference mockProxy1) {
                Reference reference;
                CallSite[] callSiteArray = _testBuildProxyChainShouldHandleMaliciousUser_closure25.$getCallSiteArray();
                super(_outerInstance, _thisObject);
                this.mockProxy1 = reference = mockProxy1;
            }

            public Object doCall() {
                CallSite[] callSiteArray = _testBuildProxyChainShouldHandleMaliciousUser_closure25.$getCallSiteArray();
                return this.mockProxy1.get();
            }

            @Generated
            public Object getMockProxy1() {
                CallSite[] callSiteArray = _testBuildProxyChainShouldHandleMaliciousUser_closure25.$getCallSiteArray();
                return this.mockProxy1.get();
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testBuildProxyChainShouldHandleMaliciousUser_closure25.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_testBuildProxyChainShouldHandleMaliciousUser_closure25.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testBuildProxyChainShouldHandleMaliciousUser_closure25.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        public final class _testBuildProxyChainShouldHandleMaliciousUser_closure26
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _testBuildProxyChainShouldHandleMaliciousUser_closure26(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _testBuildProxyChainShouldHandleMaliciousUser_closure26.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall() {
                CallSite[] callSiteArray = _testBuildProxyChainShouldHandleMaliciousUser_closure26.$getCallSiteArray();
                return false;
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testBuildProxyChainShouldHandleMaliciousUser_closure26.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_testBuildProxyChainShouldHandleMaliciousUser_closure26.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testBuildProxyChainShouldHandleMaliciousUser_closure26.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        NiFiUser mockJohn = (NiFiUser)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"getIdentity", new _testBuildProxyChainShouldHandleMaliciousUser_closure24(this, this), "getChain", new _testBuildProxyChainShouldHandleMaliciousUser_closure25(this, this, mockProxy1), "isAnonymous", new _testBuildProxyChainShouldHandleMaliciousUser_closure26(this, this)}), NiFiUser.class);
        String proxiedEntitiesChain = ShortTypeHandling.castToString((Object)callSiteArray[63].call(ProxiedEntitiesUtils.class, (Object)mockJohn));
        callSiteArray[64].call((Object)logger, (Object)new GStringImpl(new Object[]{proxiedEntitiesChain}, new String[]{"Proxied entities chain: ", ""}));
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            String string = proxiedEntitiesChain;
            valueRecorder.record((Object)string, 8);
            Object[] objectArray = new Object[2];
            String string2 = MALICIOUS_USER_NAME_JOHN_ESCAPED;
            valueRecorder.record((Object)string2, 36);
            valueRecorder.record((Object)string2, 36);
            objectArray[0] = string2;
            String string3 = SAFE_USER_NAME_PROXY_1;
            valueRecorder.record((Object)string3, 73);
            valueRecorder.record((Object)string3, 73);
            objectArray[1] = string3;
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)string, (Object)((String)ScriptBytecodeAdapter.asType((Object)new GStringImpl(objectArray, new String[]{"<", "><", ">"}), String.class)));
            valueRecorder.record((Object)bl, 29);
            if (bl) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert proxiedEntitiesChain == \"<${MALICIOUS_USER_NAME_JOHN_ESCAPED}><${SAFE_USER_NAME_PROXY_1}>\" as String", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
    }

    @Test
    public void testShouldTokenizeProxiedEntitiesChainWithUserNames() throws Exception {
        CallSite[] callSiteArray = ProxiedEntitiesUtilsTest.$getCallSiteArray();
        List NAMES = ScriptBytecodeAdapter.createList((Object[])new Object[]{SAFE_USER_NAME_JOHN, SAFE_USER_NAME_PROXY_1, SAFE_USER_NAME_PROXY_2});
        String RAW_PROXY_CHAIN = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{callSiteArray[65].call((Object)NAMES, (Object)"><")}, new String[]{"<", ">"}));
        callSiteArray[66].call((Object)logger, (Object)new GStringImpl(new Object[]{RAW_PROXY_CHAIN}, new String[]{" Provided proxy chain: ", ""}));
        Object tokenizedNames = callSiteArray[67].call(ProxiedEntitiesUtils.class, (Object)RAW_PROXY_CHAIN);
        callSiteArray[68].call((Object)logger, (Object)new GStringImpl(new Object[]{tokenizedNames}, new String[]{"Tokenized proxy chain: ", ""}));
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            Object object = tokenizedNames;
            valueRecorder.record(object, 8);
            List list = NAMES;
            valueRecorder.record((Object)list, 26);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)object, (Object)list);
            valueRecorder.record((Object)bl, 23);
            if (bl) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert tokenizedNames == NAMES", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
    }

    @Test
    public void testShouldTokenizeAnonymous() throws Exception {
        CallSite[] callSiteArray = ProxiedEntitiesUtilsTest.$getCallSiteArray();
        List NAMES = ScriptBytecodeAdapter.createList((Object[])new Object[]{""});
        String RAW_PROXY_CHAIN = "<>";
        callSiteArray[69].call((Object)logger, (Object)new GStringImpl(new Object[]{RAW_PROXY_CHAIN}, new String[]{" Provided proxy chain: ", ""}));
        Object tokenizedNames = callSiteArray[70].call(ProxiedEntitiesUtils.class, (Object)RAW_PROXY_CHAIN);
        callSiteArray[71].call((Object)logger, (Object)new GStringImpl(new Object[]{tokenizedNames}, new String[]{"Tokenized proxy chain: ", ""}));
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            Object object = tokenizedNames;
            valueRecorder.record(object, 8);
            List list = NAMES;
            valueRecorder.record((Object)list, 26);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)object, (Object)list);
            valueRecorder.record((Object)bl, 23);
            if (bl) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert tokenizedNames == NAMES", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
    }

    @Test
    public void testShouldTokenizeDoubleAnonymous() throws Exception {
        CallSite[] callSiteArray = ProxiedEntitiesUtilsTest.$getCallSiteArray();
        List NAMES = ScriptBytecodeAdapter.createList((Object[])new Object[]{"", ""});
        String RAW_PROXY_CHAIN = "<><>";
        callSiteArray[72].call((Object)logger, (Object)new GStringImpl(new Object[]{RAW_PROXY_CHAIN}, new String[]{" Provided proxy chain: ", ""}));
        Object tokenizedNames = callSiteArray[73].call(ProxiedEntitiesUtils.class, (Object)RAW_PROXY_CHAIN);
        callSiteArray[74].call((Object)logger, (Object)new GStringImpl(new Object[]{tokenizedNames}, new String[]{"Tokenized proxy chain: ", ""}));
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            Object object = tokenizedNames;
            valueRecorder.record(object, 8);
            List list = NAMES;
            valueRecorder.record((Object)list, 26);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)object, (Object)list);
            valueRecorder.record((Object)bl, 23);
            if (bl) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert tokenizedNames == NAMES", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
    }

    @Test
    public void testShouldTokenizeNestedAnonymous() throws Exception {
        CallSite[] callSiteArray = ProxiedEntitiesUtilsTest.$getCallSiteArray();
        List NAMES = ScriptBytecodeAdapter.createList((Object[])new Object[]{SAFE_USER_DN_PROXY_1, "", SAFE_USER_DN_PROXY_2});
        String RAW_PROXY_CHAIN = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{SAFE_USER_DN_PROXY_1, SAFE_USER_DN_PROXY_2}, new String[]{"<", "><><", ">"}));
        callSiteArray[75].call((Object)logger, (Object)new GStringImpl(new Object[]{RAW_PROXY_CHAIN}, new String[]{" Provided proxy chain: ", ""}));
        Object tokenizedNames = callSiteArray[76].call(ProxiedEntitiesUtils.class, (Object)RAW_PROXY_CHAIN);
        callSiteArray[77].call((Object)logger, (Object)new GStringImpl(new Object[]{tokenizedNames}, new String[]{"Tokenized proxy chain: ", ""}));
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            Object object = tokenizedNames;
            valueRecorder.record(object, 8);
            List list = NAMES;
            valueRecorder.record((Object)list, 26);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)object, (Object)list);
            valueRecorder.record((Object)bl, 23);
            if (bl) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert tokenizedNames == NAMES", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
    }

    @Test
    public void testShouldTokenizeProxiedEntitiesChainWithDNs() throws Exception {
        CallSite[] callSiteArray = ProxiedEntitiesUtilsTest.$getCallSiteArray();
        List DNS = ScriptBytecodeAdapter.createList((Object[])new Object[]{SAFE_USER_DN_JOHN, SAFE_USER_DN_PROXY_1, SAFE_USER_DN_PROXY_2});
        String RAW_PROXY_CHAIN = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{callSiteArray[78].call((Object)DNS, (Object)"><")}, new String[]{"<", ">"}));
        callSiteArray[79].call((Object)logger, (Object)new GStringImpl(new Object[]{RAW_PROXY_CHAIN}, new String[]{" Provided proxy chain: ", ""}));
        Object tokenizedDns = callSiteArray[80].call(ProxiedEntitiesUtils.class, (Object)RAW_PROXY_CHAIN);
        public final class _testShouldTokenizeProxiedEntitiesChainWithDNs_closure27
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _testShouldTokenizeProxiedEntitiesChainWithDNs_closure27(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _testShouldTokenizeProxiedEntitiesChainWithDNs_closure27.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _testShouldTokenizeProxiedEntitiesChainWithDNs_closure27.$getCallSiteArray();
                return new GStringImpl(new Object[]{it}, new String[]{"\"", "\""});
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _testShouldTokenizeProxiedEntitiesChainWithDNs_closure27.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testShouldTokenizeProxiedEntitiesChainWithDNs_closure27.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_testShouldTokenizeProxiedEntitiesChainWithDNs_closure27.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testShouldTokenizeProxiedEntitiesChainWithDNs_closure27.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[81].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[82].call(tokenizedDns, (Object)new _testShouldTokenizeProxiedEntitiesChainWithDNs_closure27(this, this))}, new String[]{"Tokenized proxy chain: ", ""}));
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            Object object = tokenizedDns;
            valueRecorder.record(object, 8);
            List list = DNS;
            valueRecorder.record((Object)list, 24);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)object, (Object)list);
            valueRecorder.record((Object)bl, 21);
            if (bl) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert tokenizedDns == DNS", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
    }

    @Test
    public void testShouldTokenizeProxiedEntitiesChainWithAnonymousUser() throws Exception {
        CallSite[] callSiteArray = ProxiedEntitiesUtilsTest.$getCallSiteArray();
        List NAMES = ScriptBytecodeAdapter.createList((Object[])new Object[]{"", SAFE_USER_NAME_PROXY_1, SAFE_USER_NAME_PROXY_2});
        String RAW_PROXY_CHAIN = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{callSiteArray[83].call((Object)NAMES, (Object)"><")}, new String[]{"<", ">"}));
        callSiteArray[84].call((Object)logger, (Object)new GStringImpl(new Object[]{RAW_PROXY_CHAIN}, new String[]{" Provided proxy chain: ", ""}));
        Object tokenizedNames = callSiteArray[85].call(ProxiedEntitiesUtils.class, (Object)RAW_PROXY_CHAIN);
        callSiteArray[86].call((Object)logger, (Object)new GStringImpl(new Object[]{tokenizedNames}, new String[]{"Tokenized proxy chain: ", ""}));
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            Object object = tokenizedNames;
            valueRecorder.record(object, 8);
            List list = NAMES;
            valueRecorder.record((Object)list, 26);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)object, (Object)list);
            valueRecorder.record((Object)bl, 23);
            if (bl) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert tokenizedNames == NAMES", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
    }

    @Test
    public void testTokenizeProxiedEntitiesChainShouldHandleMaliciousUser() throws Exception {
        CallSite[] callSiteArray = ProxiedEntitiesUtilsTest.$getCallSiteArray();
        List NAMES = ScriptBytecodeAdapter.createList((Object[])new Object[]{MALICIOUS_USER_NAME_JOHN, SAFE_USER_NAME_PROXY_1, SAFE_USER_NAME_PROXY_2});
        public final class _testTokenizeProxiedEntitiesChainShouldHandleMaliciousUser_closure28
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _testTokenizeProxiedEntitiesChainShouldHandleMaliciousUser_closure28(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _testTokenizeProxiedEntitiesChainShouldHandleMaliciousUser_closure28.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _testTokenizeProxiedEntitiesChainShouldHandleMaliciousUser_closure28.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, it);
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _testTokenizeProxiedEntitiesChainShouldHandleMaliciousUser_closure28.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testTokenizeProxiedEntitiesChainShouldHandleMaliciousUser_closure28.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "sanitizeDn";
                return new CallSiteArray(_testTokenizeProxiedEntitiesChainShouldHandleMaliciousUser_closure28.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testTokenizeProxiedEntitiesChainShouldHandleMaliciousUser_closure28.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        String RAW_PROXY_CHAIN = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{callSiteArray[87].call(callSiteArray[88].call((Object)NAMES, (Object)new _testTokenizeProxiedEntitiesChainShouldHandleMaliciousUser_closure28(this, this)), (Object)"><")}, new String[]{"<", ">"}));
        callSiteArray[89].call((Object)logger, (Object)new GStringImpl(new Object[]{RAW_PROXY_CHAIN}, new String[]{" Provided proxy chain: ", ""}));
        Object tokenizedNames = callSiteArray[90].call(ProxiedEntitiesUtils.class, (Object)RAW_PROXY_CHAIN);
        public final class _testTokenizeProxiedEntitiesChainShouldHandleMaliciousUser_closure29
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _testTokenizeProxiedEntitiesChainShouldHandleMaliciousUser_closure29(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _testTokenizeProxiedEntitiesChainShouldHandleMaliciousUser_closure29.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _testTokenizeProxiedEntitiesChainShouldHandleMaliciousUser_closure29.$getCallSiteArray();
                return new GStringImpl(new Object[]{it}, new String[]{"\"", "\""});
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _testTokenizeProxiedEntitiesChainShouldHandleMaliciousUser_closure29.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testTokenizeProxiedEntitiesChainShouldHandleMaliciousUser_closure29.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_testTokenizeProxiedEntitiesChainShouldHandleMaliciousUser_closure29.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testTokenizeProxiedEntitiesChainShouldHandleMaliciousUser_closure29.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[91].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[92].call(tokenizedNames, (Object)new _testTokenizeProxiedEntitiesChainShouldHandleMaliciousUser_closure29(this, this))}, new String[]{"Tokenized proxy chain: ", ""}));
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            Object object = tokenizedNames;
            valueRecorder.record(object, 8);
            List list = NAMES;
            valueRecorder.record((Object)list, 26);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)object, (Object)list);
            valueRecorder.record((Object)bl, 23);
            if (bl) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert tokenizedNames == NAMES", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        ValueRecorder valueRecorder2 = new ValueRecorder();
        try {
            CallSite callSite = callSiteArray[93];
            Object object = tokenizedNames;
            valueRecorder2.record(object, 8);
            Object object2 = callSite.call(object);
            valueRecorder2.record(object2, 23);
            CallSite callSite2 = callSiteArray[94];
            List list = NAMES;
            valueRecorder2.record((Object)list, 33);
            Object object3 = callSite2.call((Object)list);
            valueRecorder2.record(object3, 39);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)object2, (Object)object3);
            valueRecorder2.record((Object)bl, 30);
            if (bl) {
                valueRecorder2.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert tokenizedNames.size() == NAMES.size()", (ValueRecorder)valueRecorder2), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder2.clear();
            throw throwable;
        }
        ValueRecorder valueRecorder3 = new ValueRecorder();
        try {
            CallSite callSite = callSiteArray[95];
            Object object = tokenizedNames;
            valueRecorder3.record(object, 9);
            String string = SAFE_USER_NAME_JOHN;
            valueRecorder3.record((Object)string, 33);
            valueRecorder3.record((Object)string, 33);
            Object object4 = callSite.call(object, (Object)string);
            valueRecorder3.record(object4, 24);
            boolean bl = !DefaultTypeTransformation.booleanUnbox((Object)object4);
            valueRecorder3.record((Object)bl, 8);
            if (bl) {
                valueRecorder3.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert !tokenizedNames.contains(SAFE_USER_NAME_JOHN)", (ValueRecorder)valueRecorder3), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder3.clear();
            throw throwable;
        }
    }

    @Test
    public void testTokenizeProxiedEntitiesChainShouldDecodeNonAsciiValues() throws Exception {
        CallSite[] callSiteArray = ProxiedEntitiesUtilsTest.$getCallSiteArray();
        String RAW_PROXY_CHAIN = ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{SAFE_USER_NAME_JOHN, UNICODE_DN_1_ENCODED, UNICODE_DN_2_ENCODED}, new String[]{"<", "><", "><", ">"}));
        List TOKENIZED_NAMES = ScriptBytecodeAdapter.createList((Object[])new Object[]{SAFE_USER_NAME_JOHN, UNICODE_DN_1, UNICODE_DN_2});
        callSiteArray[96].call((Object)logger, (Object)new GStringImpl(new Object[]{RAW_PROXY_CHAIN}, new String[]{" Provided proxy chain: ", ""}));
        Object tokenizedNames = callSiteArray[97].call(ProxiedEntitiesUtils.class, (Object)RAW_PROXY_CHAIN);
        public final class _testTokenizeProxiedEntitiesChainShouldDecodeNonAsciiValues_closure30
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _testTokenizeProxiedEntitiesChainShouldDecodeNonAsciiValues_closure30(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _testTokenizeProxiedEntitiesChainShouldDecodeNonAsciiValues_closure30.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _testTokenizeProxiedEntitiesChainShouldDecodeNonAsciiValues_closure30.$getCallSiteArray();
                return new GStringImpl(new Object[]{it}, new String[]{"\"", "\""});
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _testTokenizeProxiedEntitiesChainShouldDecodeNonAsciiValues_closure30.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _testTokenizeProxiedEntitiesChainShouldDecodeNonAsciiValues_closure30.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_testTokenizeProxiedEntitiesChainShouldDecodeNonAsciiValues_closure30.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _testTokenizeProxiedEntitiesChainShouldDecodeNonAsciiValues_closure30.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[98].call((Object)logger, (Object)new GStringImpl(new Object[]{callSiteArray[99].call(tokenizedNames, (Object)new _testTokenizeProxiedEntitiesChainShouldDecodeNonAsciiValues_closure30(this, this))}, new String[]{"Tokenized proxy chain: ", ""}));
        ValueRecorder valueRecorder = new ValueRecorder();
        try {
            Object object = tokenizedNames;
            valueRecorder.record(object, 8);
            List list = TOKENIZED_NAMES;
            valueRecorder.record((Object)list, 26);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)object, (Object)list);
            valueRecorder.record((Object)bl, 23);
            if (bl) {
                valueRecorder.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert tokenizedNames == TOKENIZED_NAMES", (ValueRecorder)valueRecorder), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder.clear();
            throw throwable;
        }
        ValueRecorder valueRecorder2 = new ValueRecorder();
        try {
            CallSite callSite = callSiteArray[100];
            Object object = tokenizedNames;
            valueRecorder2.record(object, 8);
            Object object2 = callSite.call(object);
            valueRecorder2.record(object2, 23);
            CallSite callSite2 = callSiteArray[101];
            List list = TOKENIZED_NAMES;
            valueRecorder2.record((Object)list, 33);
            Object object3 = callSite2.call((Object)list);
            valueRecorder2.record(object3, 49);
            boolean bl = ScriptBytecodeAdapter.compareEqual((Object)object2, (Object)object3);
            valueRecorder2.record((Object)bl, 30);
            if (bl) {
                valueRecorder2.clear();
            } else {
                ScriptBytecodeAdapter.assertFailed((Object)AssertionRenderer.render((String)"assert tokenizedNames.size() == TOKENIZED_NAMES.size()", (ValueRecorder)valueRecorder2), null);
            }
        }
        catch (Throwable throwable) {
            valueRecorder2.clear();
            throw throwable;
        }
    }

    @Generated
    private static String sanitizeDn() {
        CallSite[] callSiteArray = ProxiedEntitiesUtilsTest.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return ProxiedEntitiesUtilsTest.sanitizeDn("");
        }
        return ProxiedEntitiesUtilsTest.sanitizeDn("");
    }

    @Generated
    private static String base64Encode() {
        CallSite[] callSiteArray = ProxiedEntitiesUtilsTest.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            return ProxiedEntitiesUtilsTest.base64Encode("");
        }
        return ProxiedEntitiesUtilsTest.base64Encode("");
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ProxiedEntitiesUtilsTest.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    static {
        Object object = ProxiedEntitiesUtilsTest.$getCallSiteArray()[102].call(LoggerFactory.class, ProxiedEntitiesUtils.class);
        logger = (Logger)ScriptBytecodeAdapter.castToType((Object)object, Logger.class);
        GStringImpl gStringImpl = new GStringImpl(new Object[]{SAFE_USER_NAME_ANDY}, new String[]{"CN=", ", OU=Apache NiFi"});
        SAFE_USER_DN_ANDY = ShortTypeHandling.castToString((Object)gStringImpl);
        GStringImpl gStringImpl2 = new GStringImpl(new Object[]{SAFE_USER_NAME_JOHN}, new String[]{"CN=", ", OU=Apache NiFi"});
        SAFE_USER_DN_JOHN = ShortTypeHandling.castToString((Object)gStringImpl2);
        GStringImpl gStringImpl3 = new GStringImpl(new Object[]{SAFE_USER_NAME_PROXY_1}, new String[]{"CN=", ", OU=Apache NiFi"});
        SAFE_USER_DN_PROXY_1 = ShortTypeHandling.castToString((Object)gStringImpl3);
        GStringImpl gStringImpl4 = new GStringImpl(new Object[]{SAFE_USER_NAME_PROXY_2}, new String[]{"CN=", ", OU=Apache NiFi"});
        SAFE_USER_DN_PROXY_2 = ShortTypeHandling.castToString((Object)gStringImpl4);
        GStringImpl gStringImpl5 = new GStringImpl(new Object[]{SAFE_USER_NAME_JOHN, SAFE_USER_NAME_PROXY_1}, new String[]{"", ", OU=Apache NiFi><CN=", ""});
        MALICIOUS_USER_NAME_JOHN = ShortTypeHandling.castToString((Object)gStringImpl5);
        GStringImpl gStringImpl6 = new GStringImpl(new Object[]{MALICIOUS_USER_NAME_JOHN}, new String[]{"CN=", ", OU=Apache NiFi"});
        MALICIOUS_USER_DN_JOHN = ShortTypeHandling.castToString((Object)gStringImpl6);
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object2 = ProxiedEntitiesUtilsTest.$getCallSiteArray()[103].callStatic(ProxiedEntitiesUtilsTest.class, (Object)MALICIOUS_USER_NAME_JOHN);
            MALICIOUS_USER_NAME_JOHN_ESCAPED = ShortTypeHandling.castToString((Object)object2);
        } else {
            String string;
            MALICIOUS_USER_NAME_JOHN_ESCAPED = string = ProxiedEntitiesUtilsTest.sanitizeDn(MALICIOUS_USER_NAME_JOHN);
        }
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object3 = ProxiedEntitiesUtilsTest.$getCallSiteArray()[104].callStatic(ProxiedEntitiesUtilsTest.class, (Object)MALICIOUS_USER_DN_JOHN);
            MALICIOUS_USER_DN_JOHN_ESCAPED = ShortTypeHandling.castToString((Object)object3);
        } else {
            String string;
            MALICIOUS_USER_DN_JOHN_ESCAPED = string = ProxiedEntitiesUtilsTest.sanitizeDn(MALICIOUS_USER_DN_JOHN);
        }
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object4 = ProxiedEntitiesUtilsTest.$getCallSiteArray()[105].call(ProxiedEntitiesUtilsTest.$getCallSiteArray()[106].call((Object)"<", ProxiedEntitiesUtilsTest.$getCallSiteArray()[107].callStatic(ProxiedEntitiesUtilsTest.class, (Object)UNICODE_DN_1)), (Object)">");
            UNICODE_DN_1_ENCODED = ShortTypeHandling.castToString((Object)object4);
        } else {
            Object object5 = ProxiedEntitiesUtilsTest.$getCallSiteArray()[108].call(ProxiedEntitiesUtilsTest.$getCallSiteArray()[109].call((Object)"<", (Object)ProxiedEntitiesUtilsTest.base64Encode(UNICODE_DN_1)), (Object)">");
            UNICODE_DN_1_ENCODED = ShortTypeHandling.castToString((Object)object5);
        }
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object6 = ProxiedEntitiesUtilsTest.$getCallSiteArray()[110].call(ProxiedEntitiesUtilsTest.$getCallSiteArray()[111].call((Object)"<", ProxiedEntitiesUtilsTest.$getCallSiteArray()[112].callStatic(ProxiedEntitiesUtilsTest.class, (Object)UNICODE_DN_2)), (Object)">");
            UNICODE_DN_2_ENCODED = ShortTypeHandling.castToString((Object)object6);
        } else {
            Object object7 = ProxiedEntitiesUtilsTest.$getCallSiteArray()[113].call(ProxiedEntitiesUtilsTest.$getCallSiteArray()[114].call((Object)"<", (Object)ProxiedEntitiesUtilsTest.base64Encode(UNICODE_DN_2)), (Object)">");
            UNICODE_DN_2_ENCODED = ShortTypeHandling.castToString((Object)object7);
        }
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "metaClass";
        stringArray[1] = "replaceAll";
        stringArray[2] = "replaceAll";
        stringArray[3] = "encodeToString";
        stringArray[4] = "getEncoder";
        stringArray[5] = "getBytes";
        stringArray[6] = "UTF_8";
        stringArray[7] = "<$constructor$>";
        stringArray[8] = "size";
        stringArray[9] = "codePointAt";
        stringArray[10] = "charCount";
        stringArray[11] = "plus";
        stringArray[12] = "minus";
        stringArray[13] = "length";
        stringArray[14] = "<$constructor$>";
        stringArray[15] = "append";
        stringArray[16] = "format";
        stringArray[17] = "next";
        stringArray[18] = "size";
        stringArray[19] = "codePointAt";
        stringArray[20] = "charCount";
        stringArray[21] = "length";
        stringArray[22] = "<$constructor$>";
        stringArray[23] = "append";
        stringArray[24] = "format";
        stringArray[25] = "trim";
        stringArray[26] = "toString";
        stringArray[27] = "info";
        stringArray[28] = "printUnicodeString";
        stringArray[29] = "info";
        stringArray[30] = "plus";
        stringArray[31] = "plus";
        stringArray[32] = "plus";
        stringArray[33] = "plus";
        stringArray[34] = "plus";
        stringArray[35] = "plus";
        stringArray[36] = "plus";
        stringArray[37] = "each";
        stringArray[38] = "info";
        stringArray[39] = "info";
        stringArray[40] = "formatProxyDn";
        stringArray[41] = "info";
        stringArray[42] = "info";
        stringArray[43] = "sanitizeDn";
        stringArray[44] = "info";
        stringArray[45] = "formatProxyDn";
        stringArray[46] = "info";
        stringArray[47] = "getProxiedEntitiesChain";
        stringArray[48] = "sanitizeDn";
        stringArray[49] = "getProxiedEntitiesChain";
        stringArray[50] = "getProxiedEntitiesChain";
        stringArray[51] = "info";
        stringArray[52] = "info";
        stringArray[53] = "formatProxyDn";
        stringArray[54] = "info";
        stringArray[55] = "buildProxiedEntitiesChainString";
        stringArray[56] = "info";
        stringArray[57] = "buildProxiedEntitiesChainString";
        stringArray[58] = "info";
        stringArray[59] = "buildProxiedEntitiesChainString";
        stringArray[60] = "info";
        stringArray[61] = "buildProxiedEntitiesChainString";
        stringArray[62] = "info";
        stringArray[63] = "buildProxiedEntitiesChainString";
        stringArray[64] = "info";
        stringArray[65] = "join";
        stringArray[66] = "info";
        stringArray[67] = "tokenizeProxiedEntitiesChain";
        stringArray[68] = "info";
        stringArray[69] = "info";
        stringArray[70] = "tokenizeProxiedEntitiesChain";
        stringArray[71] = "info";
        stringArray[72] = "info";
        stringArray[73] = "tokenizeProxiedEntitiesChain";
        stringArray[74] = "info";
        stringArray[75] = "info";
        stringArray[76] = "tokenizeProxiedEntitiesChain";
        stringArray[77] = "info";
        stringArray[78] = "join";
        stringArray[79] = "info";
        stringArray[80] = "tokenizeProxiedEntitiesChain";
        stringArray[81] = "info";
        stringArray[82] = "collect";
        stringArray[83] = "join";
        stringArray[84] = "info";
        stringArray[85] = "tokenizeProxiedEntitiesChain";
        stringArray[86] = "info";
        stringArray[87] = "join";
        stringArray[88] = "collect";
        stringArray[89] = "info";
        stringArray[90] = "tokenizeProxiedEntitiesChain";
        stringArray[91] = "info";
        stringArray[92] = "collect";
        stringArray[93] = "size";
        stringArray[94] = "size";
        stringArray[95] = "contains";
        stringArray[96] = "info";
        stringArray[97] = "tokenizeProxiedEntitiesChain";
        stringArray[98] = "info";
        stringArray[99] = "collect";
        stringArray[100] = "size";
        stringArray[101] = "size";
        stringArray[102] = "getLogger";
        stringArray[103] = "sanitizeDn";
        stringArray[104] = "sanitizeDn";
        stringArray[105] = "plus";
        stringArray[106] = "plus";
        stringArray[107] = "base64Encode";
        stringArray[108] = "plus";
        stringArray[109] = "plus";
        stringArray[110] = "plus";
        stringArray[111] = "plus";
        stringArray[112] = "base64Encode";
        stringArray[113] = "plus";
        stringArray[114] = "plus";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[115];
        ProxiedEntitiesUtilsTest.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(ProxiedEntitiesUtilsTest.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = ProxiedEntitiesUtilsTest.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

