/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.revision;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.web.InvalidRevisionException;
import org.apache.nifi.web.Revision;
import org.apache.nifi.web.revision.DeleteRevisionTask;
import org.apache.nifi.web.revision.ExpiredRevisionClaimException;
import org.apache.nifi.web.revision.RevisionClaim;
import org.apache.nifi.web.revision.RevisionComparator;
import org.apache.nifi.web.revision.RevisionManager;
import org.apache.nifi.web.revision.RevisionSnapshot;
import org.apache.nifi.web.revision.RevisionUpdate;
import org.apache.nifi.web.revision.UpdateRevisionTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NaiveRevisionManager
implements RevisionManager {
    private static final Logger logger = LoggerFactory.getLogger(NaiveRevisionManager.class);
    private final ConcurrentMap<String, Revision> revisionMap = new ConcurrentHashMap<String, Revision>();
    private final AtomicLong revisionUpdateCounter = new AtomicLong(0L);

    public synchronized void reset(RevisionSnapshot revisionSnapshot) {
        Collection revisions = revisionSnapshot.getRevisions();
        logger.info("Resetting Revisions for all components. {} revisions will be removed, {} will be added", (Object)this.revisionMap.size(), (Object)revisions.size());
        logger.debug("New Revisions: {}", (Object)revisions);
        this.revisionMap.clear();
        for (Revision revision : revisions) {
            this.revisionMap.put(revision.getComponentId(), revision);
        }
        this.revisionUpdateCounter.set(revisionSnapshot.getRevisionUpdateCount());
    }

    public synchronized RevisionSnapshot getAllRevisions() {
        return new RevisionSnapshot(this.revisionMap.values(), this.revisionUpdateCounter.get());
    }

    public long getRevisionUpdateCount() {
        return this.revisionUpdateCounter.get();
    }

    public synchronized Revision getRevision(String componentId) {
        return this.revisionMap.computeIfAbsent(componentId, id -> new Revision(Long.valueOf(0L), null, componentId));
    }

    public synchronized <T> T deleteRevision(RevisionClaim claim, NiFiUser user, DeleteRevisionTask<T> task) throws ExpiredRevisionClaimException {
        Objects.requireNonNull(user);
        logger.debug("Attempting to delete revision using {}", (Object)claim);
        ArrayList<Revision> revisionList = new ArrayList<Revision>(claim.getRevisions());
        revisionList.sort(new RevisionComparator());
        String failedId = null;
        for (Revision revision : revisionList) {
            Revision curRevision = this.getRevision(revision.getComponentId());
            if (curRevision.equals((Object)revision)) continue;
            throw new ExpiredRevisionClaimException("Invalid Revision was given for component with ID '" + failedId + "'");
        }
        Object taskResult = task.performTask();
        for (Revision revision : revisionList) {
            this.revisionMap.remove(revision.getComponentId());
        }
        this.revisionUpdateCounter.addAndGet(revisionList.size());
        return (T)taskResult;
    }

    public synchronized <T> RevisionUpdate<T> updateRevision(RevisionClaim originalClaim, NiFiUser user, UpdateRevisionTask<T> task) throws ExpiredRevisionClaimException {
        Objects.requireNonNull(user);
        logger.debug("Attempting to update revision using {}", (Object)originalClaim);
        ArrayList<Revision> revisionList = new ArrayList<Revision>(originalClaim.getRevisions());
        revisionList.sort(new RevisionComparator());
        for (Revision revision : revisionList) {
            Revision currentRevision;
            boolean verified = revision.equals((Object)(currentRevision = this.getRevision(revision.getComponentId())));
            if (verified) continue;
            throw new InvalidRevisionException("Invalid Revision was given for component with ID '" + revision.getComponentId() + "'");
        }
        logger.debug("Successfully verified Revision Claim for all revisions");
        RevisionUpdate updatedComponent = task.update();
        if (updatedComponent != null) {
            Set updatedRevisions = updatedComponent.getUpdatedRevisions();
            for (Revision updatedRevision : updatedRevisions) {
                this.revisionMap.put(updatedRevision.getComponentId(), updatedRevision);
            }
            this.revisionUpdateCounter.addAndGet(updatedRevisions.size());
        }
        return updatedComponent;
    }
}

