/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.docs;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.text.Collator;
import java.util.Locale;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.nar.ExtensionMapping;

public class DocumentationController
extends HttpServlet {
    private static final int GENERAL_LINK_COUNT = 4;
    private static final int DEVELOPER_LINK_COUNT = 2;
    private ServletContext servletContext;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.servletContext = config.getServletContext();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ExtensionMapping extensionMappings = (ExtensionMapping)this.servletContext.getAttribute("nifi-extension-mapping");
        Collator collator = Collator.getInstance(Locale.US);
        TreeMap<Object, String> processors = new TreeMap<Object, String>(collator);
        for (Object processorClass : extensionMappings.getProcessorNames().keySet()) {
            processors.put(StringUtils.substringAfterLast((String)processorClass, (String)"."), (String)processorClass);
        }
        TreeMap<Object, String> controllerServices = new TreeMap<Object, String>(collator);
        for (Object controllerServiceClass : extensionMappings.getControllerServiceNames().keySet()) {
            controllerServices.put(StringUtils.substringAfterLast((String)controllerServiceClass, (String)"."), (String)controllerServiceClass);
        }
        TreeMap<Object, String> reportingTasks = new TreeMap<Object, String>(collator);
        for (String reportingTaskClass : extensionMappings.getReportingTaskNames().keySet()) {
            reportingTasks.put(StringUtils.substringAfterLast((String)reportingTaskClass, (String)"."), reportingTaskClass);
        }
        TreeMap<Object, String> parameterProviders = new TreeMap<Object, String>(collator);
        for (String parameterProviderClass : extensionMappings.getParameterProviderNames().keySet()) {
            parameterProviders.put(StringUtils.substringAfterLast((String)parameterProviderClass, (String)"."), parameterProviderClass);
        }
        request.setAttribute("processors", processors);
        request.setAttribute("processorBundleLookup", (Object)extensionMappings.getProcessorNames());
        request.setAttribute("controllerServices", controllerServices);
        request.setAttribute("controllerServiceBundleLookup", (Object)extensionMappings.getControllerServiceNames());
        request.setAttribute("reportingTasks", reportingTasks);
        request.setAttribute("parameterProviders", parameterProviders);
        request.setAttribute("reportingTaskBundleLookup", (Object)extensionMappings.getReportingTaskNames());
        request.setAttribute("parameterProviderBundleLookup", (Object)extensionMappings.getParameterProviderNames());
        request.setAttribute("totalComponents", (Object)(4 + extensionMappings.size() + 2));
        request.getRequestDispatcher("/WEB-INF/jsp/documentation.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }
}

