/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.client;

import java.net.URI;
import java.util.Objects;
import okhttp3.HttpUrl;
import org.apache.nifi.web.client.api.HttpUriBuilder;

public class StandardHttpUriBuilder
implements HttpUriBuilder {
    private final HttpUrl.Builder builder = new HttpUrl.Builder();

    public URI build() {
        HttpUrl httpUrl = this.builder.build();
        return httpUrl.uri();
    }

    public HttpUriBuilder scheme(String scheme) {
        Objects.requireNonNull(scheme, "Scheme required");
        this.builder.scheme(scheme);
        return this;
    }

    public HttpUriBuilder host(String host) {
        Objects.requireNonNull(host, "Host required");
        this.builder.host(host);
        return this;
    }

    public HttpUriBuilder port(int port) {
        this.builder.port(port);
        return this;
    }

    public HttpUriBuilder encodedPath(String encodedPath) {
        this.builder.encodedPath(encodedPath);
        return this;
    }

    public HttpUriBuilder addPathSegment(String pathSegment) {
        Objects.requireNonNull(pathSegment, "Path segment required");
        this.builder.addPathSegment(pathSegment);
        return this;
    }

    public HttpUriBuilder addQueryParameter(String name, String value) {
        Objects.requireNonNull(name, "Parameter name required");
        this.builder.addQueryParameter(name, value);
        return this;
    }
}

