/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.client.provider.service;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Arrays;
import java.util.Optional;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509KeyManager;
import org.apache.nifi.ssl.SSLContextService;
import org.apache.nifi.web.client.provider.service.KeyManagerProvider;

class StandardKeyManagerProvider
implements KeyManagerProvider {
    StandardKeyManagerProvider() {
    }

    @Override
    public Optional<X509KeyManager> getKeyManager(SSLContextService sslContextService) {
        X509KeyManager keyManager;
        if (sslContextService.isKeyStoreConfigured()) {
            KeyManagerFactory keyManagerFactory = this.getKeyManagerFactory();
            KeyStore keyStore = this.getKeyStore(sslContextService);
            char[] keyPassword = this.getKeyPassword(sslContextService);
            try {
                keyManagerFactory.init(keyStore, keyPassword);
            }
            catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
                throw new IllegalStateException("Key Manager Factory initialization failed", e);
            }
            KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
            Optional<KeyManager> firstKeyManager = Arrays.stream(keyManagers).findFirst();
            KeyManager configuredKeyManager = firstKeyManager.orElse(null);
            keyManager = configuredKeyManager instanceof X509KeyManager ? (X509KeyManager)configuredKeyManager : null;
        } else {
            keyManager = null;
        }
        return Optional.ofNullable(keyManager);
    }

    private KeyStore getKeyStore(SSLContextService sslContextService) {
        String keyStoreType = sslContextService.getKeyStoreType();
        KeyStore keyStore = this.getKeyStore(keyStoreType);
        char[] keyStorePassword = sslContextService.getKeyStorePassword().toCharArray();
        String keyStoreFile = sslContextService.getKeyStoreFile();
        try {
            try (FileInputStream inputStream = new FileInputStream(keyStoreFile);){
                keyStore.load(inputStream, keyStorePassword);
            }
            return keyStore;
        }
        catch (IOException e) {
            throw new IllegalStateException(String.format("Key Store File [%s] reading failed", keyStoreFile), e);
        }
        catch (NoSuchAlgorithmException | CertificateException e) {
            throw new IllegalStateException(String.format("Key Store File [%s] loading failed", keyStoreFile), e);
        }
    }

    private KeyStore getKeyStore(String keyStoreType) {
        try {
            return KeyStore.getInstance(keyStoreType);
        }
        catch (KeyStoreException e) {
            throw new IllegalStateException(String.format("Key Store Type [%s] creation failed", keyStoreType), e);
        }
    }

    private char[] getKeyPassword(SSLContextService sslContextService) {
        String keyPassword = sslContextService.getKeyPassword();
        String keyStorePassword = sslContextService.getKeyStorePassword();
        String password = keyPassword == null ? keyStorePassword : keyPassword;
        return password.toCharArray();
    }

    private KeyManagerFactory getKeyManagerFactory() {
        try {
            return KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("Key Manager Factory creation failed", e);
        }
    }
}

