/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.cluster.coordination.ClusterCoordinator;
import org.apache.nifi.remote.HttpRemoteSiteListener;
import org.apache.nifi.remote.PeerDescription;
import org.apache.nifi.remote.PeerDescriptionModifier;
import org.apache.nifi.remote.VersionNegotiator;
import org.apache.nifi.remote.client.http.TransportProtocolVersionNegotiator;
import org.apache.nifi.remote.exception.BadRequestException;
import org.apache.nifi.remote.protocol.SiteToSiteTransportProtocol;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.api.ApplicationResource;
import org.apache.nifi.web.api.dto.ControllerDTO;
import org.apache.nifi.web.api.dto.remote.PeerDTO;
import org.apache.nifi.web.api.entity.ControllerEntity;
import org.apache.nifi.web.api.entity.PeersEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/site-to-site")
@Api(value="/site-to-site", description="Provide access to site to site with this NiFi")
public class SiteToSiteResource
extends ApplicationResource {
    private static final Logger logger = LoggerFactory.getLogger(SiteToSiteResource.class);
    private NiFiServiceFacade serviceFacade;
    private ClusterCoordinator clusterCoordinator;
    private Authorizer authorizer;
    private final ApplicationResource.ResponseCreator responseCreator = new ApplicationResource.ResponseCreator((ApplicationResource)this);
    private final VersionNegotiator transportProtocolVersionNegotiator = new TransportProtocolVersionNegotiator(new int[]{1});
    private final HttpRemoteSiteListener transactionManager;
    private final PeerDescriptionModifier peerDescriptionModifier;

    public SiteToSiteResource(NiFiProperties nifiProperties) {
        this.transactionManager = HttpRemoteSiteListener.getInstance((NiFiProperties)nifiProperties);
        this.peerDescriptionModifier = new PeerDescriptionModifier(nifiProperties);
    }

    protected void authorizeSiteToSite() {
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable siteToSite = lookup.getSiteToSite();
            siteToSite.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Returns the details about this NiFi necessary to communicate via site to site", response=ControllerEntity.class, authorizations={@Authorization(value="Read - /site-to-site")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getSiteToSiteDetails(@Context HttpServletRequest req) {
        this.authorizeSiteToSite();
        ControllerDTO controller = this.serviceFacade.getSiteToSiteDetails();
        boolean modificationNeededRaw = this.peerDescriptionModifier.isModificationNeeded(SiteToSiteTransportProtocol.RAW);
        boolean modificationNeededHttp = this.peerDescriptionModifier.isModificationNeeded(SiteToSiteTransportProtocol.HTTP);
        if (modificationNeededRaw || modificationNeededHttp) {
            PeerDescription source = this.getSourcePeerDescription(req);
            Boolean isSiteToSiteSecure = controller.isSiteToSiteSecure();
            String siteToSiteHostname = this.getSiteToSiteHostname(req);
            Map httpHeaders = this.getHttpHeaders(req);
            if (modificationNeededRaw) {
                PeerDescription rawTarget = new PeerDescription(siteToSiteHostname, controller.getRemoteSiteListeningPort().intValue(), isSiteToSiteSecure.booleanValue());
                PeerDescription modifiedRawTarget = this.peerDescriptionModifier.modify(source, rawTarget, SiteToSiteTransportProtocol.RAW, PeerDescriptionModifier.RequestType.SiteToSiteDetail, new HashMap(httpHeaders));
                controller.setRemoteSiteListeningPort(Integer.valueOf(modifiedRawTarget.getPort()));
            }
            if (modificationNeededHttp) {
                PeerDescription httpTarget = new PeerDescription(siteToSiteHostname, controller.getRemoteSiteHttpListeningPort().intValue(), isSiteToSiteSecure.booleanValue());
                PeerDescription modifiedHttpTarget = this.peerDescriptionModifier.modify(source, httpTarget, SiteToSiteTransportProtocol.HTTP, PeerDescriptionModifier.RequestType.SiteToSiteDetail, new HashMap(httpHeaders));
                controller.setRemoteSiteHttpListeningPort(Integer.valueOf(modifiedHttpTarget.getPort()));
                if (!controller.isSiteToSiteSecure().booleanValue() && modifiedHttpTarget.isSecure()) {
                    controller.setSiteToSiteSecure(Boolean.valueOf(true));
                }
            }
        }
        ControllerEntity entity = new ControllerEntity();
        entity.setController(controller);
        if (StringUtils.isEmpty((CharSequence)req.getHeader("x-nifi-site-to-site-protocol-version"))) {
            logger.debug("Converting result to provide backward compatibility...");
            controller.setRemoteSiteHttpListeningPort(null);
        }
        return this.noCache(Response.ok((Object)entity)).build();
    }

    private PeerDescription getSourcePeerDescription(@Context HttpServletRequest req) {
        return new PeerDescription(req.getRemoteHost(), req.getRemotePort(), req.isSecure());
    }

    private Map<String, String> getHttpHeaders(@Context HttpServletRequest req) {
        HashMap<String, String> headers = new HashMap<String, String>();
        Enumeration headerNames = req.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            headers.put(name, req.getHeader(name));
        }
        return headers;
    }

    @GET
    @Path(value="/peers")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json", "application/xml"})
    @ApiOperation(value="Returns the available Peers and its status of this NiFi", response=PeersEntity.class, authorizations={@Authorization(value="Read - /site-to-site")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getPeers(@Context HttpServletRequest req) {
        Map headers;
        Integer transportProtocolVersion;
        this.authorizeSiteToSite();
        if (!this.properties.isSiteToSiteHttpEnabled().booleanValue()) {
            return this.responseCreator.httpSiteToSiteIsNotEnabledResponse();
        }
        try {
            transportProtocolVersion = this.negotiateTransportProtocolVersion(req, this.transportProtocolVersionNegotiator);
        }
        catch (BadRequestException e) {
            return this.responseCreator.badRequestResponse((Exception)((Object)e));
        }
        ArrayList<PeerDTO> peers = new ArrayList<PeerDTO>();
        PeerDescription source = this.getSourcePeerDescription(req);
        boolean modificationNeeded = this.peerDescriptionModifier.isModificationNeeded(SiteToSiteTransportProtocol.HTTP);
        Map map = headers = modificationNeeded ? this.getHttpHeaders(req) : null;
        if (this.properties.isNode()) {
            try {
                Map clusterWorkload = this.clusterCoordinator.getClusterWorkload();
                clusterWorkload.forEach((nodeId, workload) -> {
                    String siteToSiteHostname = nodeId.getSiteToSiteAddress() == null ? nodeId.getApiAddress() : nodeId.getSiteToSiteAddress();
                    int siteToSitePort = nodeId.getSiteToSiteHttpApiPort() == null ? nodeId.getApiPort() : nodeId.getSiteToSiteHttpApiPort().intValue();
                    PeerDescription target = new PeerDescription(siteToSiteHostname, siteToSitePort, nodeId.isSiteToSiteSecure());
                    if (modificationNeeded) {
                        target = this.peerDescriptionModifier.modify(source, target, SiteToSiteTransportProtocol.HTTP, PeerDescriptionModifier.RequestType.Peers, new HashMap(headers));
                    }
                    PeerDTO peer = new PeerDTO();
                    peer.setHostname(target.getHostname());
                    peer.setPort(target.getPort());
                    peer.setSecure(target.isSecure());
                    peer.setFlowFileCount(workload.getFlowFileCount());
                    peers.add(peer);
                });
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to retrieve cluster workload due to " + e, e);
            }
        } else {
            PeerDTO peer = new PeerDTO();
            String siteToSiteHostname = this.getSiteToSiteHostname(req);
            PeerDescription target = new PeerDescription(siteToSiteHostname, this.properties.getRemoteInputHttpPort().intValue(), this.properties.isSiteToSiteSecure().booleanValue());
            if (modificationNeeded) {
                target = this.peerDescriptionModifier.modify(source, target, SiteToSiteTransportProtocol.HTTP, PeerDescriptionModifier.RequestType.Peers, new HashMap(headers));
            }
            peer.setHostname(target.getHostname());
            peer.setPort(target.getPort());
            peer.setSecure(target.isSecure());
            peer.setFlowFileCount(0);
            peers.add(peer);
        }
        PeersEntity entity = new PeersEntity();
        entity.setPeers(peers);
        return this.noCache(this.setCommonHeaders(Response.ok((Object)entity), transportProtocolVersion, this.transactionManager)).build();
    }

    private String getSiteToSiteHostname(HttpServletRequest req) {
        String localName;
        String remoteInputHost = this.properties.getRemoteInputHost();
        try {
            localName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Failed to get local host name using InetAddress.", (Throwable)e);
            }
            localName = req.getLocalName();
        }
        return StringUtils.isEmpty((CharSequence)remoteInputHost) ? localName : remoteInputHost;
    }

    public void setServiceFacade(NiFiServiceFacade serviceFacade) {
        this.serviceFacade = serviceFacade;
    }

    public void setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
    }

    public void setClusterCoordinator(ClusterCoordinator clusterCoordinator) {
        super.setClusterCoordinator(clusterCoordinator);
        this.clusterCoordinator = clusterCoordinator;
    }
}

