/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.Collection;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.api.ApplicationResource;
import org.apache.nifi.web.api.dto.SystemDiagnosticsDTO;
import org.apache.nifi.web.api.entity.JmxMetricsResultsEntity;
import org.apache.nifi.web.api.entity.SystemDiagnosticsEntity;
import org.apache.nifi.web.api.metrics.jmx.JmxMetricsService;

@Path(value="/system-diagnostics")
@Api(value="/system-diagnostics", description="Endpoint for accessing system diagnostics.")
public class SystemDiagnosticsResource
extends ApplicationResource {
    private JmxMetricsService jmxMetricsService;
    private NiFiServiceFacade serviceFacade;
    private Authorizer authorizer;

    private void authorizeSystem() {
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable system = lookup.getSystem();
            system.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Gets the diagnostics for the system NiFi is running on", response=SystemDiagnosticsEntity.class, authorizations={@Authorization(value="Read - /system")})
    @ApiResponses(value={@ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request.")})
    public Response getSystemDiagnostics(@ApiParam(value="Whether or not to include the breakdown per node. Optional, defaults to false", required=false) @QueryParam(value="nodewise") @DefaultValue(value="false") Boolean nodewise, @ApiParam(value="The id of the node where to get the status.", required=false) @QueryParam(value="clusterNodeId") String clusterNodeId) throws InterruptedException {
        this.authorizeSystem();
        if (Boolean.TRUE.equals(nodewise) && clusterNodeId != null) {
            throw new IllegalArgumentException("Nodewise requests cannot be directed at a specific node.");
        }
        if (this.isReplicateRequest()) {
            if (clusterNodeId == null) {
                NodeResponse nodeResponse = this.getReplicationTarget() == ApplicationResource.ReplicationTarget.CLUSTER_NODES ? this.getRequestReplicator().replicate("GET", this.getAbsolutePath(), (Object)this.getRequestParameters(), this.getHeaders()).awaitMergedResponse() : this.getRequestReplicator().forwardToCoordinator(this.getClusterCoordinatorNode(), "GET", this.getAbsolutePath(), (Object)this.getRequestParameters(), this.getHeaders()).awaitMergedResponse();
                SystemDiagnosticsEntity entity = (SystemDiagnosticsEntity)nodeResponse.getUpdatedEntity();
                if (entity != null && !nodewise.booleanValue()) {
                    entity.getSystemDiagnostics().setNodeSnapshots(null);
                }
                return nodeResponse.getResponse();
            }
            return this.replicate("GET");
        }
        SystemDiagnosticsDTO systemDiagnosticsDto = this.serviceFacade.getSystemDiagnostics();
        SystemDiagnosticsEntity entity = new SystemDiagnosticsEntity();
        entity.setSystemDiagnostics(systemDiagnosticsDto);
        return this.generateOkResponse((Object)entity).build();
    }

    @Path(value="jmx-metrics")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve available JMX metrics", notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", response=JmxMetricsResultsEntity.class, authorizations={@Authorization(value="Read - /system")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getJmxMetrics(@ApiParam(value="Regular Expression Pattern to be applied against the ObjectName") @QueryParam(value="beanNameFilter") String beanNameFilter) {
        this.authorizeJmxMetrics();
        Collection results = this.jmxMetricsService.getFilteredMBeanMetrics(beanNameFilter);
        JmxMetricsResultsEntity entity = new JmxMetricsResultsEntity();
        entity.setJmxMetricsResults(results);
        return this.generateOkResponse((Object)entity).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    private void authorizeJmxMetrics() {
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable system = lookup.getSystem();
            system.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
    }

    public void setServiceFacade(NiFiServiceFacade serviceFacade) {
        this.serviceFacade = serviceFacade;
    }

    public void setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
    }

    public void setJmxMetricsService(JmxMetricsService jmxMetricsService) {
        this.jmxMetricsService = jmxMetricsService;
    }
}

