/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.ProcessGroupAuthorizable;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.resource.OperationAuthorizable;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.groups.RemoteProcessGroup;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.Revision;
import org.apache.nifi.web.api.ApplicationResource;
import org.apache.nifi.web.api.dto.ComponentStateDTO;
import org.apache.nifi.web.api.dto.PositionDTO;
import org.apache.nifi.web.api.dto.RemoteProcessGroupDTO;
import org.apache.nifi.web.api.dto.RemoteProcessGroupPortDTO;
import org.apache.nifi.web.api.dto.RevisionDTO;
import org.apache.nifi.web.api.entity.ComponentEntity;
import org.apache.nifi.web.api.entity.ComponentStateEntity;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.entity.RemotePortRunStatusEntity;
import org.apache.nifi.web.api.entity.RemoteProcessGroupEntity;
import org.apache.nifi.web.api.entity.RemoteProcessGroupPortEntity;
import org.apache.nifi.web.api.entity.RemoteProcessGroupsEntity;
import org.apache.nifi.web.api.request.ClientIdParameter;
import org.apache.nifi.web.api.request.LongParameter;

@Path(value="/remote-process-groups")
@Api(value="/remote-process-groups", description="Endpoint for managing a Remote Process Group.")
public class RemoteProcessGroupResource
extends ApplicationResource {
    private NiFiServiceFacade serviceFacade;
    private Authorizer authorizer;

    public Set<RemoteProcessGroupEntity> populateRemainingRemoteProcessGroupEntitiesContent(Set<RemoteProcessGroupEntity> remoteProcessGroupEntities) {
        for (RemoteProcessGroupEntity remoteProcessEntities : remoteProcessGroupEntities) {
            this.populateRemainingRemoteProcessGroupEntityContent(remoteProcessEntities);
        }
        return remoteProcessGroupEntities;
    }

    public RemoteProcessGroupEntity populateRemainingRemoteProcessGroupEntityContent(RemoteProcessGroupEntity remoteProcessGroupEntity) {
        remoteProcessGroupEntity.setUri(this.generateResourceUri(new String[]{"remote-process-groups", remoteProcessGroupEntity.getId()}));
        return remoteProcessGroupEntity;
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @ApiOperation(value="Gets a remote process group", response=RemoteProcessGroupEntity.class, authorizations={@Authorization(value="Read - /remote-process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getRemoteProcessGroup(@ApiParam(value="The remote process group id.", required=true) @PathParam(value="id") String id) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable remoteProcessGroup = lookup.getRemoteProcessGroup(id);
            remoteProcessGroup.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        RemoteProcessGroupEntity entity = this.serviceFacade.getRemoteProcessGroup(id);
        this.populateRemainingRemoteProcessGroupEntityContent(entity);
        return this.generateOkResponse((Object)entity).build();
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @ApiOperation(value="Deletes a remote process group", response=RemoteProcessGroupEntity.class, authorizations={@Authorization(value="Write - /remote-process-groups/{uuid}"), @Authorization(value="Write - Parent Process Group - /process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response removeRemoteProcessGroup(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The revision is used to verify the client is working with the latest version of the flow.", required=false) @QueryParam(value="version") LongParameter version, @ApiParam(value="If the client id is not specified, new one will be generated. This value (whether specified or generated) is included in the response.", required=false) @QueryParam(value="clientId") @DefaultValue(value="") ClientIdParameter clientId, @ApiParam(value="Acknowledges that this node is disconnected to allow for mutable requests to proceed.", required=false) @QueryParam(value="disconnectedNodeAcknowledged") @DefaultValue(value="false") Boolean disconnectedNodeAcknowledged, @ApiParam(value="The remote process group id.", required=true) @PathParam(value="id") String id) {
        if (this.isReplicateRequest()) {
            return this.replicate("DELETE");
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(disconnectedNodeAcknowledged);
        }
        RemoteProcessGroupEntity requestRemoteProcessGroupEntity = new RemoteProcessGroupEntity();
        requestRemoteProcessGroupEntity.setId(id);
        Revision requestRevision = new Revision(version == null ? null : version.getLong(), clientId.getClientId(), id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestRemoteProcessGroupEntity, requestRevision, lookup -> {
            Authorizable remoteProcessGroup = lookup.getRemoteProcessGroup(id);
            remoteProcessGroup.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
            remoteProcessGroup.getParentAuthorizable().authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, () -> this.serviceFacade.verifyDeleteRemoteProcessGroup(id), (revision, remoteProcessGroupEntity) -> {
            RemoteProcessGroupEntity entity = this.serviceFacade.deleteRemoteProcessGroup(revision, remoteProcessGroupEntity.getId());
            return this.generateOkResponse((Object)entity).build();
        });
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}/input-ports/{port-id}")
    @ApiOperation(value="Updates a remote port", notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", response=RemoteProcessGroupPortEntity.class, authorizations={@Authorization(value="Write - /remote-process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response updateRemoteProcessGroupInputPort(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The remote process group id.", required=true) @PathParam(value="id") String id, @ApiParam(value="The remote process group port id.", required=true) @PathParam(value="port-id") String portId, @ApiParam(value="The remote process group port.", required=true) RemoteProcessGroupPortEntity requestRemoteProcessGroupPortEntity) {
        if (requestRemoteProcessGroupPortEntity == null || requestRemoteProcessGroupPortEntity.getRemoteProcessGroupPort() == null) {
            throw new IllegalArgumentException("Remote process group port details must be specified.");
        }
        if (requestRemoteProcessGroupPortEntity.getRevision() == null) {
            throw new IllegalArgumentException("Revision must be specified.");
        }
        RemoteProcessGroupPortDTO requestRemoteProcessGroupPort = requestRemoteProcessGroupPortEntity.getRemoteProcessGroupPort();
        if (!portId.equals(requestRemoteProcessGroupPort.getId())) {
            throw new IllegalArgumentException(String.format("The remote process group port id (%s) in the request body does not equal the remote process group port id of the requested resource (%s).", requestRemoteProcessGroupPort.getId(), portId));
        }
        if (!id.equals(requestRemoteProcessGroupPort.getGroupId())) {
            throw new IllegalArgumentException(String.format("The remote process group id (%s) in the request body does not equal the remote process group id of the requested resource (%s).", requestRemoteProcessGroupPort.getGroupId(), id));
        }
        if (this.isReplicateRequest()) {
            return this.replicate("PUT", (Object)requestRemoteProcessGroupPortEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestRemoteProcessGroupPortEntity.isDisconnectedNodeAcknowledged());
        }
        Revision requestRevision = this.getRevision((ComponentEntity)requestRemoteProcessGroupPortEntity, id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestRemoteProcessGroupPortEntity, requestRevision, lookup -> {
            Authorizable remoteProcessGroup = lookup.getRemoteProcessGroup(id);
            remoteProcessGroup.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, () -> this.serviceFacade.verifyUpdateRemoteProcessGroupInputPort(id, requestRemoteProcessGroupPort), (revision, remoteProcessGroupPortEntity) -> {
            RemoteProcessGroupPortDTO remoteProcessGroupPort = remoteProcessGroupPortEntity.getRemoteProcessGroupPort();
            RemoteProcessGroupPortEntity controllerResponse = this.serviceFacade.updateRemoteProcessGroupInputPort(revision, id, remoteProcessGroupPort);
            RevisionDTO updatedRevision = controllerResponse.getRevision();
            RemoteProcessGroupPortEntity entity = new RemoteProcessGroupPortEntity();
            entity.setRevision(updatedRevision);
            entity.setRemoteProcessGroupPort(controllerResponse.getRemoteProcessGroupPort());
            return this.generateOkResponse((Object)entity).build();
        });
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}/output-ports/{port-id}")
    @ApiOperation(value="Updates a remote port", notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", response=RemoteProcessGroupPortEntity.class, authorizations={@Authorization(value="Write - /remote-process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response updateRemoteProcessGroupOutputPort(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The remote process group id.", required=true) @PathParam(value="id") String id, @ApiParam(value="The remote process group port id.", required=true) @PathParam(value="port-id") String portId, @ApiParam(value="The remote process group port.", required=true) RemoteProcessGroupPortEntity requestRemoteProcessGroupPortEntity) {
        if (requestRemoteProcessGroupPortEntity == null || requestRemoteProcessGroupPortEntity.getRemoteProcessGroupPort() == null) {
            throw new IllegalArgumentException("Remote process group port details must be specified.");
        }
        if (requestRemoteProcessGroupPortEntity.getRevision() == null) {
            throw new IllegalArgumentException("Revision must be specified.");
        }
        RemoteProcessGroupPortDTO requestRemoteProcessGroupPort = requestRemoteProcessGroupPortEntity.getRemoteProcessGroupPort();
        if (!portId.equals(requestRemoteProcessGroupPort.getId())) {
            throw new IllegalArgumentException(String.format("The remote process group port id (%s) in the request body does not equal the remote process group port id of the requested resource (%s).", requestRemoteProcessGroupPort.getId(), portId));
        }
        if (!id.equals(requestRemoteProcessGroupPort.getGroupId())) {
            throw new IllegalArgumentException(String.format("The remote process group id (%s) in the request body does not equal the remote process group id of the requested resource (%s).", requestRemoteProcessGroupPort.getGroupId(), id));
        }
        if (this.isReplicateRequest()) {
            return this.replicate("PUT", (Object)requestRemoteProcessGroupPortEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestRemoteProcessGroupPortEntity.isDisconnectedNodeAcknowledged());
        }
        Revision requestRevision = this.getRevision((ComponentEntity)requestRemoteProcessGroupPortEntity, id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestRemoteProcessGroupPortEntity, requestRevision, lookup -> {
            Authorizable remoteProcessGroup = lookup.getRemoteProcessGroup(id);
            remoteProcessGroup.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, () -> this.serviceFacade.verifyUpdateRemoteProcessGroupOutputPort(id, requestRemoteProcessGroupPort), (revision, remoteProcessGroupPortEntity) -> {
            RemoteProcessGroupPortDTO remoteProcessGroupPort = remoteProcessGroupPortEntity.getRemoteProcessGroupPort();
            RemoteProcessGroupPortEntity controllerResponse = this.serviceFacade.updateRemoteProcessGroupOutputPort(revision, id, remoteProcessGroupPort);
            RevisionDTO updatedRevision = controllerResponse.getRevision();
            RemoteProcessGroupPortEntity entity = new RemoteProcessGroupPortEntity();
            entity.setRevision(updatedRevision);
            entity.setRemoteProcessGroupPort(controllerResponse.getRemoteProcessGroupPort());
            return this.generateOkResponse((Object)entity).build();
        });
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}/input-ports/{port-id}/run-status")
    @ApiOperation(value="Updates run status of a remote port", notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", response=RemoteProcessGroupPortEntity.class, authorizations={@Authorization(value="Write - /remote-process-groups/{uuid} or /operation/remote-process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response updateRemoteProcessGroupInputPortRunStatus(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The remote process group id.", required=true) @PathParam(value="id") String id, @ApiParam(value="The remote process group port id.", required=true) @PathParam(value="port-id") String portId, @ApiParam(value="The remote process group port.", required=true) RemotePortRunStatusEntity requestRemotePortRunStatusEntity) {
        if (requestRemotePortRunStatusEntity == null) {
            throw new IllegalArgumentException("Remote process group port run status must be specified.");
        }
        if (requestRemotePortRunStatusEntity.getRevision() == null) {
            throw new IllegalArgumentException("Revision must be specified.");
        }
        requestRemotePortRunStatusEntity.validateState();
        if (this.isReplicateRequest()) {
            return this.replicate("PUT", (Object)requestRemotePortRunStatusEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestRemotePortRunStatusEntity.isDisconnectedNodeAcknowledged());
        }
        Revision requestRevision = this.getRevision(requestRemotePortRunStatusEntity.getRevision(), id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestRemotePortRunStatusEntity, requestRevision, lookup -> {
            Authorizable remoteProcessGroup = lookup.getRemoteProcessGroup(id);
            OperationAuthorizable.authorizeOperation((Authorizable)remoteProcessGroup, (Authorizer)this.authorizer, (NiFiUser)NiFiUserUtils.getNiFiUser());
        }, () -> this.serviceFacade.verifyUpdateRemoteProcessGroupInputPort(id, this.createPortDTOWithDesiredRunStatus(portId, id, requestRemotePortRunStatusEntity)), (revision, remotePortRunStatusEntity) -> {
            RemoteProcessGroupPortEntity controllerResponse = this.serviceFacade.updateRemoteProcessGroupInputPort(revision, id, this.createPortDTOWithDesiredRunStatus(portId, id, remotePortRunStatusEntity));
            RevisionDTO updatedRevision = controllerResponse.getRevision();
            RemoteProcessGroupPortEntity entity = new RemoteProcessGroupPortEntity();
            entity.setRevision(updatedRevision);
            entity.setRemoteProcessGroupPort(controllerResponse.getRemoteProcessGroupPort());
            return this.generateOkResponse((Object)entity).build();
        });
    }

    private RemoteProcessGroupPortDTO createPortDTOWithDesiredRunStatus(String portId, String groupId, RemotePortRunStatusEntity entity) {
        RemoteProcessGroupPortDTO dto = new RemoteProcessGroupPortDTO();
        dto.setId(portId);
        dto.setGroupId(groupId);
        dto.setTransmitting(Boolean.valueOf(this.shouldTransmit(entity)));
        return dto;
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}/output-ports/{port-id}/run-status")
    @ApiOperation(value="Updates run status of a remote port", notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", response=RemoteProcessGroupPortEntity.class, authorizations={@Authorization(value="Write - /remote-process-groups/{uuid} or /operation/remote-process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response updateRemoteProcessGroupOutputPortRunStatus(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The remote process group id.", required=true) @PathParam(value="id") String id, @ApiParam(value="The remote process group port id.", required=true) @PathParam(value="port-id") String portId, @ApiParam(value="The remote process group port.", required=true) RemotePortRunStatusEntity requestRemotePortRunStatusEntity) {
        if (requestRemotePortRunStatusEntity == null) {
            throw new IllegalArgumentException("Remote process group port run status must be specified.");
        }
        if (requestRemotePortRunStatusEntity.getRevision() == null) {
            throw new IllegalArgumentException("Revision must be specified.");
        }
        requestRemotePortRunStatusEntity.validateState();
        if (this.isReplicateRequest()) {
            return this.replicate("PUT", (Object)requestRemotePortRunStatusEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestRemotePortRunStatusEntity.isDisconnectedNodeAcknowledged());
        }
        Revision requestRevision = this.getRevision(requestRemotePortRunStatusEntity.getRevision(), id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestRemotePortRunStatusEntity, requestRevision, lookup -> {
            Authorizable remoteProcessGroup = lookup.getRemoteProcessGroup(id);
            OperationAuthorizable.authorizeOperation((Authorizable)remoteProcessGroup, (Authorizer)this.authorizer, (NiFiUser)NiFiUserUtils.getNiFiUser());
        }, () -> this.serviceFacade.verifyUpdateRemoteProcessGroupOutputPort(id, this.createPortDTOWithDesiredRunStatus(portId, id, requestRemotePortRunStatusEntity)), (revision, remotePortRunStatusEntity) -> {
            RemoteProcessGroupPortEntity controllerResponse = this.serviceFacade.updateRemoteProcessGroupOutputPort(revision, id, this.createPortDTOWithDesiredRunStatus(portId, id, remotePortRunStatusEntity));
            RevisionDTO updatedRevision = controllerResponse.getRevision();
            RemoteProcessGroupPortEntity entity = new RemoteProcessGroupPortEntity();
            entity.setRevision(updatedRevision);
            entity.setRemoteProcessGroupPort(controllerResponse.getRemoteProcessGroupPort());
            return this.generateOkResponse((Object)entity).build();
        });
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @ApiOperation(value="Updates a remote process group", response=RemoteProcessGroupEntity.class, authorizations={@Authorization(value="Write - /remote-process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response updateRemoteProcessGroup(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The remote process group id.", required=true) @PathParam(value="id") String id, @ApiParam(value="The remote process group.", required=true) RemoteProcessGroupEntity requestRemoteProcessGroupEntity) {
        if (requestRemoteProcessGroupEntity == null || requestRemoteProcessGroupEntity.getComponent() == null) {
            throw new IllegalArgumentException("Remote process group details must be specified.");
        }
        if (requestRemoteProcessGroupEntity.getRevision() == null) {
            throw new IllegalArgumentException("Revision must be specified.");
        }
        RemoteProcessGroupDTO requestRemoteProcessGroup = requestRemoteProcessGroupEntity.getComponent();
        if (!id.equals(requestRemoteProcessGroup.getId())) {
            throw new IllegalArgumentException(String.format("The remote process group id (%s) in the request body does not equal the remote process group id of the requested resource (%s).", requestRemoteProcessGroup.getId(), id));
        }
        PositionDTO proposedPosition = requestRemoteProcessGroup.getPosition();
        if (proposedPosition != null && (proposedPosition.getX() == null || proposedPosition.getY() == null)) {
            throw new IllegalArgumentException("The x and y coordinate of the proposed position must be specified.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("PUT", (Object)requestRemoteProcessGroupEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestRemoteProcessGroupEntity.isDisconnectedNodeAcknowledged());
        }
        Revision requestRevision = this.getRevision((ComponentEntity)requestRemoteProcessGroupEntity, id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestRemoteProcessGroupEntity, requestRevision, lookup -> {
            Authorizable authorizable = lookup.getRemoteProcessGroup(id);
            authorizable.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, () -> this.serviceFacade.verifyUpdateRemoteProcessGroup(requestRemoteProcessGroup), (revision, remoteProcessGroupEntity) -> {
            RemoteProcessGroupDTO remoteProcessGroup = remoteProcessGroupEntity.getComponent();
            if (remoteProcessGroup.getTargetUri() != null) {
                URI uri;
                try {
                    uri = URI.create(remoteProcessGroup.getTargetUri());
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("The specified remote process group URL is malformed: " + remoteProcessGroup.getTargetUri());
                }
                if (uri.getScheme() == null || uri.getHost() == null) {
                    throw new IllegalArgumentException("The specified remote process group URL is malformed: " + remoteProcessGroup.getTargetUri());
                }
                if (!uri.getScheme().equalsIgnoreCase("http") && !uri.getScheme().equalsIgnoreCase("https")) {
                    throw new IllegalArgumentException("The specified remote process group URL is invalid because it is not http or https: " + remoteProcessGroup.getTargetUri());
                }
                String controllerUri = uri.toString();
                if (controllerUri.endsWith("/")) {
                    controllerUri = StringUtils.substringBeforeLast((String)controllerUri, (String)"/");
                }
                remoteProcessGroup.setTargetUri(controllerUri);
            }
            RemoteProcessGroupEntity entity = this.serviceFacade.updateRemoteProcessGroup(revision, remoteProcessGroup);
            this.populateRemainingRemoteProcessGroupEntityContent(entity);
            return this.generateOkResponse((Object)entity).build();
        });
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}/run-status")
    @ApiOperation(value="Updates run status of a remote process group", response=RemoteProcessGroupEntity.class, authorizations={@Authorization(value="Write - /remote-process-groups/{uuid} or /operation/remote-process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response updateRemoteProcessGroupRunStatus(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The remote process group id.", required=true) @PathParam(value="id") String id, @ApiParam(value="The remote process group run status.", required=true) RemotePortRunStatusEntity requestRemotePortRunStatusEntity) {
        if (requestRemotePortRunStatusEntity == null) {
            throw new IllegalArgumentException("Remote process group run status must be specified.");
        }
        if (requestRemotePortRunStatusEntity.getRevision() == null) {
            throw new IllegalArgumentException("Revision must be specified.");
        }
        requestRemotePortRunStatusEntity.validateState();
        if (this.isReplicateRequest()) {
            return this.replicate("PUT", (Object)requestRemotePortRunStatusEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestRemotePortRunStatusEntity.isDisconnectedNodeAcknowledged());
        }
        Revision requestRevision = this.getRevision(requestRemotePortRunStatusEntity.getRevision(), id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestRemotePortRunStatusEntity, requestRevision, lookup -> {
            Authorizable authorizable = lookup.getRemoteProcessGroup(id);
            OperationAuthorizable.authorizeOperation((Authorizable)authorizable, (Authorizer)this.authorizer, (NiFiUser)NiFiUserUtils.getNiFiUser());
        }, () -> this.serviceFacade.verifyUpdateRemoteProcessGroup(this.createDTOWithDesiredRunStatus(id, requestRemotePortRunStatusEntity)), (revision, remotePortRunStatusEntity) -> {
            RemoteProcessGroupEntity entity = this.serviceFacade.updateRemoteProcessGroup(revision, this.createDTOWithDesiredRunStatus(id, remotePortRunStatusEntity));
            this.populateRemainingRemoteProcessGroupEntityContent(entity);
            return this.generateOkResponse((Object)entity).build();
        });
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="process-group/{id}/run-status")
    @ApiOperation(value="Updates run status of all remote process groups in a process group (recursively)", response=RemoteProcessGroupEntity.class, authorizations={@Authorization(value="Write - /remote-process-groups/{uuid} or /operation/remote-process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response updateRemoteProcessGroupRunStatuses(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The process group id.", required=true) @PathParam(value="id") String processGroupId, @ApiParam(value="The remote process groups run status.", required=true) RemotePortRunStatusEntity requestRemotePortRunStatusEntity) {
        if (requestRemotePortRunStatusEntity == null) {
            throw new IllegalArgumentException("Remote process group run status must be specified.");
        }
        requestRemotePortRunStatusEntity.validateState();
        if (this.isReplicateRequest()) {
            return this.replicate("PUT", (Object)requestRemotePortRunStatusEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestRemotePortRunStatusEntity.isDisconnectedNodeAcknowledged());
        }
        Set revisions = this.serviceFacade.getRevisionsFromGroup(processGroupId, group -> group.findAllRemoteProcessGroups().stream().filter(remoteProcessGroup -> requestRemotePortRunStatusEntity.getState().equals("TRANSMITTING") && !remoteProcessGroup.isTransmitting() || requestRemotePortRunStatusEntity.getState().equals("STOPPED") && remoteProcessGroup.isTransmitting()).filter(remoteProcessGroup -> OperationAuthorizable.isOperationAuthorized((Authorizable)remoteProcessGroup, (Authorizer)this.authorizer, (NiFiUser)NiFiUserUtils.getNiFiUser())).map(RemoteProcessGroup::getIdentifier).collect(Collectors.toSet()));
        return this.withWriteLock(this.serviceFacade, (Entity)requestRemotePortRunStatusEntity, revisions, lookup -> {
            ProcessGroupAuthorizable processGroup = lookup.getProcessGroup(processGroupId);
            this.authorizeProcessGroup(processGroup, this.authorizer, lookup, RequestAction.READ, false, false, false, false, false);
            Set remoteProcessGroups = processGroup.getEncapsulatedRemoteProcessGroups();
            for (Authorizable remoteProcessGroup : remoteProcessGroups) {
                OperationAuthorizable.authorizeOperation((Authorizable)remoteProcessGroup, (Authorizer)this.authorizer, (NiFiUser)NiFiUserUtils.getNiFiUser());
            }
        }, () -> this.serviceFacade.verifyUpdateRemoteProcessGroups(processGroupId, this.shouldTransmit(requestRemotePortRunStatusEntity)), (_revisions, remotePortRunStatusEntity) -> {
            Set remoteProcessGroupEntities = _revisions.stream().map(revision -> {
                RemoteProcessGroupEntity entity = this.serviceFacade.updateRemoteProcessGroup(revision, this.createDTOWithDesiredRunStatus(revision.getComponentId(), remotePortRunStatusEntity));
                this.populateRemainingRemoteProcessGroupEntityContent(entity);
                return entity;
            }).collect(Collectors.toSet());
            RemoteProcessGroupsEntity remoteProcessGroupsEntity = new RemoteProcessGroupsEntity();
            Response response = this.generateOkResponse((Object)remoteProcessGroupsEntity).build();
            return response;
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="/{id}/state")
    @ApiOperation(value="Gets the state for a RemoteProcessGroup", response=ComponentStateEntity.class, authorizations={@Authorization(value="Write - /remote-process-groups/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getState(@ApiParam(value="The processor id.", required=true) @PathParam(value="id") String id) throws InterruptedException {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable authorizable = lookup.getRemoteProcessGroup(id);
            authorizable.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        });
        ComponentStateDTO state = this.serviceFacade.getRemoteProcessGroupState(id);
        ComponentStateEntity entity = new ComponentStateEntity();
        entity.setComponentState(state);
        return this.generateOkResponse((Object)entity).build();
    }

    private RemoteProcessGroupDTO createDTOWithDesiredRunStatus(String id, RemotePortRunStatusEntity entity) {
        RemoteProcessGroupDTO dto = new RemoteProcessGroupDTO();
        dto.setId(id);
        dto.setTransmitting(Boolean.valueOf(this.shouldTransmit(entity)));
        return dto;
    }

    private boolean shouldTransmit(RemotePortRunStatusEntity requestRemotePortRunStatusEntity) {
        return "TRANSMITTING".equals(requestRemotePortRunStatusEntity.getState());
    }

    public void setServiceFacade(NiFiServiceFacade serviceFacade) {
        this.serviceFacade = serviceFacade;
    }

    public void setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
    }
}

