/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import java.net.URI;
import java.util.Collections;
import org.apache.nifi.authorization.AccessDeniedException;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.cluster.coordination.ClusterCoordinator;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.controller.repository.claim.ContentDirection;
import org.apache.nifi.web.DownloadableContent;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.api.ApplicationResource;
import org.apache.nifi.web.api.ProvenanceEventResource;
import org.apache.nifi.web.api.dto.provenance.ProvenanceEventDTO;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.entity.ProvenanceEventEntity;
import org.apache.nifi.web.api.entity.ReplayLastEventRequestEntity;
import org.apache.nifi.web.api.entity.ReplayLastEventResponseEntity;
import org.apache.nifi.web.api.entity.ReplayLastEventSnapshotDTO;
import org.apache.nifi.web.api.entity.SubmitReplayRequestEntity;
import org.apache.nifi.web.api.request.LongParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/provenance-events")
@Api(value="/provenance-events", description="Endpoint for accessing data flow provenance.")
public class ProvenanceEventResource
extends ApplicationResource {
    private static final Logger logger = LoggerFactory.getLogger(ProvenanceEventResource.class);
    private NiFiServiceFacade serviceFacade;
    private Authorizer authorizer;

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"*/*"})
    @Path(value="{id}/content/input")
    @ApiOperation(value="Gets the input content for a provenance event", response=StreamingOutput.class, authorizations={@Authorization(value="Read Component Provenance Data - /provenance-data/{component-type}/{uuid}"), @Authorization(value="Read Component Data - /data/{component-type}/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getInputContent(@ApiParam(value="The id of the node where the content exists if clustered.", required=false) @QueryParam(value="clusterNodeId") String clusterNodeId, @ApiParam(value="The provenance event id.", required=true) @PathParam(value="id") LongParameter id) {
        if (id == null) {
            throw new IllegalArgumentException("The event id must be specified.");
        }
        if (this.isReplicateRequest()) {
            if (clusterNodeId == null) {
                throw new IllegalArgumentException("The id of the node in the cluster is required.");
            }
            return this.replicate("GET", clusterNodeId);
        }
        String uri = this.generateResourceUri(new String[]{"provenance", "events", String.valueOf(id.getLong()), "content", "input"});
        DownloadableContent content = this.serviceFacade.getContent(id.getLong(), uri, ContentDirection.INPUT);
        1 response = new /* Unavailable Anonymous Inner Class!! */;
        String contentType = content.getType();
        if (contentType == null) {
            contentType = "application/octet-stream";
        }
        return this.generateOkResponse((Object)response).type(contentType).header("Content-Disposition", (Object)String.format("attachment; filename=\"%s\"", content.getFilename())).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"*/*"})
    @Path(value="{id}/content/output")
    @ApiOperation(value="Gets the output content for a provenance event", response=StreamingOutput.class, authorizations={@Authorization(value="Read Component Provenance Data - /provenance-data/{component-type}/{uuid}"), @Authorization(value="Read Component Data - /data/{component-type}/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getOutputContent(@ApiParam(value="The id of the node where the content exists if clustered.", required=false) @QueryParam(value="clusterNodeId") String clusterNodeId, @ApiParam(value="The provenance event id.", required=true) @PathParam(value="id") LongParameter id) {
        if (id == null) {
            throw new IllegalArgumentException("The event id must be specified.");
        }
        if (this.isReplicateRequest()) {
            if (clusterNodeId == null) {
                throw new IllegalArgumentException("The id of the node in the cluster is required.");
            }
            return this.replicate("GET", clusterNodeId);
        }
        String uri = this.generateResourceUri(new String[]{"provenance", "events", String.valueOf(id.getLong()), "content", "output"});
        DownloadableContent content = this.serviceFacade.getContent(id.getLong(), uri, ContentDirection.OUTPUT);
        2 response = new /* Unavailable Anonymous Inner Class!! */;
        String contentType = content.getType();
        if (contentType == null) {
            contentType = "application/octet-stream";
        }
        return this.generateOkResponse((Object)response).type(contentType).header("Content-Disposition", (Object)String.format("attachment; filename=\"%s\"", content.getFilename())).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @ApiOperation(value="Gets a provenance event", response=ProvenanceEventEntity.class, authorizations={@Authorization(value="Read Component Provenance Data - /provenance-data/{component-type}/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getProvenanceEvent(@ApiParam(value="The id of the node where this event exists if clustered.", required=false) @QueryParam(value="clusterNodeId") String clusterNodeId, @ApiParam(value="The provenance event id.", required=true) @PathParam(value="id") LongParameter id) {
        NodeIdentifier nodeId;
        if (id == null) {
            throw new IllegalArgumentException("Provenance event id must be specified.");
        }
        if (this.isReplicateRequest()) {
            if (clusterNodeId == null) {
                throw new IllegalArgumentException("The cluster node identifier must be specified.");
            }
            return this.replicate("GET", clusterNodeId);
        }
        ProvenanceEventDTO event = this.serviceFacade.getProvenanceEvent(id.getLong());
        event.setClusterNodeId(clusterNodeId);
        ClusterCoordinator coordinator = this.getClusterCoordinator();
        if (coordinator != null && clusterNodeId != null && (nodeId = coordinator.getNodeIdentifier(clusterNodeId)) != null) {
            event.setClusterNodeAddress(nodeId.getApiAddress() + ":" + nodeId.getApiPort());
        }
        ProvenanceEventEntity entity = new ProvenanceEventEntity();
        entity.setProvenanceEvent(event);
        return this.generateOkResponse((Object)entity).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="latest/replays")
    @ApiOperation(value="Replays content from a provenance event", response=ReplayLastEventResponseEntity.class, authorizations={@Authorization(value="Read Component Provenance Data - /provenance-data/{component-type}/{uuid}"), @Authorization(value="Read Component Data - /data/{component-type}/{uuid}"), @Authorization(value="Write Component Data - /data/{component-type}/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response submitReplayLatestEvent(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The replay request.", required=true) ReplayLastEventRequestEntity requestEntity) {
        if (requestEntity == null || requestEntity.getComponentId() == null) {
            throw new IllegalArgumentException("The id of the component must be specified.");
        }
        String requestedNodes = requestEntity.getNodes();
        if (requestedNodes == null) {
            throw new IllegalArgumentException("The nodes must be specified.");
        }
        if (!"ALL".equalsIgnoreCase(requestedNodes) && !"PRIMARY".equalsIgnoreCase(requestedNodes)) {
            throw new IllegalArgumentException("The nodes must be either ALL or PRIMARY");
        }
        if (this.isReplicateRequest()) {
            if (requestedNodes.equalsIgnoreCase("PRIMARY")) {
                NodeIdentifier primaryNodeId = (NodeIdentifier)this.getPrimaryNodeId().orElseThrow(() -> new IllegalStateException("There is currently no Primary Node elected"));
                return this.replicate("POST", (Object)requestEntity, primaryNodeId.getId());
            }
            return this.replicate("POST", (Object)requestEntity);
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestEntity, lookup -> {
            Authorizable provenance = lookup.getProvenance();
            provenance.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        }, () -> {}, entity -> {
            ReplayLastEventSnapshotDTO aggregateSnapshot = new ReplayLastEventSnapshotDTO();
            try {
                ProvenanceEventDTO provenanceEventDto = this.serviceFacade.submitReplayLastEvent(entity.getComponentId());
                if (provenanceEventDto == null) {
                    aggregateSnapshot.setEventAvailable(Boolean.valueOf(false));
                } else {
                    aggregateSnapshot.setEventAvailable(Boolean.valueOf(true));
                    aggregateSnapshot.setEventsReplayed(Collections.singleton(provenanceEventDto.getEventId()));
                }
            }
            catch (AccessDeniedException ade) {
                logger.error("Failed to replay latest Provenance Event", (Throwable)ade);
                aggregateSnapshot.setFailureExplanation("Access Denied");
            }
            catch (Exception e) {
                logger.error("Failed to replay latest Provenance Event", (Throwable)e);
                aggregateSnapshot.setFailureExplanation(e.getMessage());
            }
            ReplayLastEventResponseEntity responseEntity = new ReplayLastEventResponseEntity();
            responseEntity.setComponentId(entity.getComponentId());
            responseEntity.setNodes(entity.getNodes());
            responseEntity.setAggregateSnapshot(aggregateSnapshot);
            return this.generateOkResponse((Object)responseEntity).build();
        });
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="replays")
    @ApiOperation(value="Replays content from a provenance event", response=ProvenanceEventEntity.class, authorizations={@Authorization(value="Read Component Provenance Data - /provenance-data/{component-type}/{uuid}"), @Authorization(value="Read Component Data - /data/{component-type}/{uuid}"), @Authorization(value="Write Component Data - /data/{component-type}/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response submitReplay(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The replay request.", required=true) SubmitReplayRequestEntity replayRequestEntity) {
        if (replayRequestEntity == null || replayRequestEntity.getEventId() == null) {
            throw new IllegalArgumentException("The id of the event must be specified.");
        }
        if (this.isReplicateRequest()) {
            if (replayRequestEntity.getClusterNodeId() == null) {
                throw new IllegalArgumentException("The id of the node in the cluster is required.");
            }
            return this.replicate("POST", (Object)replayRequestEntity, replayRequestEntity.getClusterNodeId());
        }
        String expects = httpServletRequest.getHeader("X-Validation-Expects");
        if (expects != null) {
            return this.generateContinueResponse().build();
        }
        ProvenanceEventDTO event = this.serviceFacade.submitReplay(replayRequestEntity.getEventId());
        event.setClusterNodeId(replayRequestEntity.getClusterNodeId());
        ClusterCoordinator coordinator = this.getClusterCoordinator();
        if (coordinator != null) {
            NodeIdentifier nodeId = coordinator.getNodeIdentifier(replayRequestEntity.getClusterNodeId());
            event.setClusterNodeAddress(nodeId.getApiAddress() + ":" + nodeId.getApiPort());
        }
        ProvenanceEventEntity entity = new ProvenanceEventEntity();
        entity.setProvenanceEvent(event);
        URI uri = URI.create(this.generateResourceUri(new String[]{"provenance-events", event.getId()}));
        return this.generateCreatedResponse(uri, (Object)entity).build();
    }

    public void setServiceFacade(NiFiServiceFacade serviceFacade) {
        this.serviceFacade = serviceFacade;
    }

    public void setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
    }
}

