/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.util;

import java.util.Collection;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.nifi.web.api.dto.ParameterContextDTO;
import org.apache.nifi.web.api.entity.ParameterContextEntity;

class ParameterContextNameCollisionResolver {
    private static final String PATTERN_GROUP_NAME = "name";
    private static final String PATTERN_GROUP_INDEX = "index";
    private static final String LINEAGE_FORMAT = "^(?<name>.+?)( \\((?<index>[0-9]+)\\))?$";
    private static final Pattern LINEAGE_PATTERN = Pattern.compile("^(?<name>.+?)( \\((?<index>[0-9]+)\\))?$");
    private static final String NAME_FORMAT = "%s (%d)";

    ParameterContextNameCollisionResolver() {
    }

    public String resolveNameCollision(String originalParameterContextName, Collection<ParameterContextEntity> existingContexts) {
        Matcher lineageMatcher = LINEAGE_PATTERN.matcher(originalParameterContextName);
        if (!lineageMatcher.matches()) {
            throw new IllegalArgumentException("Existing Parameter Context name \"(" + originalParameterContextName + "\") cannot be processed");
        }
        String lineName = lineageMatcher.group(PATTERN_GROUP_NAME);
        String originalIndex = lineageMatcher.group(PATTERN_GROUP_INDEX);
        Set candidates = existingContexts.stream().map(pc -> pc.getComponent()).filter(dto -> dto.getName().startsWith(lineName)).collect(Collectors.toSet());
        int biggestIndex = originalIndex == null ? 0 : Integer.valueOf(originalIndex);
        for (ParameterContextDTO candidate : candidates) {
            int biggestIndexCandidate;
            String indexGroup;
            Matcher matcher = LINEAGE_PATTERN.matcher(candidate.getName());
            if (!matcher.matches() || !lineName.equals(matcher.group(PATTERN_GROUP_NAME)) || (indexGroup = matcher.group(PATTERN_GROUP_INDEX)) == null || (biggestIndexCandidate = Integer.valueOf(indexGroup).intValue()) <= biggestIndex) continue;
            biggestIndex = biggestIndexCandidate;
        }
        return String.format(NAME_FORMAT, lineName, biggestIndex + 1);
    }
}

