/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.search.attributematchers;

import java.util.List;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.remote.PublicPort;
import org.apache.nifi.web.search.attributematchers.AttributeMatcher;
import org.apache.nifi.web.search.query.SearchQuery;

public class PublicPortMatcher
implements AttributeMatcher<Port> {
    private static final String LABEL_USER = "User access control";
    private static final String LABEL_GROUP = "Group access control";

    public void match(Port component, SearchQuery query, List<String> matches) {
        String searchTerm = query.getTerm();
        if (component instanceof PublicPort) {
            PublicPort publicPort = (PublicPort)component;
            publicPort.getUserAccessControl().forEach(control -> AttributeMatcher.addIfMatching((String)searchTerm, (String)control, (String)LABEL_USER, (List)matches));
            publicPort.getGroupAccessControl().forEach(control -> AttributeMatcher.addIfMatching((String)searchTerm, (String)control, (String)LABEL_GROUP, (List)matches));
        }
    }
}

