/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.metrics.jmx;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;
import org.apache.nifi.web.api.dto.JmxMetricsResultDTO;
import org.apache.nifi.web.api.metrics.jmx.JmxMetricsResultConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxMetricsCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmxMetricsCollector.class);
    private static final String PATTERN_FOR_ALL_OBJECT_NAMES = "*:*";
    private final JmxMetricsResultConverter resultConverter;

    public JmxMetricsCollector(JmxMetricsResultConverter metricsResultConverter) {
        this.resultConverter = metricsResultConverter;
    }

    public Collection<JmxMetricsResultDTO> getBeanMetrics() {
        Set<ObjectInstance> instances;
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        try {
            instances = mBeanServer.queryMBeans(new ObjectName(PATTERN_FOR_ALL_OBJECT_NAMES), null);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException("Invalid ObjectName pattern", e);
        }
        ArrayList<JmxMetricsResultDTO> results = new ArrayList<JmxMetricsResultDTO>();
        for (ObjectInstance instance : instances) {
            MBeanInfo info;
            try {
                info = mBeanServer.getMBeanInfo(instance.getObjectName());
            }
            catch (InstanceNotFoundException | IntrospectionException | ReflectionException e) {
                continue;
            }
            for (MBeanAttributeInfo attribute : info.getAttributes()) {
                try {
                    String beanName = instance.getObjectName().getCanonicalName();
                    String attributeName = attribute.getName();
                    Object attributeValue = this.resultConverter.convert(mBeanServer.getAttribute(instance.getObjectName(), attribute.getName()));
                    results.add(new JmxMetricsResultDTO(beanName, attributeName, attributeValue));
                }
                catch (AttributeNotFoundException | InstanceNotFoundException | MBeanException | ReflectionException | RuntimeMBeanException e) {
                    LOGGER.debug("MBean Object [{}] invalid attribute [{}] found", (Object)instance.getObjectName(), (Object)attribute.getName());
                }
            }
        }
        return results;
    }
}

